/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.id.GUID;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserManager;

public class FieldCustomUserField
extends UserField<String> {
    public static final String KEY_ONE = "custom1";
    public static final String KEY_TWO = "custom2";
    public static final String KEY_THREE = "custom3";
    public static final String KEY_FOUR = "custom4";
    public static final String KEY_FIVE = "custom5";
    public static final String KEY_SIX = "custom6";
    private final int maxLength;

    public static FieldCustomUserField createFirst() {
        return new FieldCustomUserField(KEY_ONE, 500, 255);
    }

    public static FieldCustomUserField createSecond() {
        return new FieldCustomUserField(KEY_TWO, 490, 255);
    }

    public static FieldCustomUserField createThird() {
        return new FieldCustomUserField(KEY_THREE, 480, 255);
    }

    public static FieldCustomUserField createFourth() {
        return new FieldCustomUserField(KEY_FOUR, 470, 255);
    }

    public static FieldCustomUserField createFifth() {
        return new FieldCustomUserField(KEY_FIVE, 460, 255);
    }

    public static FieldCustomUserField createSixth() {
        return new FieldCustomUserField(KEY_SIX, 450, 1000);
    }

    private FieldCustomUserField(String key, int priority, int maxLength) {
        super(FieldCustomUserField.createSearchTag(key, priority), (Object)"");
        this.maxLength = maxLength;
    }

    private static SearchTag createSearchTag(final String key, int priority) {
        return new SearchTag(key, (SearchTokenizer)TextSearchTokenizer.DEFAULT, priority, key, true){

            public String getDisplayName() {
                UserField field = UserManager.getInstance().getField(key);
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(field);
            }
        };
    }

    public String getValidOrDefaultValue(String value, GUID entryID) {
        if (value == null) {
            return "";
        }
        return (String)super.getValidOrDefaultValue((Object)value, entryID);
    }

    public void validate(String value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)this.maxLength);
    }
}

