/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.values;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.shared.model.Actions;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.ui.fields.values.AllowedActionsItem;
import com.inet.helpdesk.usersandgroups.ui.fields.values.AllowedActionsItemGroup;
import com.inet.lib.json.Json;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@JsonData
public class AllowedActionsFieldValue
extends FieldValue {
    private List<AllowedActionsItemGroup> actionGroups;
    private AllowedActionsItemGroup generalGroup;

    public AllowedActionsFieldValue(Set<Integer> selectedActions, Set<Integer> inheritActions, boolean showSupporterActions) {
        super(new Json().toJson(selectedActions));
        List<AllowedActionsItemGroup> modelList = AllowedActionsFieldValue.createModelList(selectedActions, inheritActions, showSupporterActions);
        this.generalGroup = modelList.get(0);
        this.actionGroups = modelList.subList(1, modelList.size());
    }

    public static List<AllowedActionsItemGroup> createModelList(Set<Integer> selectedActions, Set<Integer> inheritActions, boolean showSupporterActions) {
        ArrayList<AllowedActionsItemGroup> result = new ArrayList<AllowedActionsItemGroup>();
        ArrayList<AllowedActionsItem> allgemein = new ArrayList<AllowedActionsItem>();
        result.add(new AllowedActionsItemGroup(allgemein, HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.actions.group.general", new Object[0])));
        allgemein.add(AllowedActionsFieldValue.item(4, selectedActions, inheritActions));
        allgemein.add(AllowedActionsFieldValue.item(-12, selectedActions, inheritActions));
        allgemein.add(AllowedActionsFieldValue.item(2, selectedActions, inheritActions));
        allgemein.add(AllowedActionsFieldValue.item(7, selectedActions, inheritActions));
        allgemein.add(AllowedActionsFieldValue.item(-2, selectedActions, inheritActions));
        allgemein.add(AllowedActionsFieldValue.item(-21, selectedActions, inheritActions));
        allgemein.add(AllowedActionsFieldValue.item(-6, selectedActions, inheritActions));
        AllowedActionsFieldValue.sort(allgemein);
        if (showSupporterActions) {
            ArrayList<AllowedActionsItem> supporter = new ArrayList<AllowedActionsItem>();
            result.add(new AllowedActionsItemGroup(supporter, HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.actions.group.supporter", new Object[0])));
            supporter.add(AllowedActionsFieldValue.item(1, selectedActions, inheritActions));
            supporter.add(AllowedActionsFieldValue.item(-7, selectedActions, inheritActions));
            supporter.add(AllowedActionsFieldValue.item(-3, selectedActions, inheritActions));
            supporter.add(AllowedActionsFieldValue.item(10, selectedActions, inheritActions));
            supporter.add(AllowedActionsFieldValue.item(-25, selectedActions, inheritActions));
            supporter.add(AllowedActionsFieldValue.item(5, selectedActions, inheritActions));
            supporter.add(AllowedActionsFieldValue.item(8, selectedActions, inheritActions));
            supporter.add(AllowedActionsFieldValue.item(-22, selectedActions, inheritActions));
            List all = ActionManager.getInstance().getAll(true);
            for (ActionVO actionVO : all) {
                if (actionVO.getId() >= -33 && actionVO.getId() <= 10 && actionVO.getId() != 9) continue;
                supporter.add(AllowedActionsFieldValue.item(actionVO.getId(), selectedActions, inheritActions));
            }
            AllowedActionsFieldValue.sort(supporter);
            ArrayList<AllowedActionsItem> supporter_organisation = new ArrayList<AllowedActionsItem>();
            result.add(new AllowedActionsItemGroup(supporter_organisation, HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.actions.group.supporter_organization", new Object[0])));
            supporter_organisation.add(AllowedActionsFieldValue.item(-1, selectedActions, inheritActions));
            supporter_organisation.add(AllowedActionsFieldValue.item(-13, selectedActions, inheritActions));
            supporter_organisation.add(AllowedActionsFieldValue.item(-19, selectedActions, inheritActions));
            supporter_organisation.add(AllowedActionsFieldValue.item(-33, selectedActions, inheritActions));
            supporter_organisation.add(AllowedActionsFieldValue.item(-20, selectedActions, inheritActions));
            AllowedActionsFieldValue.sort(supporter_organisation);
            ArrayList<AllowedActionsItem> felder = new ArrayList<AllowedActionsItem>();
            result.add(new AllowedActionsItemGroup(felder, HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.actions.group.fields", new Object[0])));
            felder.add(AllowedActionsFieldValue.item(-31, selectedActions, inheritActions));
            felder.add(AllowedActionsFieldValue.item(-30, selectedActions, inheritActions));
            felder.add(AllowedActionsFieldValue.item(-29, selectedActions, inheritActions));
            felder.add(AllowedActionsFieldValue.item(-26, selectedActions, inheritActions));
            felder.add(AllowedActionsFieldValue.item(-28, selectedActions, inheritActions));
            felder.add(AllowedActionsFieldValue.item(-27, selectedActions, inheritActions));
            felder.add(AllowedActionsFieldValue.item(3, selectedActions, inheritActions));
            felder.add(AllowedActionsFieldValue.item(-10, selectedActions, inheritActions));
            felder.add(AllowedActionsFieldValue.item(-17, selectedActions, inheritActions));
            felder.add(AllowedActionsFieldValue.item(-15, selectedActions, inheritActions));
            AllowedActionsFieldValue.sort(felder);
        }
        return result;
    }

    private static AllowedActionsItem item(int actionId, Set<Integer> selectedActions, Set<Integer> inheritActions) {
        ActionManager manager = ActionManager.getInstance();
        AllowedActionsItem allowedActionsItem = new AllowedActionsItem((ActionVO)manager.get(actionId), selectedActions.contains(actionId), inheritActions.contains(actionId));
        if (Actions.ACTIONS_WHICH_CANNOT_BE_RESTRICTED_YET.contains(actionId)) {
            allowedActionsItem.setName(allowedActionsItem.getName() + "*");
            allowedActionsItem.setDisabled(true);
        }
        return allowedActionsItem;
    }

    private static void sort(List<AllowedActionsItem> group) {
        Collections.sort(group, (item1, item2) -> item1.getName().compareTo(item2.getName()));
    }
}

