/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.effectiveactions;

import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.fields.values.AllowedActionsFieldValue;
import com.inet.helpdesk.usersandgroups.ui.fields.values.AllowedActionsItemGroup;
import com.inet.helpdesk.usersandgroups.ui.fields.values.EffectiveActionSource;
import com.inet.helpdesk.usersandgroups.ui.fields.values.EffectiveActionsRequestData;
import com.inet.helpdesk.usersandgroups.ui.fields.values.EffectiveActionsResponseData;
import com.inet.http.ClientMessageException;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.Hash;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EffectiveActionsHandler
extends ServiceMethod<EffectiveActionsRequestData, EffectiveActionsResponseData> {
    public String getMethodName() {
        return "usersandgroupsmanager_effectiveactions";
    }

    public short getMethodType() {
        return 1;
    }

    public EffectiveActionsResponseData invoke(HttpServletRequest req, HttpServletResponse resp, EffectiveActionsRequestData request) throws IOException {
        Hash hash = request.getHash();
        if (hash.getType() == Type.group) {
            throw new ClientMessageException("Access denied");
        }
        UserManager uman = UserManager.getRecoveryEnabledInstance();
        UserAccount userAccount = uman.getUserAccount(hash.getId());
        if (userAccount == null) {
            return null;
        }
        Set userActions = (Set)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_ALLOWED_ACTIONS);
        UserGroupManager ugman = UserGroupManager.getRecoveryEnabledInstance();
        Set groupsForUser = ugman.getGroupsForUser(hash.getId());
        boolean showSupporterActions = HDUsersAndGroups.isSupporter(userAccount);
        List<AllowedActionsItemGroup> allActions = AllowedActionsFieldValue.createModelList(Collections.emptySet(), Collections.emptySet(), showSupporterActions);
        HashMap<Integer, ArrayList<EffectiveActionSource>> effectivePermissions = new HashMap<Integer, ArrayList<EffectiveActionSource>>();
        this.addActionsToEffectiveActions(hash, userAccount.getDisplayName(), userActions, effectivePermissions);
        for (UserGroupInfo userGroupInfo : groupsForUser) {
            Hash currentHash = new Hash(Type.group, userGroupInfo.getID());
            this.addPermissionsToEffectivePermissions(currentHash, userGroupInfo, effectivePermissions);
        }
        return new EffectiveActionsResponseData(allActions, effectivePermissions);
    }

    private void addPermissionsToEffectivePermissions(Hash hash, UserGroupInfo userGroupInfo, HashMap<Integer, ArrayList<EffectiveActionSource>> effectiveActions) {
        Set permissions = (Set)userGroupInfo.getValue((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS);
        if (userGroupInfo.getType() != null && userGroupInfo.getType().equals((Object)UsersAndGroups.GROUPTYPE_ADMIN)) {
            Set<Integer> allActions = ActionManager.getInstance().getAll(true).stream().map(FieldVO::getId).collect(Collectors.toSet());
            this.addActionsToEffectiveActions(hash, userGroupInfo.getDisplayName(), allActions, effectiveActions);
        } else {
            this.addActionsToEffectiveActions(hash, userGroupInfo.getDisplayName(), permissions, effectiveActions);
        }
    }

    private void addActionsToEffectiveActions(Hash hash, String displayName, Set<Integer> allowedActions, HashMap<Integer, ArrayList<EffectiveActionSource>> effectiveActions) {
        for (Integer actionId : allowedActions) {
            EffectiveActionSource effectivePermissionSource = new EffectiveActionSource(hash, displayName);
            ArrayList<EffectiveActionSource> list = effectiveActions.get(actionId);
            if (list == null) {
                list = new ArrayList();
                effectiveActions.put(actionId, list);
            }
            list.add(effectivePermissionSource);
        }
    }
}

