/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups.model;

import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.MemberToTypeCardinality;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupKey;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.UserGroupMembership;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class HelpDeskWrappedUserGroupInfo
extends UserGroupInfo {
    private UserGroupInfo originalInfo;
    private UserGroupMembership memberShip;

    private HelpDeskWrappedUserGroupInfo(UserGroupInfo originalInfo, UserGroupMembership memberShip) {
        super(originalInfo.getParentID(), originalInfo.getID(), originalInfo.getName(), originalInfo.getType(), originalInfo.getLastModified(), memberShip, new MutableUserGroupData(), originalInfo.getPermissions(), originalInfo.isActive());
        this.originalInfo = originalInfo;
        this.memberShip = memberShip;
    }

    public static HelpDeskWrappedUserGroupInfo createForSupporterGroup(UserGroupInfo original) {
        if (!original.getID().equals((Object)HDUsersAndGroups.GROUPID_SUPPORTERS)) {
            throw new IllegalArgumentException("Given Info must be for the supporter group");
        }
        Set<GUID> memberIDs = HelpDeskWrappedUserGroupInfo.getAllSupporters();
        UserGroupMembership member = new UserGroupMembership(memberIDs);
        return new HelpDeskWrappedUserGroupInfo(original, member);
    }

    public static HelpDeskWrappedUserGroupInfo createForEnduserGroup(UserGroupInfo original) {
        if (!original.getID().equals((Object)HDUsersAndGroups.GROUPID_ENDUSER)) {
            throw new IllegalArgumentException("Given Info must be for the enduser group");
        }
        Set<GUID> supporters = HelpDeskWrappedUserGroupInfo.getAllSupporters();
        Set allUsers = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand("useraccounttype", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        allUsers.removeAll(supporters);
        UserGroupMembership member = new UserGroupMembership(allUsers);
        return new HelpDeskWrappedUserGroupInfo(original, member);
    }

    private static Set<GUID> getAllSupporters() {
        HashSet<GUID> memberIDs = new HashSet<GUID>();
        memberIDs.addAll(HelpDeskWrappedUserGroupInfo.findUsersWithSupporterPermissions());
        memberIDs.addAll(HelpDeskWrappedUserGroupInfo.findUsersOfGroupsWithSupporterPermission());
        memberIDs.addAll(HelpDeskWrappedUserGroupInfo.findResourceMembers());
        return memberIDs;
    }

    private static Collection<? extends GUID> findResourceMembers() {
        HashSet result = new HashSet();
        Set resources = UserGroupManager.getInstance().getGroups(HDUsersAndGroups.RESOURCE);
        resources.forEach(ress -> result.addAll(ress.getMemberIDs()));
        return result;
    }

    private static Collection<? extends GUID> findUsersWithSupporterPermissions() {
        OrSearchExpression or = new OrSearchExpression();
        for (Permission permission : HDUsersAndGroups.SUPPORTER_PERMISSIONS) {
            or.add((Object)new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, (Object)permission.getKey()));
        }
        or.add((Object)new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Equals, (Object)UserAccountType.Administrator.name()));
        Set userIds = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{or}));
        return userIds;
    }

    private static Collection<? extends GUID> findUsersOfGroupsWithSupporterPermission() {
        HashSet result = new HashSet();
        OrSearchExpression or = new OrSearchExpression();
        for (Permission permission : HDUsersAndGroups.SUPPORTER_PERMISSIONS) {
            or.add((Object)new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, (Object)permission.getKey()));
        }
        Set groupIds = UserGroupManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{or}));
        groupIds.add(UsersAndGroups.GROUPID_ADMIN);
        groupIds.remove(HDUsersAndGroups.GROUPID_ENDUSER);
        groupIds.remove(HDUsersAndGroups.GROUPID_SUPPORTERS);
        for (GUID guid : groupIds) {
            result.addAll(UserGroupManager.getInstance().getGroup(guid).getMemberIDs());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.memberShip == null ? 0 : this.memberShip.hashCode());
        result = 31 * result + (this.originalInfo == null ? 0 : this.originalInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HelpDeskWrappedUserGroupInfo other = (HelpDeskWrappedUserGroupInfo)((Object)obj);
        if (this.memberShip == null ? other.memberShip != null : !this.memberShip.equals(other.memberShip)) {
            return false;
        }
        return !(this.originalInfo == null ? other.originalInfo != null : !this.originalInfo.equals(other.originalInfo));
    }

    public GUID getID() {
        return this.originalInfo.getID();
    }

    public boolean hasParent() {
        return this.originalInfo.hasParent();
    }

    public GUID getParentID() {
        return this.originalInfo.getParentID();
    }

    public UserGroupKey getGroupKey() {
        return this.originalInfo.getGroupKey();
    }

    public String getName() {
        return this.originalInfo.getName();
    }

    public GroupType getType() {
        return this.originalInfo.getType();
    }

    public boolean isAuthenticationGroup() {
        return this.originalInfo.isAuthenticationGroup();
    }

    public long getLastModified() {
        return this.originalInfo.getLastModified();
    }

    public boolean isActive() {
        return this.originalInfo.isActive();
    }

    public Set<Permission> getPermissions() {
        return this.originalInfo.getPermissions();
    }

    public Set<GUID> getMemberIDs() {
        return this.memberShip.getMemberIDs();
    }

    public Set<GUID> getMemberIDs(MembershipType membershipType) {
        return this.memberShip.getMemberIDs(membershipType);
    }

    public boolean hasMembers() {
        return !this.memberShip.isEmpty();
    }

    public boolean hasMember(GUID userID) {
        return this.memberShip.contains(userID);
    }

    public Set<MembershipType> getAllMembershipTypes() {
        return this.memberShip.getAllMembershipTypes();
    }

    public Set<MembershipType> getMembershipTypes(GUID userID) {
        return this.memberShip.getMembershipTypes(userID);
    }

    public MemberToTypeCardinality getMemberToTypeCardinality() {
        return this.memberShip.getMemberToTypeCardinality();
    }

    public <VALUE> VALUE getValue(UserGroupField<VALUE> field) {
        return (VALUE)this.originalInfo.getValue(field);
    }

    public String toString() {
        return this.originalInfo.toString();
    }

    public Set<UserGroupField<Object>> getIncludedFields() {
        return this.originalInfo.getIncludedFields();
    }

    public UserGroupInfo copyWith(UserGroupMembership membership) {
        return this.originalInfo.copyWith(membership);
    }

    public String getKey() {
        return this.originalInfo.getKey();
    }

    public String getDisplayName() {
        return this.originalInfo.getDisplayName();
    }
}

