/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.subview;

import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

public class ItilSubViewGrouping
extends SimpleSubViewGrouping {
    public static final ItilSubViewGrouping INSTANCE = new ItilSubViewGrouping();

    private ItilSubViewGrouping() {
        super("itilid");
    }

    @Override
    public String getDisplayName() {
        return HDFieldDisplayNameProvider.getDisplayNameForCustomField(Tickets.FIELD_ITIL_ID);
    }

    @Override
    public List<TicketViewFactory> getSubViews(@Nonnull TicketViewFactory parent, GUID accountID, Locale locale) {
        ArrayList<TicketViewFactory> result = new ArrayList<TicketViewFactory>();
        ItilManager manager = ItilManager.getInstance();
        List allItilVOs = manager.getAll(false);
        try (UserAccountScope scope = UserAccountScope.create((GUID)accountID);){
            for (ItilVO itilVO : allItilVOs) {
                Integer id = itilVO.getId();
                result.add(new SubView<Integer>(parent, this, id, itilVO.getDisplayValue(), itilVO.getInfo(), id.toString()));
            }
        }
        return result;
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        if (StringFunctions.isEmpty((String)iconKey)) {
            return HelpDeskServer.class.getResource("images/itil_16.png");
        }
        try {
            int itilID = Integer.parseInt(iconKey);
            return ItilManager.getInstance().getIcon(itilID, size);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

