/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.subview;

import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewSearchCommandFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ItilMasterSubViewGrouping
extends SimpleSubViewGrouping {
    public static final ItilMasterSubViewGrouping INSTANCE = new ItilMasterSubViewGrouping();
    private static ItilLinkManager itilLinkManager;

    public ItilMasterSubViewGrouping() {
        super("itilmaster");
    }

    @Override
    public String getDisplayName() {
        return "ITIL Master";
    }

    @Override
    public List<TicketViewFactory> getSubViews(TicketViewFactory parent, GUID accountID, Locale locale) {
        if (parent instanceof ItilMasterTypeSubView) {
            return ((ItilMasterTypeSubView)parent).getSubViews();
        }
        TicketReader ticketReader = TicketManager.getReader();
        SearchCommand parentCommand = parent.createSearchCommand(accountID, locale, ticketReader.getSearchEngine());
        if (parentCommand == null) {
            return null;
        }
        boolean showBunId = HDUsersAndGroups.isSupporter(UserManager.getInstance().getUserAccount(accountID));
        ArrayList<TicketViewFactory> result = new ArrayList<TicketViewFactory>();
        try (UserAccountScope scope = UserAccountScope.create((GUID)accountID);){
            Map<Integer, ItilVO> masterItils = ItilManager.getInstance().getAll(false).stream().filter(ItilVO::isMasterType).collect(Collectors.toMap(FieldVO::getId, i -> i));
            for (ItilVO itilVO : masterItils.values()) {
                ItilMasterTypeSubView view = new ItilMasterTypeSubView(parent, itilVO);
                result.add(view);
                SearchCommand command = new SearchCommand(locale, "itilid", SearchCondition.SearchTermOperator.Equals, (Object)itilVO.getId());
                command.getSearchExpression().addAll((Collection)parentCommand.getSearchExpression());
                Set matchedTicketIDs = ticketReader.getSearchEngine().simpleSearch(command);
                if (showBunId) {
                    TicketViewManager.getInstance().convertToBunIdsIfNeeded(ticketReader.getSlaveInfoEngine(), matchedTicketIDs, accountID);
                }
                Iterator iterator = matchedTicketIDs.iterator();
                while (iterator.hasNext()) {
                    int itilMasterTicketID = (Integer)iterator.next();
                    if (view.getSubViews() != null && view.getSubViews().size() >= 100) break;
                    TicketVO ticket = ticketReader.getTicket(itilMasterTicketID);
                    if (ticket == null) continue;
                    String displayName = "#" + ticket.getID() + " " + ticket.getSubject();
                    String iconKey = "ticket" + ticket.getStatusID();
                    String description = null;
                    view.addSubView(new SubView<TicketID>(parent, INSTANCE, new TicketID(ticket.getID()), displayName, description, iconKey));
                }
                if (view.getSubViews() == null) continue;
                view.getSubViews().sort((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getDisplayName(), b.getDisplayName()));
            }
        }
        result.sort((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getDisplayName(), b.getDisplayName()));
        return result;
    }

    @Override
    public void appendMarker(SearchCommand command) {
        command.addBoostingExpression((SearchExpression)new SearchCondition("itilid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        command.addBoostingExpression((SearchExpression)new SearchCondition("subject", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        command.addBoostingExpression((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
    }

    @Override
    public void patchSearchCommand(Object id, SearchCommand parentCommand, GUID accountID) {
        PrefilteredSearchExpression prefilteredSearchExpression;
        if (id instanceof ItilMasterTypeID) {
            int itilMasterTypeID = ((ItilMasterTypeID)id).getID();
            prefilteredSearchExpression = this.createPrefilteredIDsOfItilMasterType(accountID, parentCommand, itilMasterTypeID);
        } else {
            int itilMasterTicketID = ((TicketID)id).getID();
            prefilteredSearchExpression = this.createPrefilteredIDsOfItelMasterTicket(itilMasterTicketID);
        }
        parentCommand.getSearchExpression().add(0, (Object)prefilteredSearchExpression);
    }

    @Override
    public TicketViewSearchCommandFactory getSearchCommandFactory(TicketViewSearchCommandFactory parentFactory, String fullID, String subID) {
        PrefilteredSearchExpression expr = null;
        try {
            if (subID.startsWith("itil")) {
                int itilMasterTypeID = Integer.parseInt(subID.substring("itil".length()));
                return this.createSearchCmdFactoryForItilMasterType(parentFactory, fullID, itilMasterTypeID);
            }
            if (subID.startsWith("ticket")) {
                int itilMasterTicketID = Integer.parseInt(subID.substring("ticket".length()));
                expr = this.createPrefilteredIDsOfItelMasterTicket(itilMasterTicketID);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (expr == null) {
            expr = new PrefilteredSearchExpression(Collections.singletonList(-1));
        }
        return this.createSearchCmdFactory(parentFactory, fullID, expr);
    }

    @Nonnull
    private static ItilLinkManager getItilLinkManager() {
        if (itilLinkManager == null) {
            itilLinkManager = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);
        }
        return itilLinkManager;
    }

    private PrefilteredSearchExpression createPrefilteredIDsOfItilMasterType(final GUID accountID, SearchCommand parentCommand, final int itilMasterTypeID) {
        final ArrayList parentExpressions = new ArrayList(parentCommand.getSearchExpression());
        return new PrefilteredSearchExpression(null){

            public boolean isEmpty() {
                return false;
            }

            public Collection<?> getIDs() {
                try (UserAccountScope scope = UserAccountScope.create((GUID)accountID);){
                    SearchCommand command = new SearchCommand("itilid", SearchCondition.SearchTermOperator.Equals, (Object)itilMasterTypeID);
                    command.getSearchExpression().addAll((Collection)parentExpressions);
                    Set matchedItilMasterTicketIDs = TicketManager.getReader().getSearchEngine().simpleSearch(command);
                    ItilLinkManager itilLinkManager = ItilMasterSubViewGrouping.getItilLinkManager();
                    HashSet<Integer> allTicketIDs = new HashSet<Integer>();
                    Object object = matchedItilMasterTicketIDs.iterator();
                    while (object.hasNext()) {
                        int itilMasterTicketID = (Integer)object.next();
                        Set<Integer> itilSlaveTicketIDs = itilLinkManager.getItilSlavesLinkedTo(itilMasterTicketID);
                        allTicketIDs.add(itilMasterTicketID);
                        allTicketIDs.addAll(itilSlaveTicketIDs);
                    }
                    object = allTicketIDs;
                    return object;
                }
            }
        };
    }

    private TicketViewSearchCommandFactory createSearchCmdFactoryForItilMasterType(final TicketViewSearchCommandFactory parentFactory, final String fullID, final int itilMasterTypeID) {
        return new TicketViewSearchCommandFactory(){

            @Override
            public String getID() {
                return fullID;
            }

            @Override
            public SearchCommand createSearchCommand(GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
                SearchCommand command = parentFactory.createSearchCommand(accountID, locale, engine);
                if (command != null) {
                    PrefilteredSearchExpression allTicketIDs = ItilMasterSubViewGrouping.this.createPrefilteredIDsOfItilMasterType(accountID, command, itilMasterTypeID);
                    command.getSearchExpression().add(0, (Object)allTicketIDs);
                }
                return command;
            }
        };
    }

    private TicketViewSearchCommandFactory createSearchCmdFactory(final TicketViewSearchCommandFactory parentFactory, final String fullID, final PrefilteredSearchExpression prefilteredExpression) {
        return new TicketViewSearchCommandFactory(){

            @Override
            public String getID() {
                return fullID;
            }

            @Override
            public SearchCommand createSearchCommand(GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
                SearchCommand command = parentFactory.createSearchCommand(accountID, locale, engine);
                if (command != null) {
                    command.getSearchExpression().add(0, (Object)prefilteredExpression);
                }
                return command;
            }
        };
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        if (StringFunctions.isEmpty((String)iconKey)) {
            return null;
        }
        try {
            if (iconKey.startsWith("itil")) {
                int itilMasterTypeID = Integer.parseInt(iconKey.substring("itil".length()));
                return ItilManager.getInstance().getIcon(itilMasterTypeID, size);
            }
            if (iconKey.startsWith("ticket")) {
                int statusID = Integer.parseInt(iconKey.substring("ticket".length()));
                return StatusManager.getInstance().getIcon(statusID, size);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private PrefilteredSearchExpression createPrefilteredIDsOfItelMasterTicket(final int itilMasterTicketID) {
        return new PrefilteredSearchExpression(null){

            public boolean isEmpty() {
                return false;
            }

            public Collection<?> getIDs() {
                ItilLinkManager itilLinkManager = ItilMasterSubViewGrouping.getItilLinkManager();
                HashSet<Integer> ticketIDs = new HashSet<Integer>(itilLinkManager.getItilSlavesLinkedTo(itilMasterTicketID));
                ticketIDs.add(itilMasterTicketID);
                return ticketIDs;
            }
        };
    }

    private static class ItilMasterTypeSubView
    extends SubView<ItilMasterTypeID> {
        private List<TicketViewFactory> subViews;

        public ItilMasterTypeSubView(@Nonnull TicketViewFactory parent, ItilVO itil) {
            super(parent, INSTANCE, new ItilMasterTypeID(itil.getId()), itil.getDisplayValue(), itil.getInfo(), "itil" + itil.getId());
        }

        @Override
        public SubViewGroupingDefinition getSubViewGrouping() {
            return INSTANCE;
        }

        @Nullable
        public List<TicketViewFactory> getSubViews() {
            return this.subViews;
        }

        public void addSubView(TicketViewFactory view) {
            if (this.subViews == null) {
                this.subViews = new ArrayList<TicketViewFactory>();
            }
            this.subViews.add(view);
        }
    }

    private static class TicketID {
        private static final String PREFIX = "ticket";
        private final int id;

        public TicketID(int ticketID) {
            this.id = ticketID;
        }

        public int getID() {
            return this.id;
        }

        public String toString() {
            return PREFIX + this.id;
        }
    }

    private static class ItilMasterTypeID {
        private static final String PREFIX = "itil";
        private final int id;

        public ItilMasterTypeID(int itilID) {
            this.id = itilID;
        }

        public int getID() {
            return this.id;
        }

        public String toString() {
            return PREFIX + this.id;
        }
    }
}

