/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.standardviews;

import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.TicketSearchFilterOptions;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

public class InquiryTicketViewDefinition
implements TicketViewFactory {
    public static final String KEY = "newtickets";

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getCategoryKey() {
        return "globalviews";
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        return HelpDeskServer.class.getResource("images/ticketview/newtickets.png");
    }

    @Override
    public SearchCommand createSearchCommand(GUID accountID, @Nonnull Locale locale, IndexSearchEngine<Integer> engine) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(accountID);
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.DISPATCHER})) {
            return null;
        }
        AndSearchExpression expression = new AndSearchExpression();
        List<SearchExpression> conditions = TicketSearchFilterOptions.ONLY_OPEN_INQUIRIES.getConditions(null);
        expression.addAll(conditions);
        SearchCommand command = new SearchCommand(locale, new SearchExpression[]{expression});
        return command;
    }
}

