/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.lib.util.StringFunctions;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.ApiSearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.SearchResultHolder;
import com.inet.search.index.TagIndex;
import com.inet.search.tokenizers.NoTokenTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class TicketIdMatcher
extends ApiSearchTag<Integer> {
    private static final String KEY = "ticketid";

    TicketIdMatcher(@Nonnull IndexSearchEngine<Integer> index) {
        super(KEY, (SearchTokenizer)new NoTokenTokenizer(), 200, KEY, index, index.getTag("statusid"));
    }

    public String getDisplayName() {
        return Tickets.MSG.getMsg("field.ticketid", new Object[0]);
    }

    protected void search(SearchCondition condition, SearchResultHolder<Integer, ?> map, String token) {
        try {
            Predicate<Integer> filter;
            int id = Tickets.decodeTicketID(token, false);
            if (id < 0) {
                return;
            }
            switch (condition.getOperator()) {
                case GT: {
                    filter = v -> v > id;
                    break;
                }
                case GE: {
                    filter = v -> v >= id;
                    break;
                }
                case LT: {
                    filter = v -> v < id;
                    break;
                }
                case LE: {
                    filter = v -> v <= id;
                    break;
                }
                case Unequals: {
                    filter = v -> v != id;
                    break;
                }
                default: {
                    filter = v -> v == id;
                }
            }
            Iterator it = super.createIterator(true, TagIndex.IteratorType.ID, null, filter);
            while (it.hasNext()) {
                Integer next = (Integer)it.next();
                map.add((Object)next, true, this.getTag(), token, condition);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Iterator<Object> createIterator(boolean forward, TagIndex.IteratorType itType, Comparable startsWith, Predicate filter) {
        try {
            if (startsWith != null && startsWith.getClass() == String.class) {
                startsWith = StringFunctions.isEmpty((String)((String)((Object)startsWith))) ? null : Integer.valueOf((String)((Object)startsWith));
            }
        }
        catch (NumberFormatException e) {
            return Collections.emptyIterator();
        }
        if (itType == TagIndex.IteratorType.VALUES) {
            itType = TagIndex.IteratorType.ID;
        }
        Iterator it = super.createIterator(forward, itType, null, filter);
        if (startsWith instanceof Number) {
            Iterator allIds = it;
            Iterable iterable = () -> allIds;
            Stream<? super Integer> stream = StreamSupport.stream(iterable.spliterator(), false);
            it = stream.filter(TicketIdMatcher.filter(((Number)((Object)startsWith)).intValue())).iterator();
        }
        return it;
    }

    private static Predicate<? super Integer> filter(int startsWith) {
        return id -> {
            int value = Math.abs(id);
            int starts = Math.abs(startsWith);
            while (value != starts) {
                if (value < starts) {
                    return false;
                }
                value /= 10;
            }
            return true;
        };
    }
}

