/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.EmailUserVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ReaStepEmailUsersVO;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReaStepEmailUsersCreator {
    private static final ConfigValue<String> SPERRLIST = new ConfigValue(HDConfigKeys.SPERRLIST);

    public static ReaStepEmailUsersVO getReaStepEmailUsers(TicketReadDAO readDAO, int stepID) {
        ReaStepVO reaStep = readDAO.getReaStep(stepID);
        if (reaStep == null) {
            return null;
        }
        GUID resourceID = null;
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(reaStep.getBunID());
        if (ticket != null) {
            resourceID = ticket.getResourceID();
        } else {
            String msg = String.format("There is no ticket with ID=%d. This ticket is referenced by rea-step with ID=%d.", reaStep.getBunID(), reaStep.getID());
            HDLogger.error(new IllegalStateException(msg));
        }
        return ReaStepEmailUsersCreator.getReaStepEmailUsers(resourceID, reaStep.getUserID(), reaStep.getDisplayName(), reaStep.getEmailSenderAddress(), reaStep.getEmailReceiverAddresses(), reaStep.getEmailCCAdresses());
    }

    public static ReaStepEmailUsersVO getReaStepEmailUsers(@Nullable GUID resourceID, @Nullable GUID userAccountID, @Nullable String userDisplayName, @Nonnull String emailSenderAddress, @Nonnull String emailReceiverAddresses, @Nonnull String emailCCAdresses) {
        EmailUserVO sender = ReaStepEmailUsersCreator.createEmailUserVOFrom(userAccountID, userDisplayName, emailSenderAddress);
        List<EmailUserVO> to = ReaStepEmailUsersCreator.convertToEmailUsers(emailReceiverAddresses);
        List<EmailUserVO> cc = ReaStepEmailUsersCreator.convertToEmailUsers(emailCCAdresses);
        UserGroupInfo resource = null;
        if (resourceID != null && (resource = UserGroupManager.getInstance().getGroup(resourceID)) == null) {
            String msg = String.format("There is no group for resource with ID=\"%s\".", resourceID.toString());
            HDLogger.error(new IllegalStateException(msg));
        }
        BlockedAddresses blockedAddresses = ReaStepEmailUsersCreator.getBlockedAddresses(resource);
        if (sender != null && ReaStepEmailUsersCreator.isBlocked(sender.getEmailAddress(), blockedAddresses)) {
            sender = null;
        }
        to.removeIf(e -> ReaStepEmailUsersCreator.isBlocked(e.getEmailAddress(), blockedAddresses));
        cc.removeIf(e -> ReaStepEmailUsersCreator.isBlocked(e.getEmailAddress(), blockedAddresses));
        return new ReaStepEmailUsersVO(sender, to, cc);
    }

    private static EmailUserVO createEmailUserVOFrom(@Nullable GUID userAccountID, @Nullable String userDisplayName, String emailAddress) {
        UserAccount userAccount;
        if (userAccountID != null && (userAccount = UserManager.getInstance().getUserAccount(userAccountID)) != null) {
            List emailsFromAccount = EmailAddressHelper.get().getValidEmailAddressesFrom((String)userAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL));
            String addressToUse = emailsFromAccount.isEmpty() || emailsFromAccount.stream().anyMatch(e -> emailAddress.equalsIgnoreCase((String)e)) ? emailAddress : (String)emailsFromAccount.get(0);
            return new EmailUserVO(userAccountID, userAccount.getDisplayName(), addressToUse);
        }
        return ReaStepEmailUsersCreator.createEmailUserVOFrom(emailAddress, userDisplayName);
    }

    private static List<EmailUserVO> convertToEmailUsers(@Nonnull String emailAddresses) {
        return ReaStepEmailUsersCreator.extractEmailAddresses(emailAddresses).stream().map(e -> ReaStepEmailUsersCreator.createEmailUserVOFrom(e, null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static EmailUserVO createEmailUserVOFrom(@Nonnull String emailAddress, @Nullable String userDisplayName) {
        if (emailAddress.trim().isEmpty()) {
            return null;
        }
        String alias = EmailAddressHelper.get().extractAlias(emailAddress);
        String email = EmailAddressHelper.get().extractEmailAddress(emailAddress);
        if (alias == null && email == null) {
            return null;
        }
        UserManager userManager = UserManager.getInstance();
        Set matchedUserAccIDs = userManager.getSearchEngine().simpleSearch(new SearchCommand("email", SearchCondition.SearchTermOperator.Equals, (Object)email));
        UserAccount matchedAccount = null;
        for (GUID accID : matchedUserAccIDs) {
            UserAccount userAccount = userManager.getUserAccount(accID);
            if (userAccount == null) continue;
            if (userAccount.isActive()) {
                matchedAccount = userAccount;
                break;
            }
            if (matchedAccount != null) continue;
            matchedAccount = userAccount;
        }
        if (matchedAccount != null) {
            return new EmailUserVO(matchedAccount.getID(), matchedAccount.getDisplayName(), email);
        }
        if (alias == null || alias.equals(email)) {
            alias = userDisplayName != null && !userDisplayName.equals(email) ? userDisplayName : email;
        }
        return new EmailUserVO(null, alias, email);
    }

    private static List<String> extractEmailAddresses(@Nonnull String emailAddresses) {
        if (emailAddresses.trim().isEmpty()) {
            return Collections.emptyList();
        }
        if (emailAddresses.indexOf(59) == -1) {
            return Collections.singletonList(emailAddresses);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer emailTokens = new StringTokenizer(emailAddresses, ";");
        while (emailTokens.hasMoreTokens()) {
            String nextToken = emailTokens.nextToken().trim();
            if (nextToken.isEmpty()) continue;
            result.add(nextToken);
        }
        return result;
    }

    private static BlockedAddresses getBlockedAddresses(@Nullable UserGroupInfo resource) {
        ArrayList mailAccounts;
        ArrayList<String> blockedAddressPatterns = new ArrayList<String>();
        String blockedMails = (String)SPERRLIST.get();
        if (blockedMails != null && blockedMails.length() > 0) {
            String[] parts;
            for (String part : parts = blockedMails.split(";")) {
                if ((part = part.trim()).length() <= 0) continue;
                blockedAddressPatterns.add(part.trim().toLowerCase());
            }
        }
        ArrayList<String> blockedAddresses = new ArrayList<String>();
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account != null) {
            List currentUserEmailAddresses = EmailAddressHelper.get().getValidEmailAddressesFrom((String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL));
            blockedAddresses.addAll(currentUserEmailAddresses);
        } else {
            HDLogger.error(new IllegalStateException("No user is logged in."));
        }
        if (resource != null) {
            List<String> resourceAddresses = ReaStepEmailUsersCreator.extractEmailAddresses((String)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_EMAIL));
            blockedAddresses.addAll(resourceAddresses);
        }
        if ((mailAccounts = (ArrayList)EmailReader_Main.MAIL_ACCOUNTS.get()) != null) {
            for (EmailAccount mAccount : mailAccounts) {
                String from = mAccount.getFrom();
                if (from == null || from.trim().isEmpty()) continue;
                blockedAddresses.add(from.trim());
            }
        }
        return new BlockedAddresses(blockedAddressPatterns, blockedAddresses);
    }

    private static boolean isBlocked(@Nonnull String emailAddressToCheck, @Nonnull BlockedAddresses blocked) {
        for (String blockedPart : blocked.patterns) {
            String quotedPattern = Pattern.quote(blockedPart.toLowerCase());
            quotedPattern = quotedPattern.replace("*", "\\E.*\\Q");
            if (!emailAddressToCheck.toLowerCase().matches("^" + quotedPattern + "$")) continue;
            return true;
        }
        for (String blockedAddress : blocked.addresses) {
            if (!emailAddressToCheck.equalsIgnoreCase(blockedAddress)) continue;
            return true;
        }
        return false;
    }

    private static class BlockedAddresses {
        final List<String> patterns;
        final List<String> addresses;

        public BlockedAddresses(@Nonnull List<String> blockedAddressPatterns, @Nonnull List<String> blockedAddresses) {
            this.patterns = blockedAddressPatterns;
            this.addresses = blockedAddresses;
        }
    }
}

