/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.ticketmanager.adapt.OldApiAdapter;
import com.inet.helpdesk.ticketmanager.internal.TicketChangeCollector;
import com.inet.helpdesk.ticketmanager.search.TicketDataForIndexingVO;
import com.inet.helpdesk.ticketmanager.search.TicketSearchDataCache;
import com.inet.thread.EventDispatcher;
import java.util.List;
import javax.annotation.Nonnull;

public class IndexUpdateAndEvents {
    private final TicketSearchDataCache searchDataCache;
    private final EventDispatcher<TicketEventListener> eventDispatcher = new EventDispatcher();

    public IndexUpdateAndEvents(TicketSearchDataCache searchDataCache) {
        this.searchDataCache = searchDataCache;
    }

    public void handleTicketChangeCollectorResult(TicketChangeCollector.TicketChangeCollectorResult result, boolean sendEvent) {
        for (TicketDataForIndexingVO.TicketDataForIndexingVOPair pair : result.getDataForIndexing()) {
            TicketDataForIndexingVO oldData = pair.getOldData();
            TicketDataForIndexingVO newData = pair.getNewData();
            if (oldData == null) {
                this.searchDataCache.ticketCreated(newData);
                continue;
            }
            if (newData == null) {
                this.searchDataCache.ticketDeleted(oldData);
                continue;
            }
            this.searchDataCache.ticketUpdated(oldData, newData);
        }
        if (sendEvent) {
            this.dispatchEvent(result.getDataForEvent());
        }
    }

    public void dispatchEvent(List<ChangedTicketVO> changedTickets) {
        TicketEvent event = new TicketEvent(changedTickets);
        this.eventDispatcher.dispatchEvent(listener -> {
            try {
                listener.handleEvent(event);
            }
            catch (Throwable ex) {
                HDLogger.error(ex);
            }
        });
        for (ChangedTicketVO ct : changedTickets) {
            OldApiAdapter.updateTicketInMCOrOOC(ct.getTicketID(), ct.getOldTicket(), ct.getNewTicket());
        }
    }

    public void registerListener(@Nonnull TicketEventListener listener) {
        this.eventDispatcher.registerListener((Object)listener);
    }

    public void unregisterListener(@Nonnull TicketEventListener listener) {
        this.eventDispatcher.unregisterListener((Object)listener);
    }

    public void ticketCreated(TicketDataForIndexingVO ticketDataForIndexingVO) {
        this.searchDataCache.ticketCreated(ticketDataForIndexingVO);
    }
}

