/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.helpdesk.core.model.general.Sorting;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;

public class CachedTicketSorter {
    private Sorting sorting;

    private CachedTicketSorter() {
    }

    public CachedTicketSorter(Sorting sorting) {
        if (sorting == null) {
            throw new IllegalArgumentException("Sorting is null");
        }
        this.sorting = sorting;
    }

    public Sorting.SortField getSortField() {
        return this.sorting.getSortField();
    }

    public Sorting.SortType getSortType() {
        return this.sorting.getSortType();
    }

    public String getClientLanguage() {
        return this.sorting.getClientLanguage();
    }

    public long getGroupByLastSync() {
        return this.sorting.getGroupByLastSync();
    }

    public Comparator<TicketVO> getComparator() {
        return new SortingComparator(this.getSortField(), this.getSortType(), new Locale(this.getClientLanguage(), Locale.getDefault().getCountry()), this.getGroupByLastSync());
    }

    public boolean equals(Object obj) {
        if (obj instanceof CachedTicketSorter) {
            CachedTicketSorter sorting = (CachedTicketSorter)obj;
            return this.sorting.equals(sorting.sorting);
        }
        return super.equals(obj);
    }

    private static class SortingComparator
    implements Comparator<TicketVO> {
        private final Sorting.SortField sortField;
        private final Sorting.SortType sortType;
        private final Locale locale;
        private long lastSync;

        public SortingComparator(Sorting.SortField sortField, Sorting.SortType sortType, Locale locale, long lastSync) {
            this.sortField = sortField;
            this.sortType = sortType;
            this.locale = locale;
            this.lastSync = lastSync;
        }

        @Override
        public int compare(TicketVO o1, TicketVO o2) {
            Comparable<?> comp2;
            if (this.lastSync > 0L) {
                Long d1 = o1.getLastChanged();
                Long d2 = o2.getLastChanged();
                if (d1 != null && d2 != null) {
                    if (d1 >= this.lastSync) {
                        if (d2 < this.lastSync) {
                            return -1;
                        }
                    } else if (d2 >= this.lastSync && d1 < this.lastSync) {
                        return 1;
                    }
                }
            }
            Comparable<?> comp1 = o1 != null ? this.getComparableField(o1) : null;
            Comparable<?> comparable = comp2 = o2 != null ? this.getComparableField(o2) : null;
            if (comp1 == null) {
                return comp2 == null ? 0 : (this.sortType == Sorting.SortType.ASCENDING ? -1 : 1);
            }
            if (comp2 == null) {
                return this.sortType == Sorting.SortType.ASCENDING ? 1 : -1;
            }
            int compareResult = 0;
            if (comp1 instanceof String && comp2 instanceof String) {
                RuleBasedCollator collator = UtilityFunctions.getRuleBasedCollator(this.locale);
                compareResult = this.sortType == Sorting.SortType.ASCENDING ? collator.compare((String)((Object)comp1), (String)((Object)comp2)) : collator.compare((String)((Object)comp2), (String)((Object)comp1));
            } else {
                int n = compareResult = this.sortType == Sorting.SortType.ASCENDING ? comp1.compareTo(comp2) : comp2.compareTo(comp1);
            }
            if (compareResult == 0) {
                return o2.getID() - o1.getID();
            }
            return compareResult;
        }

        private Comparable<?> getComparableField(TicketVO auf) {
            switch (this.sortField) {
                case TICKETID: {
                    return auf.getID();
                }
                case STATUSID: {
                    return auf.getStatusID();
                }
                case PRIOID: {
                    return auf.getPriorityID();
                }
                case SUBJECT: {
                    return auf.getSubject();
                }
                case TICKETOWNER: {
                    UserAccount owner;
                    UserAccount userAccount = owner = auf.getOwnerID() == null ? null : UserManager.getInstance().getUserAccount(auf.getOwnerID());
                    if (owner == null) {
                        return "";
                    }
                    String lastname = (String)owner.getValue((UserField)UsersAndGroups.FIELD_LASTNAME);
                    if (lastname != null && lastname.length() > 0) {
                        return lastname;
                    }
                    return owner.getDisplayName();
                }
                case LASTMODIFIED: {
                    return auf.getLastChanged();
                }
                case UNREAD: {
                    return auf.getStatusID() == 0 || auf.getStatusID() == 100 || auf.getStatusID() == 101;
                }
                case CONTACTNAME: {
                    return null;
                }
                case CATEGORY: {
                    CategoryVO category = (CategoryVO)CategoryManager.getInstance().get(auf.getCategoryID());
                    return category == null ? "" : category.getPath().toLowerCase();
                }
                case LOCATION: {
                    UserAccount owner2 = auf.getOwnerID() == null ? null : UserManager.getInstance().getUserAccount(auf.getOwnerID());
                    return owner2 != null ? ((LocationVO)LocationManager.getInstance().get((Integer)owner2.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID))).getDisplayValue().toLowerCase() : "";
                }
                case CLASSIFICATION: {
                    ClassificationVO classification = (ClassificationVO)ClassificationManager.getInstance().get(auf.getClassificationID());
                    return classification == null ? "" : classification.getDisplayValue().toLowerCase();
                }
                case RESOURCE: {
                    GUID resourceID = auf.getResourceID();
                    if (resourceID == null) {
                        return "";
                    }
                    UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resourceID);
                    return resource == null ? "" : resource.getDisplayName().toLowerCase();
                }
                case TICKETFIELD1: {
                    return auf.getCustom1();
                }
                case TICKETFIELD2: {
                    return auf.getCustom2();
                }
                case TICKETFIELD3: {
                    return auf.getCustom3();
                }
                case TICKETFIELD4: {
                    return auf.getCustom4();
                }
            }
            return null;
        }
    }
}

