/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtension;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.mail.reader.TMReceivedMailDataArgument;

public class CreateTicketFromMailExtension
implements CreateTicketExtensionFactory {
    @Override
    public CreateTicketExtension createIfApplicable(OperationChangedTicket ticket, ExtensionArguments arguments, MutableTicketData ticketFields) {
        TMReceivedMailDataArgument arg = (TMReceivedMailDataArgument)arguments.get(ExtensionArguments.EXTARG_EMAIL_DATA);
        if (arg != null) {
            return new ExtensionImpl(arg);
        }
        return null;
    }

    public static void applyPossibleStatusSetByMailTrigger(OperationChangedTicket ticket, ExtensionArguments args, TMReceivedMailDataArgument mailData, TicketSubOperations operations) {
        if (mailData.getTicketStatusChangedByTrigger() != null) {
            int ticketStatusChangedByTrigger = Math.max(100, mailData.getTicketStatusChangedByTrigger());
            if (ticketStatusChangedByTrigger >= 400) {
                operations.applyAction(ticket, new MutableReaStepData(), ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(7), ExtensionArguments.generateForSubOperation(args));
            } else if (ticketStatusChangedByTrigger >= 300) {
                operations.applyAction(ticket, new MutableReaStepData(), ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(2), ExtensionArguments.generateForSubOperation(args));
            } else if (ticketStatusChangedByTrigger == 293 && ticket.getAttributeValue(Tickets.ATTRIBUTE_STATUS_ID) != 293) {
                operations.applyAction(ticket, new MutableReaStepData(), ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(-32), ExtensionArguments.generateForSubOperation(args));
            }
            if (ticket.getAttributeValue(Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID) != null) {
                ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_STATUS_ID, ticketStatusChangedByTrigger);
            }
        }
    }

    private class ExtensionImpl
    implements CreateTicketExtension {
        private TMReceivedMailDataArgument arg;

        public ExtensionImpl(TMReceivedMailDataArgument arg) {
            this.arg = arg;
        }

        @Override
        public void beforeCreate(OperationChangedTicket newTicket, OperationNewReaStep anfrageStep, TicketSubOperations operations) {
            anfrageStep.getFields().putValidOrDefaultValue(ReaStepVO.FIELD_DESC, this.arg.getReaStepDescriptionString());
            anfrageStep.getFields().putValidOrDefaultValue(ReaStepVO.FIELD_USER_DISPLAY_NAME, this.arg.getSenderName());
            anfrageStep.getFields().putValidOrDefaultValue(ReaStepVO.FIELD_EMAIL_IN, this.arg.getSenderMail());
            anfrageStep.getFields().putValidOrDefaultValue(ReaStepVO.FIELD_EMAIL_AN, this.arg.getReceiverMail());
            anfrageStep.getFields().putValidOrDefaultValue(ReaStepVO.FIELD_EMAIL_CC, this.arg.getReceiverCCMail());
            anfrageStep.getFields().put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(this.arg.getReceivedDate()));
            newTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_INQUIRY_DATE, this.arg.getReceivedDate());
            CreateTicketFromMailExtension.applyPossibleStatusSetByMailTrigger(newTicket, ExtensionArguments.create(), this.arg, operations);
        }
    }
}

