/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

public class UtilityFunctions {
    private static final char[] BASE_64;
    private static byte[] convert_array;
    private static final byte SHIFT_KEY = 36;
    private static HashMap<Locale, RuleBasedCollator> collators;

    public static String getOfficialDisplayNameFor(String usern, String nachn, String vorn) {
        if (nachn != null && nachn.length() > 0) {
            if (vorn != null && vorn.length() > 0) {
                StringBuffer strbuf = new StringBuffer();
                strbuf.append(nachn).append(", ").append(vorn);
                if (strbuf.length() > 50) {
                    return nachn;
                }
                return strbuf.toString();
            }
            return nachn;
        }
        return UtilityFunctions.shortenIfNeeded(usern);
    }

    private static String shortenIfNeeded(String usern) {
        if (usern == null) {
            return "";
        }
        return usern.substring(usern.indexOf(47) + 1);
    }

    public static String getDisplayNameFor(String usern, String nachn, String vorn) {
        if (nachn != null && nachn.length() > 0) {
            if (vorn != null && vorn.length() > 0) {
                StringBuffer strbuf = new StringBuffer();
                strbuf.append(vorn).append(' ').append(nachn);
                if (strbuf.length() > 50) {
                    return nachn;
                }
                return strbuf.toString();
            }
            return nachn;
        }
        return UtilityFunctions.shortenIfNeeded(usern);
    }

    public static String getDisplayNameWhichIncludesUserName(String userName, String lastName, String firstName) {
        Object displayName = UtilityFunctions.getDisplayNameFor(userName, lastName, firstName);
        if (!((String)displayName).equals(userName)) {
            displayName = userName != null && userName.endsWith((String)displayName) ? userName : (String)displayName + " (" + userName + ")";
        }
        return displayName;
    }

    public static String decodeBase64(String src) {
        byte[] bytes;
        try {
            bytes = src.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            bytes = src.getBytes();
        }
        bytes = UtilityFunctions.decodeBase64(bytes);
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            return new String(bytes);
        }
    }

    public static byte[] decodeBase64(byte[] src) {
        int kor = src.length / 4 * 3;
        if (src[src.length - 1] == 61) {
            --kor;
            if (src[src.length - 2] == 61) {
                --kor;
            }
        }
        byte[] dest = new byte[kor];
        int i = 0;
        int j = 0;
        while (j + 3 < src.length) {
            byte a = convert_array[src[j]];
            byte b = convert_array[src[j + 1]];
            dest[i] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
            if (i + 1 < dest.length) {
                dest[i + 1] = (byte)(b << 4 & 0xF0 | convert_array[src[j + 2]] >>> 2 & 0xF);
            }
            if (i + 2 < dest.length) {
                dest[i + 2] = (byte)(convert_array[src[j + 2]] << 6 & 0xC0 | convert_array[src[j + 3]] & 0x3F);
            }
            i += 3;
            j += 4;
        }
        return dest;
    }

    public static String stack2string(Throwable e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception e2) {
            return "bad stack2string";
        }
    }

    public static Properties loadConfigProperties(byte[] bytes) {
        Properties props = new Properties();
        try {
            if (bytes != null && bytes.length > 0) {
                if (bytes[0] != 35) {
                    bytes = UtilityFunctions.decodeBase64(bytes);
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = (byte)(bytes[i] ^ 0x24);
                    }
                }
                props.load(new ByteArrayInputStream(bytes));
            }
        }
        catch (Exception e) {
            PrintStream error = System.err;
            e.printStackTrace(error);
        }
        return props;
    }

    public static byte[] getEncodedBytesFromProperties(Properties props) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        props.store(bout, "");
        byte[] bytes = bout.toByteArray();
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(bytes[i] ^ 0x24);
        }
        return UtilityFunctions.encodeBase64(bytes);
    }

    public static byte[] encodeBase64(byte[] byteData) {
        int iSrcIdx;
        byte[] byteDest = new byte[(byteData.length + 2) / 3 * 4];
        int iDestIdx = 0;
        for (iSrcIdx = 0; iSrcIdx < byteData.length - 2; iSrcIdx += 3) {
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx] >>> 2 & 0x3F);
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 1] >>> 4 & 0xF | byteData[iSrcIdx] << 4 & 0x3F);
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 2] >>> 6 & 3 | byteData[iSrcIdx + 1] << 2 & 0x3F);
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 2] & 0x3F);
        }
        if (iSrcIdx < byteData.length) {
            byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx] >>> 2 & 0x3F);
            if (iSrcIdx < byteData.length - 1) {
                byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 1] >>> 4 & 0xF | byteData[iSrcIdx] << 4 & 0x3F);
                byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx + 1] << 2 & 0x3F);
            } else {
                byteDest[iDestIdx++] = (byte)(byteData[iSrcIdx] << 4 & 0x3F);
            }
        }
        for (iSrcIdx = 0; iSrcIdx < iDestIdx; ++iSrcIdx) {
            byteDest[iSrcIdx] = byteDest[iSrcIdx] < 26 ? (int)(byteDest[iSrcIdx] + 65) : (byteDest[iSrcIdx] < 52 ? (int)(byteDest[iSrcIdx] + 97 - 26) : (byteDest[iSrcIdx] < 62 ? (int)(byteDest[iSrcIdx] + 48 - 52) : (byteDest[iSrcIdx] < 63 ? 43 : 47)));
        }
        while (iSrcIdx < byteDest.length) {
            byteDest[iSrcIdx] = 61;
            ++iSrcIdx;
        }
        return byteDest;
    }

    public static boolean contains(int value, int[] keys) {
        for (int key : keys) {
            if (value != key) continue;
            return true;
        }
        return false;
    }

    public static String getUniqueFileName(String baseName, Collection<String> col) {
        int dot = baseName.lastIndexOf(46);
        String name = dot == -1 ? baseName : baseName.substring(0, dot);
        String extension = dot == -1 ? "" : baseName.substring(dot);
        int count = 1;
        if (name.matches(".*[\\(][0-9][\\)]")) {
            name = name.substring(0, name.lastIndexOf(40));
        }
        String test = name + "(" + count + ")" + extension;
        while (col.contains(test)) {
            test = name + "(" + ++count + ")" + extension;
        }
        return test;
    }

    public static RuleBasedCollator getRuleBasedCollator(Locale locale) {
        RuleBasedCollator ruleBasedCollator = collators.get(locale);
        if (ruleBasedCollator != null) {
            return ruleBasedCollator;
        }
        RuleBasedCollator defaultCollator = (RuleBasedCollator)Collator.getInstance(locale);
        Object rules = defaultCollator.getRules();
        rules = (String)rules + "&\u0301<' ';'\u00a0';'\u2000';'\u2001';'\u2002';'\u2003';'\u2004';'\u2005';'\u2006';'\u2007';'\u2008';'\u2009';'\u200a';'\u3000';'\ufeff';'\r' ;'\t' ;'\n';'\f';'\u000b'";
        rules = (String)rules + "&'\u000b'<'-';\u00ad;\u2010;\u2011;\u2012;\u2013;\u2014;\u2015;\u2212";
        try {
            ruleBasedCollator = new RuleBasedCollator((String)rules);
            collators.put(locale, ruleBasedCollator);
            return ruleBasedCollator;
        }
        catch (Exception ex) {
            PrintStream error = System.err;
            ex.printStackTrace(error);
            collators.put(locale, defaultCollator);
            return defaultCollator;
        }
    }

    public static int getDBVersion() {
        return 252;
    }

    static {
        int i;
        BASE_64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        convert_array = new byte[256];
        collators = new HashMap();
        for (i = 0; i < 255; ++i) {
            UtilityFunctions.convert_array[i] = -1;
        }
        for (i = 0; i < BASE_64.length; ++i) {
            UtilityFunctions.convert_array[UtilityFunctions.BASE_64[i]] = (byte)i;
        }
    }
}

