/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.server;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.servlets.rpc.ProxyPacketHandler;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.shared.communication.ServerDataAccess;
import com.inet.helpdesk.shared.model.FieldInformation;
import com.inet.helpdesk.shared.model.ticket.TicketTimelineInformations;
import com.inet.helpdesk.ticketmanager.internal.DefaultValueManagerImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.PluginClientConnect;
import com.inet.plugin.PluginUpdateCallback;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import srv.AktualisierungCommand;
import srv.HdLicenseObserver;
import srv.ServerUtilities;
import srv.controller.MetaController;
import srv.controller.OpenOrderController;
import srv.controller.TicketAccessController;
import srv.controller.UserSession;

public class ServerPacketHandler
extends ProxyPacketHandler
implements ServerDataAccess {
    private static final ConfigValue<Integer> ESCALATION_WARNING_ACTION = new ConfigValue(HDConfigKeys.ESCALATION_WARNING_ACTION);
    private final ConnectionFactory connectionFactory;
    private final ServerDataConnector serverData;

    public ServerPacketHandler(ConnectionFactory connectionFactory, ServerDataConnector serverData) {
        this.connectionFactory = connectionFactory;
        this.serverData = serverData;
    }

    @Override
    public Class<?> getRemoteInterface() {
        return ServerDataAccess.class;
    }

    @Override
    public Properties getServerSettings() {
        return ServerUtilities.getClientSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTicketLockHolder(int ticketId) {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
            AktualisierungCommand command = new AktualisierungCommand(4, con);
            command.setInt(1, ticketId);
            command.setInt(2, HDUsersAndGroups.getUserID(UserManager.getInstance().getCurrentUserAccount()));
            ResultSet rs = command.executeQuery();
            if (rs.next()) {
                String msg = (String)rs.getObject(1);
                if (msg != null) {
                    msg = msg.substring(msg.lastIndexOf(";") + 1);
                }
                String string = msg;
                return string;
            }
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
        finally {
            try {
                con.close();
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Properties checkUpdateState(Properties questions) throws IOException {
        Integer usrID = new Integer(questions.getProperty("UsrID"));
        int hdsessionID = Integer.parseInt(questions.getProperty("hdsession"));
        Properties answers = new Properties();
        if (ServerUtilities.isDatabaseConnectionValid()) {
            Connection con = null;
            UserSession session = null;
            try {
                String licenceVersionRequest;
                answers.setProperty("opt_PriID", DefaultValueManagerImpl.getInstance().getPriorityDefault().toString());
                answers.setProperty("opt_PrioSelection", DefaultValueManagerImpl.getInstance().getSlaSettings().toString());
                con = this.connectionFactory.getConnection();
                UserSession userSession = session = ServerUtilities.conti == null ? null : ServerUtilities.conti.aktualisiereUserSession(hdsessionID, usrID);
                if (session == null) return answers;
                session.checkForMessage(answers);
                String orderchanges = questions.getProperty("DIALOG101");
                String userchanges = questions.getProperty("MODIFIED_USERS");
                String settingsArray = questions.getProperty("ALG_EINSTELLUNGEN");
                String orderList = questions.getProperty("DIALOG103");
                String sysTray = questions.getProperty("systrayMsgs");
                if (settingsArray != null) {
                    ServerUtilities.conti.noticeClientChanges(Integer.parseInt(settingsArray));
                }
                int[] changedUsers = OpenOrderController.convertToIntArray(userchanges);
                String answer = ServerUtilities.getOpenOrderController().realizeUserDataChange(con, changedUsers, orderchanges != null ? session : null);
                if (answer.length() > 0) {
                    answers.setProperty("MODIFIED_USERS", answer);
                }
                if (questions.getProperty("DIALOG2") != null) {
                    answers.setProperty("DIALOG2", ServerUtilities.getOpenOrderController().getUserOrderVersion(usrID));
                }
                if (questions.getProperty("DIALOG10") != null) {
                    answers.setProperty("DIALOG10", ServerUtilities.getOpenOrderController().getUserGroupChangesVersion(questions.getProperty("DIALOG10")));
                }
                if ((licenceVersionRequest = questions.getProperty("licencedata")) != null) {
                    HdLicenseObserver.addLicenseData(answers, licenceVersionRequest);
                }
                ServerUtilities.conti.noticeDeviceChanges(questions.getProperty("deviceschanged"), answers, session);
                ServerUtilities.conti.writeData(answers);
                if (questions.getProperty("DIALOG100") != null) {
                    answers.setProperty("DIALOG100", ServerUtilities.conti.fetchRequestsData(hdsessionID, questions.getProperty("DIALOG100")));
                }
                if (orderchanges != null) {
                    answers.setProperty("opt_GebID", ((Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue()).toString());
                    int[] openedOrders = OpenOrderController.convertToIntArray(orderchanges);
                    TicketAccessController accessController = ServerUtilities.conti.getTicketAccessController();
                    accessController.handleOpenedOrders(session, openedOrders, answers);
                }
                if (orderList != null) {
                    answers.setProperty("DIALOG103", ServerUtilities.getOpenOrderController().getVersion(orderList));
                    answers.setProperty("clienttreeconfig", ServerUtilities.getOpenOrderController().getUserViewField());
                    answers.setProperty("timeline", String.valueOf(((TimelineDataHandler)ServerPluginManager.getInstance().getSingleInstance(TimelineDataHandler.class)).getMetaDataChangeCount()));
                    answers.setProperty("EskalationWerte", MetaController.getEscalationStates());
                    answers.setProperty(ESCALATION_WARNING_ACTION.getConfigKey().getKey(), ((Integer)ESCALATION_WARNING_ACTION.get()).toString());
                }
                if (sysTray != null) {
                    ServerUtilities.getOpenOrderController().fetchUserMessages(session, Integer.parseInt(sysTray), answers);
                }
                try {
                    List observerPlugins = ServerPluginManager.getInstance().get(PluginClientConnect.class);
                    if (observerPlugins.size() > 0) {
                        for (PluginClientConnect observer : observerPlugins) {
                            String[] message = observer.getMessageForSession(hdsessionID);
                            if (message == null || message.length != 2) continue;
                            answers.setProperty(message[0], message[1]);
                        }
                    }
                }
                catch (Throwable th) {
                    HDLogger.error(th);
                }
                List updatePlugins = ServerPluginManager.getInstance().get(PluginUpdateCallback.class);
                if (updatePlugins.size() <= 0) return answers;
                for (PluginUpdateCallback plugin : updatePlugins) {
                    try {
                        long version;
                        String data;
                        Object versionObj = questions.get(plugin.getRequestKey());
                        if (versionObj == null || (data = plugin.getDataUpdate(version = Long.parseLong(versionObj.toString()))) == null) continue;
                        answers.setProperty(plugin.getRequestKey(), data);
                    }
                    catch (Throwable th) {
                        HDLogger.error(th);
                    }
                }
                return answers;
            }
            catch (Exception ex) {
                HDLogger.error(ex);
                return answers;
            }
            finally {
                try {
                    con.close();
                }
                catch (Throwable throwable) {}
            }
        }
        answers.setProperty("LostConnection", "true");
        return answers;
    }

    @Override
    public FieldInformation getFieldInformation(String language) throws IOException {
        try {
            if (language.equals("xx")) {
                language = ClientLocale.getThreadLocale().getLanguage();
            }
            return this.serverData.getFieldInformation(language);
        }
        catch (ServerDataException sde) {
            throw new IOException(sde);
        }
    }

    @Override
    public ArrayList<TicketTimelineInformations> getTimelinesForTicket(int[] ticketIds) throws IOException {
        try {
            ArrayList<TicketTimelineInformations> result = ((TimelineDataHandler)ServerPluginManager.getInstance().getSingleInstance(TimelineDataHandler.class)).getTimelinesFor(ticketIds);
            return result;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

