/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.search.user;

import com.inet.helpdesk.search.user.SearchTagValueAnalyzer;
import java.util.ArrayList;
import java.util.List;

public class HasEmailSearchTagValueAnalyzer
implements SearchTagValueAnalyzer {
    public static final String STANDARDIZED_POSITIVE_VALUE = "1";
    public static final String STANDARDIZED_NEGATIVE_VALUE = "0";
    private static final String INVALID_VALUE_MSG = "Given value is invald.";
    List<String> positiveValues = new ArrayList<String>(){
        {
            this.add("yes");
            this.add(HasEmailSearchTagValueAnalyzer.STANDARDIZED_POSITIVE_VALUE);
            this.add("true");
        }
    };
    List<String> negativeValues = new ArrayList<String>(){
        {
            this.add("no");
            this.add(HasEmailSearchTagValueAnalyzer.STANDARDIZED_NEGATIVE_VALUE);
            this.add("false");
        }
    };

    @Override
    public boolean isValid(String value) {
        return this.positiveValues.contains(value.toLowerCase()) || this.negativeValues.contains(value.toLowerCase());
    }

    @Override
    public String createStandardizedValueFor(String value) {
        if (this.positiveValues.contains(value.toLowerCase())) {
            return STANDARDIZED_POSITIVE_VALUE;
        }
        if (this.negativeValues.contains(value.toLowerCase())) {
            return STANDARDIZED_NEGATIVE_VALUE;
        }
        throw new IllegalArgumentException(INVALID_VALUE_MSG);
    }
}

