/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.userfunctions;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.AccessDeniedException;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;

public class UserDataFunctions
implements UserDefinedFunction {
    public Integer getCurrentUserLocationID() throws AccessDeniedException {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            HDLogger.error("User Login required for id check!");
            throw new AccessDeniedException();
        }
        return (Integer)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
    }

    public String getCurrentUserLocationName() throws AccessDeniedException {
        Integer locationID = this.getCurrentUserLocationID();
        return (String)HDUsersAndGroups.FIELD_LOCATION_ID.getSearchTag().getMapData().get(locationID);
    }

    public Integer getCurrentUserGroupID() throws AccessDeniedException {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            HDLogger.error("User Login required for id check!");
            throw new AccessDeniedException();
        }
        return (Integer)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_GROUP_ID);
    }

    public String getCurrentUserGroupName() throws AccessDeniedException {
        Integer groupID = this.getCurrentUserGroupID();
        return (String)HDUsersAndGroups.FIELD_GROUP_ID.getSearchTag().getMapData().get(groupID);
    }

    public String getCurrentUserCostCenter() throws AccessDeniedException {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            HDLogger.error("User Login required for id check!");
            throw new AccessDeniedException();
        }
        return (String)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_COST_CENTRE);
    }

    public String getCurrentUserDepartment() throws AccessDeniedException {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            HDLogger.error("User Login required for id check!");
            throw new AccessDeniedException();
        }
        return (String)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_DEPARTMENT);
    }

    public String getUserDisplayName(int id) throws IllegalArgumentException {
        UserAccount ua = HDUsersAndGroups.getUserAccount(id);
        if (ua == null) {
            throw new IllegalArgumentException("Invalid user ID " + id);
        }
        return ua.getDisplayName();
    }

    public String getUserDisplayNameFull(int id) throws IllegalArgumentException {
        UserAccount ua = HDUsersAndGroups.getUserAccount(id);
        if (ua == null) {
            throw new IllegalArgumentException("Invalid user ID " + id);
        }
        String displayName = ua.getDisplayName();
        List logins = ua.getLoginSettings();
        for (LoginSettings login : logins) {
            if (!"system".equals(login.getLoginSource()) || displayName.equals(login.getLoginID())) continue;
            return displayName + " (" + login.getLoginID() + ")";
        }
        return displayName;
    }

    public String getUserDisplayNameLoginVersion(int id) throws IllegalArgumentException {
        UserAccount ua = HDUsersAndGroups.getUserAccount(id);
        if (ua == null) {
            throw new IllegalArgumentException("Invalid user ID " + id);
        }
        String displayName = ua.getDisplayName();
        List logins = ua.getLoginSettings();
        for (LoginSettings login : logins) {
            if (!"system".equals(login.getLoginSource())) continue;
            return login.getLoginID() + " (" + displayName + ")";
        }
        return displayName;
    }

    public int getCurrentUserID() throws AccessDeniedException {
        int id = HDUsersAndGroups.getUserID(UserManager.getInstance().getCurrentUserAccountID());
        if (id == -1) {
            HDLogger.error("User Login required for id check!");
            throw new AccessDeniedException();
        }
        return id;
    }

    public String htmlToText(String input) {
        return HtmlConverter.html2text((String)input);
    }
}

