/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.plugins.reporting.server.HdEngineFactory;
import com.inet.helpdesk.plugins.reporting.server.HelpDeskConnector;
import com.inet.helpdesk.plugins.reporting.server.HelpDeskPropertiesChecker;
import com.inet.helpdesk.plugins.reporting.server.PrintServlet;
import com.inet.helpdesk.plugins.reporting.server.UserHandler;
import com.inet.helpdesk.plugins.reporting.server.UserHandlerDetails;
import com.inet.helpdesk.plugins.reporting.server.ViewerPluginServlet;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportRestrictionFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportingFieldFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportingImageFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportingTicketFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportingUtilitiesFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.UserDataFunctions;
import com.inet.http.PluginServlet;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.PropertiesChecker;
import com.inet.report.cache.Cache;
import com.inet.report.cache.EngineFactory;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.shared.plugins.theme.server.ThemeResource;
import java.net.URL;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReportingServerPluginRegistration {
    public static final String CONFIG_EXPANDER_CLASS_KEY = "formulaExpanderClass";
    private static ReportingServerPluginRegistration instance;
    public static final I18nMessages CLIENT_MSG;
    private static final ConfigValue<DatabaseConfigInfoList> DB_LIST;

    public void registerExtension(final @Nonnull ServerPluginManager spm) {
        ServerPluginDescription pluginDescription = spm.getPluginDescription("reporting");
        if (pluginDescription != null) {
            pluginDescription.addDependency("lang", this.getClass().getClassLoader());
        }
        ConfigKey.LANGUAGE_RESOURCE.setDefault("lang.ReportLang");
        spm.register(PluginServlet.class, (Object)new PrintServlet());
        spm.register(PluginServlet.class, (Object)new ViewerPluginServlet());
        spm.register(PropertiesChecker.class, (Object)new HelpDeskPropertiesChecker());
        spm.register(UserDefinedFunction.class, (Object)new HelpDeskConnector());
        spm.register(UserDefinedFunction.class, (Object)new ReportRestrictionFunctions());
        spm.register(UserDefinedFunction.class, (Object)new ReportingFieldFunctions());
        spm.register(UserDefinedFunction.class, (Object)new ReportingImageFunctions());
        spm.register(UserDefinedFunction.class, (Object)new ReportingTicketFunctions());
        spm.register(UserDefinedFunction.class, (Object)new ReportingUtilitiesFunctions());
        spm.register(UserDefinedFunction.class, (Object)new UserDataFunctions());
        if (spm.isPluginLoaded("remotegui")) {
            spm.runIfPluginLoaded("promptdialog", () -> new Executable(){

                public void execute() {
                    spm.register(ServiceMethod.class, (Object)new UserHandler());
                    spm.register(ServiceMethod.class, (Object)new UserHandlerDetails());
                    FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                    combinedFile.add(((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/reporting/client/js/promptuserselectrenderer.js"));
                    combinedFile.addMessages(CLIENT_MSG);
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "promptdialog-core.js", combinedFile));
                    combinedFile = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 200, "defaulttheme.css", combinedFile));
                    combinedFile.add(((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/reporting/client/css/defaulttheme.css"));
                    spm.runIfPluginLoaded("theme", () -> new Executable(){

                        public void execute() {
                            spm.register(ThemeResource.class, (Object)new ThemeResource(200, "remotegui", ((Object)((Object)this)).getClass().getClassLoader().getResource("com/inet/helpdesk/plugins/reporting/client/css/promptuserselect.less")));
                        }
                    });
                }
            });
        }
        instance = this;
    }

    public void init(@Nonnull ServerPluginManager spm) {
        ConfigurationManager manager = ConfigurationManager.getInstance();
        Configuration config = manager.getCurrent();
        this.patchUDFconfig(config);
        this.patchRemoteSettings(config);
        Cache.setEngineFactory((EngineFactory)new HdEngineFactory((ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class)));
        this.updateDatasource();
    }

    private void patchUDFconfig(Configuration config) {
        block11: {
            if (config != null) {
                HashSet<String> classSet;
                HDLogger.info("Config to be patched is: " + config);
                String classes = config.get(CONFIG_EXPANDER_CLASS_KEY, "").trim();
                boolean changes = false;
                if (classes.length() > 0) {
                    HDLogger.info("Current expander classes: " + classes);
                    String[] parts = classes.split(",|;");
                    classSet = new HashSet(parts.length);
                    for (String string : parts) {
                        String string2 = string.trim();
                        if (string2.length() <= 0) continue;
                        classSet.add(string2);
                    }
                    changes |= classSet.remove("srv.ServerUtilities");
                } else {
                    HDLogger.info("Current expander classes: NONE");
                    classSet = new HashSet<String>(1);
                }
                if (changes) {
                    StringBuilder buffer = new StringBuilder();
                    for (String string : classSet) {
                        if (buffer.length() > 0) {
                            buffer.append(";");
                        }
                        buffer.append(string);
                    }
                    try {
                        if (ConfigurationManager.isWriteable((int)config.getScope())) {
                            HDLogger.info("Patching expander classes to: " + buffer.toString());
                            config.put(CONFIG_EXPANDER_CLASS_KEY, buffer.toString());
                            config.flush();
                            break block11;
                        }
                        HDLogger.warn("Can not patch expander classes, config is not writable!");
                    }
                    catch (BackingStoreException e) {
                        HDLogger.error(e);
                    }
                } else {
                    HDLogger.info("Config was not patched");
                }
            }
        }
    }

    private void patchRemoteSettings(Configuration config) {
        if (config != null) {
            if (ConfigurationManager.isWriteable((int)config.getScope())) {
                config.put(ConfigKey.RELOAD_ON_NEW_REQUEST.getKey(), "true");
                config.put(ConfigKey.ROWSOURCE_CACHE_ENABLED.getKey(), "false");
                config.put(ConfigKey.CACHE_TYPE.getKey(), "2");
                if (config.get(ConfigKey.STOP_AFTER_PAGE.getKey()) == null) {
                    config.put(ConfigKey.STOP_AFTER_PAGE.getKey(), "1000");
                }
                if (config.get(ConfigKey.ROW_LIMIT.getKey()) == null) {
                    config.put(ConfigKey.ROW_LIMIT.getKey(), "50000");
                }
            } else {
                HDLogger.warn("Config remote interface was not patched: no write access");
            }
        }
    }

    private void updateDatasource() {
        block17: {
            String ds_name = "HelpDesk";
            int scope = 4;
            DatabaseConfigInfo hds = ((DatabaseConfigInfoList)DB_LIST.get()).get("HDS");
            if (hds == null) {
                HDLogger.warn("ReportingServerPlugin: No connection to DB!");
                return;
            }
            try {
                String password = hds.getDecodedPassword();
                String databaseclass = "";
                String driverclass = hds.getDriverClassName();
                switch (hds.getDriver()) {
                    case inetora: {
                        databaseclass = "com.inet.report.DatabaseOracle";
                        break;
                    }
                    case mysql: {
                        databaseclass = "com.inet.report.DatabaseMysql";
                        break;
                    }
                    default: {
                        databaseclass = "com.inet.report.DatabaseSqlServer";
                    }
                }
                DataSourceConfiguration config = null;
                if (DataSourceConfigurationManager.isReadable((int)scope) && (config = DataSourceConfigurationManager.getDataSourceConfiguration((String)ds_name, (int)scope)) == null && DataSourceConfigurationManager.isWriteable((int)scope)) {
                    config = DataSourceConfigurationManager.createDataSourceConfiguration((String)ds_name, (int)scope);
                }
                if (!DataSourceConfigurationManager.isWriteable((int)scope)) {
                    HDLogger.warn("Could not patch the HelpDesk datasource: no write access. If you want to use the i-net Designer, you have to edit the HelpDesk datasource manually.");
                    break block17;
                }
                config.setPassword(password);
                config.setSavePassword(true);
                config.setDatabaseClassname(databaseclass);
                config.setUser(hds.getUser());
                config.setDriverClassname(driverclass);
                if (hds.getCustomUrl() == null) {
                    config.addProperty("host", hds.getHost());
                    String port_instance = hds.getPort();
                    try {
                        Integer.valueOf(port_instance);
                        config.addProperty("port", port_instance);
                        config.addProperty("instance", "");
                    }
                    catch (Exception e) {
                        config.addProperty("port", "");
                        config.addProperty("instance", port_instance);
                    }
                    config.addProperty("catalog", "");
                    config.addProperty("database", hds.getCatalog());
                    switch (hds.getDriver()) {
                        case mysql: {
                            config.setUrl("jdbc:mysql://{host}:{port}/{database}");
                            config.addProperty("serverTimezone", TimeZone.getDefault().getID());
                            break;
                        }
                        case inetora: {
                            config.setUrl("jdbc:inetora");
                            config.addProperty("sid", hds.getSid());
                            break;
                        }
                        default: {
                            config.setUrl("jdbc:inetdae7");
                            break;
                        }
                    }
                } else {
                    config.setUrl(hds.getCustomUrl());
                }
                config.save(scope);
            }
            catch (Exception e) {
                HDLogger.error(e);
            }
        }
    }

    static {
        CLIENT_MSG = new I18nMessages("com.inet.helpdesk.plugins.reporting.client.i18n.LanguageResources", ReportingServerPluginRegistration.class);
        DB_LIST = new ConfigValue<DatabaseConfigInfoList>(HDConfigKeys.DB_CONFIGS){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                if (instance != null) {
                    instance.updateDatasource();
                }
            }
        };
    }
}

