/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugin;

import com.inet.authentication.LoginListener;
import com.inet.classloader.I18nMessages;
import com.inet.collaboration.bot.BotCommand;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.config.recovery.RecoveryConfiguration;
import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.bot.TicketInfoBotCommand;
import com.inet.helpdesk.bot.TicketSearchBotCommand;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.HDConfigStructureProvider;
import com.inet.helpdesk.config.HDConfigStructureProviderTicketSettings;
import com.inet.helpdesk.config.HDConfigStructureProviderTicketValues;
import com.inet.helpdesk.config.HelpDeskInstanceName;
import com.inet.helpdesk.config.ScaledTicketValueIcon;
import com.inet.helpdesk.config.ServerPropertiesConverter;
import com.inet.helpdesk.config.autotext.AutoTextConfigPage;
import com.inet.helpdesk.config.autotext.handler.AutoTextIcon;
import com.inet.helpdesk.config.autotext.handler.CreateOrEditAutoText;
import com.inet.helpdesk.config.autotext.handler.DeleteAutoText;
import com.inet.helpdesk.config.autotext.handler.LoadAvailableAutoTexts;
import com.inet.helpdesk.config.autotext.handler.SaveAutoText;
import com.inet.helpdesk.config.pages.ServerConfigPage;
import com.inet.helpdesk.config.pages.TemplatesConfigPage;
import com.inet.helpdesk.config.pages.TicketConfigPage;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ActionCreationNotificator;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DBUpdateBackdoor;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.core.data.Searcher;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerInitializerStatus;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.data.SessionServerDataProvider;
import com.inet.helpdesk.core.data.StatisticsConnector;
import com.inet.helpdesk.core.data.SwingClientActiveUsersInfo;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.core.data.UserDataConnector;
import com.inet.helpdesk.core.data.valueprovider.CategoryByIDValueProvider;
import com.inet.helpdesk.core.mail.AutoMailerFactory;
import com.inet.helpdesk.core.model.ticket.TicketActionFilter;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.servlets.rpc.PacketHandler;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManagerFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.UpdateReaStepTextExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.UpdateTicketDataExtension;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.SearchTagTicketTags;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewCategory;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.subview.TicketFieldSubViewGrouping;
import com.inet.helpdesk.data.ActionCreationNotificatorImpl;
import com.inet.helpdesk.data.ConnectionFactoryImpl;
import com.inet.helpdesk.data.DBUpdateComponent;
import com.inet.helpdesk.data.DataImportConnectorImpl;
import com.inet.helpdesk.data.DbWriterImpl;
import com.inet.helpdesk.data.DeleteTicketsImpl;
import com.inet.helpdesk.data.ImagesConnectorImpl;
import com.inet.helpdesk.data.LocalizationBundleImpl;
import com.inet.helpdesk.data.LocationDataAccessImpl;
import com.inet.helpdesk.data.MaintenanceConnectorImpl;
import com.inet.helpdesk.data.ProcessingImp;
import com.inet.helpdesk.data.ServerDataConnectorImpl;
import com.inet.helpdesk.data.ServerValuesConnectorImpl;
import com.inet.helpdesk.data.SessionServerDataProviderImpl;
import com.inet.helpdesk.data.StatisticsConnectorImpl;
import com.inet.helpdesk.data.TranslationTextConnectorImpl;
import com.inet.helpdesk.data.UserDataConnectorImpl;
import com.inet.helpdesk.data.UserGroupDataAccessImpl;
import com.inet.helpdesk.data.itil.GeneratedAttributeItilCountEventListener;
import com.inet.helpdesk.data.itil.ItilChangedTicketEventListener;
import com.inet.helpdesk.data.itil.ItilLinkManagerImpl;
import com.inet.helpdesk.data.valueprovider.QueryValueProvider;
import com.inet.helpdesk.logging.EventLogTicketEventListener;
import com.inet.helpdesk.logging.TicketEventLogDescription;
import com.inet.helpdesk.login.ComputerNameSetter;
import com.inet.helpdesk.mail.AutoMailerFactoryImpl;
import com.inet.helpdesk.notification.ResourceNotificationGroup;
import com.inet.helpdesk.plugin.ClientPluginsServlet;
import com.inet.helpdesk.plugin.HdStandaloneConfiguration;
import com.inet.helpdesk.plugin.HelpDeskRequestFilter;
import com.inet.helpdesk.plugin.HelpdeskApplicationDescription;
import com.inet.helpdesk.plugin.PluginsIdMigrator;
import com.inet.helpdesk.plugin.TicketIdUidConfigMigrator;
import com.inet.helpdesk.plugins.reporting.server.ReportingServerPluginRegistration;
import com.inet.helpdesk.search.SearcherImpl;
import com.inet.helpdesk.server.ServerPacketHandler;
import com.inet.helpdesk.servlets.ContentServlet;
import com.inet.helpdesk.servlets.DictionariesServlet;
import com.inet.helpdesk.servlets.ImagesServlet;
import com.inet.helpdesk.servlets.MulticastServlet;
import com.inet.helpdesk.servlets.konnekterproxy.KonnekterProxy;
import com.inet.helpdesk.servlets.rpc.JsonRpcServlet;
import com.inet.helpdesk.servlets.rpc.RpcImagesServlet;
import com.inet.helpdesk.servlets.rpc.handler.BundleTicketsHandler;
import com.inet.helpdesk.servlets.rpc.handler.CopyDeleteDeviceHandler;
import com.inet.helpdesk.servlets.rpc.handler.CurrentUserHandler;
import com.inet.helpdesk.servlets.rpc.handler.PluginsPacketHandler;
import com.inet.helpdesk.servlets.rpc.handler.UserDetailHandler;
import com.inet.helpdesk.servlets.rpc.handler.UserResponseCreator;
import com.inet.helpdesk.servlets.rpc.handler.UserSearchHandler;
import com.inet.helpdesk.shared.ConnectorStatisticsProvider;
import com.inet.helpdesk.shared.communication.DbWriter;
import com.inet.helpdesk.shared.communication.DeleteTickets;
import com.inet.helpdesk.shared.communication.LocationDataAccess;
import com.inet.helpdesk.shared.communication.Processing;
import com.inet.helpdesk.shared.communication.ServerDataAccess;
import com.inet.helpdesk.shared.communication.UserGroupDataAccess;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.util.SqlUtilities;
import com.inet.helpdesk.theme.HelpDeskThemeService;
import com.inet.helpdesk.ticketmanager.NewTicketDataConnectorImpl;
import com.inet.helpdesk.ticketmanager.TicketManagerFactoryImpl;
import com.inet.helpdesk.ticketmanager.adapt.TicketEventToTicketChangeListener;
import com.inet.helpdesk.ticketmanager.extensions.BundleTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.CloseTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.CreateTicketFromMailExtension;
import com.inet.helpdesk.ticketmanager.extensions.DeadlineMahnenTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.DeadlineUpdateExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.EscalateOrAuthorizeTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.ProcessingTimeActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.ReactivateTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.ReopenTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.extensions.UnbundleTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.internal.DefaultValueManagerImpl;
import com.inet.helpdesk.ticketmanager.internal.MandatoryFieldsManagerImpl;
import com.inet.helpdesk.ticketmanager.trigger.StatusAndItilChangeTrigger;
import com.inet.helpdesk.ticketview.ItilMasterSubViewGroupingEventListener;
import com.inet.helpdesk.ticketview.TicketViewGroupEventListener;
import com.inet.helpdesk.ticketview.TicketViewManagerImpl;
import com.inet.helpdesk.ticketview.TicketViewTicketEventListener;
import com.inet.helpdesk.ticketview.TicketViewUserEventListener;
import com.inet.helpdesk.ticketview.UserFieldsWithClientSettingsForTicketList;
import com.inet.helpdesk.ticketview.standardviews.InquiryTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.LastEditorTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.OpenTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.OwnTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.SupervisorTicketViewDefinition;
import com.inet.helpdesk.ticketview.subview.ItilMasterSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.ItilSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.MyResourceSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.PrioritySubViewGrouping;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.SupervisorSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.UserFieldSubViewGrouping;
import com.inet.helpdesk.usersandgroups.DisableMyUserFieldsModifier;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.helpdesk.usersandgroups.HDUserImportFieldValueModifier;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.LocaleFilter;
import com.inet.helpdesk.usersandgroups.UnchangeableParentFieldValueModifier;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManagerFactory;
import com.inet.helpdesk.usersandgroups.ui.HDUserOrGroupAdditionalDetailProvider;
import com.inet.helpdesk.usersandgroups.ui.MaxUserDetails;
import com.inet.helpdesk.usersandgroups.ui.NamedUserDetails;
import com.inet.helpdesk.usersandgroups.ui.ResourceGroupDeletionHandler;
import com.inet.helpdesk.usersandgroups.ui.ResourcesPermissionPatcher;
import com.inet.helpdesk.usersandgroups.ui.SetAsDefaultGUIPreferencesCustomUserAction;
import com.inet.helpdesk.usersandgroups.ui.SupportersPermissionPatcher;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettings;
import com.inet.helpdesk.usersandgroups.ui.effectiveactions.EffectiveActionsHandler;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.AllowedActionsFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.GeneralResourcesGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.LumpSumUserFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.MembersResourcesGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.NotificationSettingsResourcesGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.PermissionsGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.ResourcesGuestFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.ResourcesMasterFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.ResourcesStandardUserFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.WorkingHoursResourcesGroupFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.AllowedActionsGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.EscalationGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.OtherResourcesGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.ResHourRangeGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.ResNotificationSettingsGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.ResSettingsGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.TimerFromResSettingsGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.AllowedActionsUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.HDLoginsUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.HDOptionStringUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.ImportedHintUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.LanguageUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.LocationUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.SupervisableGroupUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.user.ValueProviderUserFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.filter.DispatcherUserFilter;
import com.inet.helpdesk.usersandgroups.ui.filter.EndUserFilter;
import com.inet.helpdesk.usersandgroups.ui.filter.NamedUserFilter;
import com.inet.helpdesk.usersandgroups.ui.filter.ResourceGroupsFilter;
import com.inet.helpdesk.usersandgroups.ui.filter.SupporterUserFilter;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManagerFactory;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketSearchHandler;
import com.inet.http.MDNSServletService;
import com.inet.http.PluginServlet;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.CoreLoggers;
import com.inet.notification.NotificationGroup;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.CoreServerPlugin;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.ConfigHelpProvider;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.veto.VetoPower;
import com.inet.plugin.veto.VetoSemaphore;
import com.inet.plugin.veto.VetoType;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.plugins.config.server.ConfigAngularApplicationServlet;
import com.inet.shared.plugins.theme.server.ThemeResource;
import com.inet.shared.statistics.eventlog.EventLogDescription;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldAndGroupTypeAssociation;
import com.inet.usersandgroups.api.FieldValueModifier;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.UserGroupManagerFactory;
import com.inet.usersandgroups.api.UserManagerFactory;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.CustomUserAction;
import com.inet.usersandgroups.api.ui.GroupDeletionHandler;
import com.inet.usersandgroups.api.ui.details.StatisticalUserDetails;
import com.inet.usersandgroups.api.ui.details.UserOrGroupAdditionalDetailProvider;
import com.inet.usersandgroups.api.ui.fieldgroups.FieldPanelDefinition;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.PermissionPatcher;
import com.inet.usersandgroups.api.ui.fields.group.CurrencyGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.EmailGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.GroupNameFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.MembersGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.ParentIdGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.PermissionGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.CurrencyUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.HintUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.LoginsUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.MembershipsUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.StringUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.ui.filter.UserOrGroupFilter;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.DayOfWeek;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.servlet.Filter;
import srv.ConfigurationInitializer;
import srv.HdConnectorStatisticsProvider;
import srv.ServerInitializer;
import srv.ServerInterface;
import srv.ServerUtilities;
import srv.controller.ResourceDataReloaderForOOC;
import srv.controller.ticket.timeline.TimelineDataHandlerImpl;

@PluginInfo(id="helpdesk", dependencies="reporting;mail", optionalDependencies="remotegui;theme;statistics;webapi.core;attachments;configuration;ticketlist;collaboration", packages="com.inet.helpdesk.plugin;com.inet.helpdesk.core;com.inet.helpdesk.shared;com.inet.helpdesk.theme;com.inet.helpdesk.config;com.inet.jj.srv;com.inet.dbupdater;com.inet.helpdesk.usersandgroups;com.inet.helpdesk.webapi;com.inet.plugin.client;com.inet.plugin.extensionpoint.abstracts;com.inet.helpdesk.bot", group="system;tickets;webapi", flags="core", internal="Konnekter-Server.jar;rhino.jar", icon="com/inet/helpdesk/images/user/helpdesk_64.png", version="21.10.801")
public class HelpdeskServerPlugin
implements ServerPlugin,
CoreServerPlugin {
    public static final String PLUGIN_ID = "helpdesk";
    public static final VetoType HD_SERVER_START = new VetoType("HD Server Start", 200);
    public static final I18nMessages MSG_CLIENT = new I18nMessages("com.inet.helpdesk.plugin.helpdeskconfig.i18n.LanguageResources", HelpdeskServerPlugin.class);
    public static final I18nMessages MSG_CONFIG = new I18nMessages("com.inet.helpdesk.config.i18n.ConfigStructure", HelpdeskServerPlugin.class);
    public static final I18nMessages MSG_SERVER = new I18nMessages("com.inet.helpdesk.i18n.LanguageResources", HelpdeskServerPlugin.class);
    private ServerValuesConnectorImpl serverValuesConnector;
    private ConnectionFactory connectionFactory;
    private ServerInitializer serverInitializer;
    private ServerDataConnectorImpl serverDataConnector;
    private NewTicketDataConnectorImpl ticketDataConnector;
    private BundleTicketsHandler bundleTicketsHandler;
    private TimelineDataHandlerImpl timelineDataHandler;
    private DefaultValueManagerImpl defaultValueManagerImpl;
    private static UserEventAdapter REMOVE_USERREFERENCES_ON_DELETE;

    public void preInit(ServerPluginDescription spd) {
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new PluginsIdMigrator());
        try {
            new File(System.getProperty("java.io.tmpdir")).mkdirs();
        }
        catch (Throwable e2) {
            HDLogger.error(e2);
        }
        ConfigurationInitializer.setDefaultProperties();
        Thread.UncaughtExceptionHandler handler = (t, e) -> {
            try {
                FileOutputStream out = new FileOutputStream("fatalError.txt", true);
                PrintStream p = new PrintStream(out);
                e.printStackTrace(p);
                p.println();
                e.printStackTrace(System.err);
            }
            catch (FileNotFoundException e1) {
                HDLogger.error(e1);
                e1.printStackTrace(System.err);
            }
        };
        Thread.currentThread().setUncaughtExceptionHandler(handler);
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("manuals", 1000, new Permission[]{null}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("release-notes", 1010, new Permission[]{null}){}, new String[0]);
        container.add((HelpProvider)new ConfigHelpProvider("configuration", 9100, new Permission[]{Permission.CONFIGURATION}){

            public boolean isVisible(HelpPage helpPage) {
                if ("configuration".equalsIgnoreCase(helpPage.getKey()) || "configuration.autotext".equalsIgnoreCase(helpPage.getKey())) {
                    UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                    if (currentUserAccount == null) {
                        return false;
                    }
                    if (HDUsersAndGroups.isSupporter(currentUserAccount)) {
                        return true;
                    }
                    return SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION});
                }
                return super.isVisible(helpPage);
            }
        }, new String[]{"configuration"});
        container.add((HelpProvider)new ConfigHelpProvider("templates", 9111, new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION}){}, new String[]{"configuration"});
        container.add((HelpProvider)new HelpProviderImpl("usersandgroupsmanager", 9211, new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("webapi", 9212, new Permission[]{Permission.valueOfExistingOrCreate((String)"webapi.core")}){}, new String[0]);
    }

    public void registerExtension(final ServerPluginManager spm) {
        if (PLUGIN_ID.equals(spm.getCorePluginId())) {
            spm.register(ApplicationDescription.class, (Object)this.getApplicationDescription());
        }
        spm.register(ImagesConnector.class, (Object)new ImagesConnectorImpl());
        if (ConfigurationManager.isHelpCenterMode()) {
            return;
        }
        new ServerInterface();
        this.serverInitializer = ServerInitializer.getInstance();
        CoreLoggers.addLoggers((String[])new String[]{"HelpDesk", "Reporting", "Mail", "Config", "Attachments", "helpdeskserverstart"});
        this.connectionFactory = new ConnectionFactoryImpl(ServerUtilities.getJJServer());
        spm.register(ConfigStructureProvider.class, (Object)new HDConfigStructureProvider(this.connectionFactory));
        spm.register(ConfigStructureProvider.class, (Object)new HDConfigStructureProviderTicketValues(this.connectionFactory));
        spm.register(ConfigStructureProvider.class, (Object)new HDConfigStructureProviderTicketSettings(this.connectionFactory));
        spm.register(ConfigPage.class, (Object)new ServerConfigPage());
        spm.register(ConfigPage.class, (Object)new TicketConfigPage());
        spm.register(ConfigPage.class, (Object)new TemplatesConfigPage());
        spm.register(ConfigPage.class, (Object)new AutoTextConfigPage());
        spm.register(ServerInitializerStatus.class, (Object)ServerInitializer.getInstance());
        spm.register(ServerPluginManagerListener.class, (Object)ServerInitializer.getInstance());
        spm.register(VetoPower.class, (Object)this.serverInitializer);
        this.serverDataConnector = new ServerDataConnectorImpl(ServerUtilities.getJJServer());
        UserDataConnectorImpl userDataConnector = new UserDataConnectorImpl(this.connectionFactory);
        this.serverValuesConnector = new ServerValuesConnectorImpl();
        this.ticketDataConnector = new NewTicketDataConnectorImpl();
        spm.register(ServerValuesConnector.class, (Object)this.serverValuesConnector);
        spm.register(ServerDataConnector.class, (Object)this.serverDataConnector);
        spm.register(ConnectionFactory.class, (Object)this.connectionFactory);
        spm.register(UserDataConnector.class, (Object)userDataConnector);
        spm.register(TicketDataConnector.class, (Object)this.ticketDataConnector);
        spm.register(TicketEventListener.class, (Object)this.ticketDataConnector.getTicketEventListener());
        spm.register(TicketEventListener.class, (Object)ServerUtilities.conti);
        spm.register(SwingClientActiveUsersInfo.class, (Object)ServerUtilities.conti);
        this.timelineDataHandler = new TimelineDataHandlerImpl();
        spm.register(TimelineDataHandler.class, (Object)this.timelineDataHandler);
        TranslationTextConnectorImpl translationTextConnector = new TranslationTextConnectorImpl(this.connectionFactory);
        spm.register(TranslationTextConnector.class, (Object)translationTextConnector);
        spm.register(StatisticsConnector.class, (Object)new StatisticsConnectorImpl());
        spm.register(DataImportConnector.class, (Object)new DataImportConnectorImpl());
        MaintenanceConnectorImpl maintenanceConnector = new MaintenanceConnectorImpl(this.connectionFactory);
        spm.register(MaintenanceConnector.class, (Object)maintenanceConnector);
        spm.register(LocalizationBundle.class, (Object)new LocalizationBundleImpl());
        spm.register(SqlUtilities.class, (Object)ServerUtilities.sqlUtilities);
        spm.register(Searcher.class, (Object)new SearcherImpl());
        spm.register(TicketAccessInformationsProvider.class, (Object)ServerUtilities.conti.getTicketAccessController());
        spm.register(SessionServerDataProvider.class, (Object)new SessionServerDataProviderImpl());
        spm.register(AutoMailerFactory.class, (Object)new AutoMailerFactoryImpl());
        spm.register(DBUpdateBackdoor.class, (Object)new DBUpdateComponent());
        spm.register(ConnectorStatisticsProvider.class, (Object)new HdConnectorStatisticsProvider());
        ServerPacketHandler serverPacketHandler = new ServerPacketHandler(this.connectionFactory, this.serverDataConnector);
        spm.register(PacketHandler.class, (Object)serverPacketHandler);
        spm.register(ServerDataAccess.class, (Object)serverPacketHandler);
        UserResponseCreator builder = new UserResponseCreator();
        spm.register(PacketHandler.class, (Object)new PluginsPacketHandler(ServerInitializer.getInstance(), spm, builder));
        spm.register(PacketHandler.class, (Object)new UserSearchHandler(spm, builder));
        spm.register(PacketHandler.class, (Object)new UserDetailHandler(builder));
        this.bundleTicketsHandler = new BundleTicketsHandler();
        spm.register(PacketHandler.class, (Object)this.bundleTicketsHandler);
        spm.register(PacketHandler.class, (Object)new CopyDeleteDeviceHandler());
        spm.register(PacketHandler.class, (Object)new CurrentUserHandler(this.connectionFactory));
        DbWriterImpl writer = new DbWriterImpl();
        spm.register(PacketHandler.class, (Object)writer);
        spm.register(DbWriter.class, (Object)writer);
        ProcessingImp stepWriter = new ProcessingImp(ServerUtilities.getJJServer(), spm);
        spm.register(PacketHandler.class, (Object)stepWriter);
        spm.register(Processing.class, (Object)stepWriter);
        LocationDataAccessImpl customer = new LocationDataAccessImpl();
        spm.register(PacketHandler.class, (Object)customer);
        spm.register(LocationDataAccess.class, (Object)customer);
        UserGroupDataAccessImpl usergroup = new UserGroupDataAccessImpl();
        spm.register(PacketHandler.class, (Object)usergroup);
        spm.register(UserGroupDataAccess.class, (Object)usergroup);
        DeleteTicketsImpl deleter = new DeleteTicketsImpl(ServerUtilities.conti, this.connectionFactory);
        spm.register(PacketHandler.class, (Object)deleter);
        spm.register(DeleteTickets.class, (Object)deleter);
        spm.register(PluginServlet.class, (Object)new ContentServlet());
        spm.register(PluginServlet.class, (Object)new DictionariesServlet());
        spm.register(PluginServlet.class, (Object)new KonnekterProxy(ServerInitializer.getInstance()));
        spm.register(PluginServlet.class, (Object)new JsonRpcServlet(ServerInitializer.getInstance()));
        spm.register(PluginServlet.class, (Object)new ImagesServlet());
        spm.register(MDNSServletService.class, (Object)new MulticastServlet());
        spm.register(PluginServlet.class, (Object)new RpcImagesServlet());
        spm.register(PluginServlet.class, (Object)new ClientPluginsServlet());
        spm.register(ConnectionCreationListener.class, () -> ServerPropertiesConverter.convertEscalationWarningStatusIfNeeded());
        spm.register(FieldValueModifier.class, (Object)new HDUserImportFieldValueModifier());
        spm.register(FieldValueModifier.class, (Object)new DisableMyUserFieldsModifier());
        spm.register(FieldValueModifier.class, (Object)new UnchangeableParentFieldValueModifier());
        spm.register(GroupDeletionHandler.class, (Object)new ResourceGroupDeletionHandler());
        spm.runIfPluginLoaded("remotegui", () -> new Executable(){

            public void execute() {
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugin/helpdeskconfig/helpdeskconfig.js");
                combinedFile.addMessages(MSG_CLIENT);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
                combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.addMessages(new I18nMessages("com.inet.helpdesk.plugin.i18n.Application", (Object)this));
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 200, "remotegui.lib.js", combinedFile));
                combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/pages/configuration.templates.html");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.templates.html", combinedFile));
                spm.runIfPluginLoaded("usersandgroupsmanager", () -> new Executable(){

                    public void execute() {
                        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/renderer.js");
                        combinedFile.addMessages(new I18nMessages("com.inet.helpdesk.usersandgroups.ui.i18n.ClientResources", (Object)this));
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 200, "remotegui.lib.js", combinedFile));
                        combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/predeletionhandler.js");
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/setdefaultguipreferencesaction.js");
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/usersandgroupsreports.js");
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/js/effectiveactionscontroller.js");
                        combinedFile.addMessages(HDFieldDisplayNameProvider.MSG);
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 200, "usersandgroupsmanager.js", combinedFile));
                        FileCombiner.CombinedFile effectionActionsDialoghtml = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
                        effectionActionsDialoghtml.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/usersandgroups/ui/client/effectiveactionsdialog.html");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "effectiveactionsdialog.html", effectionActionsDialoghtml));
                        spm.register(ServiceMethod.class, (Object)new EffectiveActionsHandler());
                    }
                });
                spm.runIfPluginLoaded("configuration", () -> new Executable(){

                    public void execute() {
                        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/autotext/configuration.autotext.html");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.autotext.html", combinedFile));
                        combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/autotext/configuration.autotext.edit.html");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.autotext.edit.html", combinedFile));
                        combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/autotext/configuration.autotext.js");
                        combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/config/autotext/configuration.autotext.edit.js");
                        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
                    }
                });
                spm.runIfPluginLoaded("theme", () -> new Executable(){

                    public void execute() {
                        spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/config/autotext/css/autotext.less")));
                        spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/config/autotext/css/autotext-sprites.less")));
                    }
                });
            }
        });
        HdPermissions.OPTIONS.getKey();
        spm.register(Filter.class, (Object)new HelpDeskRequestFilter());
        spm.runIfPluginLoaded("theme", () -> new Executable(){

            public void execute() {
                try {
                    HelpDeskThemeService.registerResources(spm);
                }
                catch (Throwable e) {
                    HDLogger.error(e);
                }
            }
        });
        FileCombiner.CombinedFile cssFile = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "defaulttheme.css", cssFile));
        cssFile.add(this.getClass(), "/com/inet/helpdesk/theme/css/helpdeskremote.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/theme/css/helpdeskremote_sprites.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/config/autotext/css/autotext.css");
        cssFile.add(this.getClass(), "/com/inet/helpdesk/config/autotext/css/autotext-sprites.css");
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new TicketIdUidConfigMigrator());
        StatusAndItilChangeTrigger.registerTriggerAsListener(spm);
        spm.register(ConnectionCreationListener.class, () -> userDataConnector.initUserSearchController());
        spm.register(ConnectionCreationListener.class, () -> TicketManager.getReader());
        this.defaultValueManagerImpl = new DefaultValueManagerImpl();
        spm.register(DefaultValuesManager.class, (Object)this.defaultValueManagerImpl);
        spm.register(MandatoryFieldsManager.class, (Object)new MandatoryFieldsManagerImpl());
        spm.register(ConnectionCreationListener.class, () -> {
            ConnectionFactory conFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
            try (Connection con = conFactory.getConnection();
                 Statement stm = con.createStatement();
                 ResultSet rs = stm.executeQuery("SELECT * FROM tblOptionen");){
                int int1;
                if (!rs.next()) {
                    HDLogger.warn("[OptionsFromTblOptionenToConfig] No column in TblOptionen - skipped synchronizing defaut values!");
                    return;
                }
                Configuration configuration = ConfigurationManager.getInstance().getCurrent();
                configuration.put(HDConfigKeys.DEFAULT_USER_LOCATION_ID, String.valueOf(rs.getInt("GebID")));
                configuration.put(HDConfigKeys.DEFAULT_TICKET_ITIL_ID, String.valueOf(rs.getInt("ItiID")));
                configuration.put(HDConfigKeys.DEFAULT_EMAIL_SEND_CLOSE_TIME, String.valueOf(rs.getInt("reaktZeit")));
                String fontname = rs.getString("FontName");
                int fontsize = rs.getInt("FontSize");
                if (!StringFunctions.isEmpty((String)fontname) && fontsize > 0) {
                    configuration.put(HDConfigKeys.DEFAULT_TICKET_FONT_NAME, fontname);
                    configuration.put(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE, String.valueOf(fontsize));
                }
                configuration.put(HDConfigKeys.DEFAULT_TICKET_PLAINTEXT_REASTEP, ((int1 = rs.getInt("UsePlaintext")) & 1) == 1 ? "true" : "false");
                configuration.put(HDConfigKeys.DEFAULT_COMPANY_ADDRESS, rs.getString("Firma"));
                this.defaultValueManagerImpl.init(con);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Could not read ID of default values", ex);
            }
        });
        HDUsersAndGroups.getUserFieldsForRegistration().forEach(field -> spm.register(UserField.class, field));
        HDUsersAndGroups.getGroupFieldsForRegistration().forEach(field -> spm.register(UserGroupField.class, field));
        HDUsersAndGroups.getFieldAndGroupTypeAssociationsForRegistration().forEach(entry -> spm.register(FieldAndGroupTypeAssociation.class, entry));
        HDUsersAndGroups.getGroupTypeDefinitionsForRegistration().forEach(def -> spm.register(GroupTypeDef.class, def));
        HDUsersAndGroups.getPredefinedUserGroupsForRegistration().forEach(group -> spm.register(PredefinedUserGroup.class, group));
        spm.register(ConnectionCreationListener.class, () -> {
            BiConsumer<Object, Object> notifyManagers = (manager, recEnabledManager) -> {
                if (manager instanceof ConnectionCreationListener) {
                    ((ConnectionCreationListener)manager).connectionCreated();
                }
                if (recEnabledManager != manager && recEnabledManager instanceof ConnectionCreationListener) {
                    ((ConnectionCreationListener)recEnabledManager).connectionCreated();
                }
            };
            notifyManagers.accept(UserManager.getInstance(), UserManager.getRecoveryEnabledInstance());
            notifyManagers.accept(UserGroupManager.getInstance(), UserGroupManager.getRecoveryEnabledInstance());
        });
        spm.register(Filter.class, (Object)new LocaleFilter());
        spm.register(UserManagerFactory.class, (Object)new HelpDeskUserManagerFactory());
        spm.register(UserGroupManagerFactory.class, (Object)new HelpDeskUserGroupManagerFactory());
        spm.register(UserOrGroupFilter.class, (Object)new DispatcherUserFilter());
        spm.register(UserOrGroupFilter.class, (Object)new EndUserFilter());
        spm.register(UserOrGroupFilter.class, (Object)new NamedUserFilter());
        spm.register(UserOrGroupFilter.class, (Object)new ResourceGroupsFilter());
        spm.register(UserOrGroupFilter.class, (Object)new SupporterUserFilter());
        spm.runIfPluginLoaded("collaboration", () -> new Executable(){

            public void execute() {
                spm.register(BotCommand.class, (Object)new TicketInfoBotCommand());
                spm.register(BotCommand.class, (Object)new TicketSearchBotCommand());
            }
        });
        DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
        dem.register(FieldDefinition.class, (Object)new ImportedHintUserFieldDefinition("user.masterdata", 0));
        dem.register(FieldDefinition.class, (Object)new LocationUserFieldDefinition(120, 1){});
        dem.register(FieldDefinition.class, (Object)new SupervisableGroupUserFieldDefinition(125, 16){});
        dem.register(FieldDefinition.class, (Object)new StringUserFieldDefinition("user.masterdata", HDUsersAndGroups.FIELD_TELEPHONE.getKey(), 130){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForField(HDUsersAndGroups.FIELD_TELEPHONE.getKey());
            }
        });
        dem.register(FieldDefinition.class, (Object)new StringUserFieldDefinition("user.masterdata", HDUsersAndGroups.FIELD_ROOM.getKey(), 140){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_ROOM);
            }
        });
        dem.register(FieldDefinition.class, (Object)new StringUserFieldDefinition("user.masterdata", HDUsersAndGroups.FIELD_DEPARTMENT.getKey(), 150){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_DEPARTMENT);
            }
        });
        dem.register(FieldDefinition.class, (Object)new LanguageUserFieldDefinition(170));
        dem.register(FieldDefinition.class, (Object)new StringUserFieldDefinition("user.masterdata", HDUsersAndGroups.FIELD_COMPUTER_NAME.getKey(), 180){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_COMPUTER_NAME);
            }

            public FieldValue getFieldValue(UserAccount userAccount) {
                FieldValue fieldValue = super.getFieldValue(userAccount);
                fieldValue.setEnabled(false);
                return fieldValue;
            }
        });
        dem.register(FieldDefinition.class, (Object)new StringUserFieldDefinition("user.masterdata", HDUsersAndGroups.FIELD_COST_CENTRE.getKey(), 190){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_COST_CENTRE);
            }
        });
        dem.register(FieldDefinition.class, (Object)new HintUserFieldDefinition(LumpSumUserFieldPanelDefinition.FIELD_PANEL_KEY, 1){

            public String getHint() {
                return HDFieldDisplayNameProvider.MSG.getMsg("field.lumpsum.hint", new Object[0]);
            }
        });
        dem.register(FieldDefinition.class, (Object)new CurrencyUserFieldDefinition(LumpSumUserFieldPanelDefinition.FIELD_PANEL_KEY, HDUsersAndGroups.FIELD_LUMP_SUM_1.getKey(), 10){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_LUMP_SUM_1);
            }
        });
        dem.register(FieldDefinition.class, (Object)new CurrencyUserFieldDefinition(LumpSumUserFieldPanelDefinition.FIELD_PANEL_KEY, HDUsersAndGroups.FIELD_LUMP_SUM_2.getKey(), 20){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_LUMP_SUM_2);
            }
        });
        dem.register(FieldDefinition.class, (Object)new CurrencyUserFieldDefinition(LumpSumUserFieldPanelDefinition.FIELD_PANEL_KEY, HDUsersAndGroups.FIELD_LUMP_SUM_3.getKey(), 30){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_LUMP_SUM_3);
            }
        });
        dem.register(FieldDefinition.class, (Object)new StringUserFieldDefinition("user.masterdata", HDUsersAndGroups.FIELD_CLIENT_DETAILS.getKey(), 181){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForField(HDUsersAndGroups.FIELD_CLIENT_DETAILS.getKey());
            }

            public FieldValue getFieldValue(UserAccount userAccount) {
                FieldValue fieldValue = super.getFieldValue(userAccount);
                fieldValue.setEnabled(false);
                return fieldValue;
            }
        });
        HelpdeskServerPlugin.registerCustomFieldDefinition(dem);
        spm.register(StatisticalUserDetails.class, (Object)new NamedUserDetails());
        spm.register(StatisticalUserDetails.class, (Object)new MaxUserDetails());
        spm.register(FieldPanelDefinition.class, (Object)new LumpSumUserFieldPanelDefinition(UserAccountType.Standard));
        spm.register(FieldPanelDefinition.class, (Object)new LumpSumUserFieldPanelDefinition(UserAccountType.Guest));
        spm.register(FieldPanelDefinition.class, (Object)new ResourcesStandardUserFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new ResourcesGuestFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new ResourcesMasterFieldPanelDefinition());
        dem.register(FieldDefinition.class, (Object)new MembershipsUserFieldDefinition(ResourcesStandardUserFieldPanelDefinition.FIELD_GROUP_KEY, "fieldtype_members" + HDUsersAndGroups.RESOURCE.getName(), HDUsersAndGroups.RESOURCE, "resourcesonly", 100));
        dem.register(FieldDefinition.class, (Object)new MembershipsUserFieldDefinition(ResourcesGuestFieldPanelDefinition.FIELD_GROUP_KEY, "fieldtype_members" + HDUsersAndGroups.RESOURCE.getName(), HDUsersAndGroups.RESOURCE, "resourcesonly", 100));
        dem.register(FieldDefinition.class, (Object)new MembershipsUserFieldDefinition(ResourcesMasterFieldPanelDefinition.FIELD_GROUP_KEY, "fieldtype_members" + HDUsersAndGroups.RESOURCE.getName(), HDUsersAndGroups.RESOURCE, "resourcesonly", 100));
        dem.register(FieldDefinition.class, (Object)new AllowedActionsUserFieldDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UserAccountType.Standard));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UserAccountType.Guest));
        dem.register(FieldDefinition.class, (Object)new AllowedActionsGroupFieldDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UsersAndGroups.GROUPTYPE_ALLUSERS, 505));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UsersAndGroups.GROUPTYPE_STANDARD, 505));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(UsersAndGroups.GROUPTYPE_AUTH, 505));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(HDUsersAndGroups.GROUPTYPE_SUPPORTERS, 205));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(HDUsersAndGroups.GROUPTYPE_ENDUSER, 205));
        spm.register(FieldPanelDefinition.class, (Object)new AllowedActionsFieldPanelDefinition(HDUsersAndGroups.RESOURCE, 205));
        spm.register(FieldPanelDefinition.class, (Object)new PermissionsGroupFieldPanelDefinition(HDUsersAndGroups.GROUPTYPE_SUPPORTERS, PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_SUPPORTERS));
        dem.register(FieldDefinition.class, (Object)new PermissionGroupFieldDefinition(PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_SUPPORTERS, "fieldtype_permission", 100));
        spm.register(PermissionPatcher.class, (Object)new SupportersPermissionPatcher());
        spm.register(FieldPanelDefinition.class, (Object)new PermissionsGroupFieldPanelDefinition(HDUsersAndGroups.GROUPTYPE_ENDUSER, PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_ENDUSERS));
        dem.register(FieldDefinition.class, (Object)new PermissionGroupFieldDefinition(PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_ENDUSERS, "fieldtype_permission", 100));
        spm.register(FieldPanelDefinition.class, (Object)new PermissionsGroupFieldPanelDefinition(HDUsersAndGroups.RESOURCE, PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_RESOURCES));
        spm.register(FieldPanelDefinition.class, (Object)new MembersResourcesGroupFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new GeneralResourcesGroupFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new NotificationSettingsResourcesGroupFieldPanelDefinition());
        spm.register(FieldPanelDefinition.class, (Object)new WorkingHoursResourcesGroupFieldPanelDefinition());
        spm.register(PermissionPatcher.class, (Object)new ResourcesPermissionPatcher());
        dem.register(FieldDefinition.class, (Object)new PermissionGroupFieldDefinition(PermissionsGroupFieldPanelDefinition.FIELD_PANEL_KEY_RESOURCES, "fieldtype_permission", 100));
        dem.register(FieldDefinition.class, (Object)new MembersGroupFieldDefinition("resource.members", HDUsersAndGroups.RESOURCE, "fieldtype_members", 100));
        dem.register(FieldDefinition.class, (Object)new GroupNameFieldDefinition("resource.general", 10));
        Arrays.stream(DayOfWeek.values()).forEach(dayOfWeek -> dem.register(FieldDefinition.class, (Object)new ResHourRangeGroupFieldDefinition(WorkingHoursResourcesGroupFieldPanelDefinition.FIELD_GROUP_KEY, (DayOfWeek)dayOfWeek)));
        dem.register(FieldDefinition.class, (Object)new ParentIdGroupFieldDefinition("resource.general", "resource.parent", 20, HDUsersAndGroups.RESOURCE, HDUsersAndGroups.GROUPTYPEDEF_RESOURCE.getMaxTreeLevel()){

            public String getLabel() {
                return HDFieldDisplayNameProvider.MSG.getMsg("field.resourceparent", new Object[0]);
            }
        });
        dem.register(FieldDefinition.class, (Object)new OtherResourcesGroupFieldDefinition());
        dem.register(FieldDefinition.class, (Object)new ResSettingsGroupFieldDefinition("resource.general", 30, 1));
        dem.register(FieldDefinition.class, (Object)new ResSettingsGroupFieldDefinition("resource.general", 40, 2));
        dem.register(FieldDefinition.class, (Object)new TimerFromResSettingsGroupFieldDefinition("resource.general", 50));
        dem.register(FieldDefinition.class, (Object)new CurrencyGroupFieldDefinition("resource.general", HDUsersAndGroups.RES_FIELD_HOURLY_RATE.getKey(), 60){

            public String getLabel() {
                return HDFieldDisplayNameProvider.MSG.getMsg("field.resourcehourlyrate", new Object[0]);
            }
        });
        dem.register(FieldDefinition.class, (Object)new EscalationGroupFieldDefinition("resource.general", HDUsersAndGroups.RES_FIELD_ESC_RES_ID, 70));
        dem.register(FieldDefinition.class, (Object)new EmailGroupFieldDefinition("resource.general", HDUsersAndGroups.RES_FIELD_EMAIL.getKey(), 80){

            public String getLabel() {
                return HDFieldDisplayNameProvider.MSG.getMsg("field.resourceemail", new Object[0]);
            }
        });
        dem.register(FieldDefinition.class, (Object)new ResSettingsGroupFieldDefinition("resource.notificationsettings", 20, 4));
        dem.register(FieldDefinition.class, (Object)new ResNotificationSettingsGroupFieldDefinition("resource.notificationsettings", 30, 4));
        dem.register(FieldDefinition.class, (Object)new ResNotificationSettingsGroupFieldDefinition("resource.notificationsettings", 40, 8));
        spm.register(NotificationGroup.class, (Object)new ResourceNotificationGroup());
        spm.register(UserOrGroupAdditionalDetailProvider.class, (Object)new HDUserOrGroupAdditionalDetailProvider());
        spm.register(CustomUserAction.class, (Object)new SetAsDefaultGUIPreferencesCustomUserAction());
        spm.register(LoginListener.class, (Object)new ComputerNameSetter());
        spm.register(ServerValuesConnector.ValueProvider.class, (Object)new CategoryByIDValueProvider(Field.TICKETDATA_CATEGORYID.name()));
        Tickets.getAttributesForRegistration().forEach(att -> spm.register(TicketAttribute.class, (Object)att));
        Tickets.getFieldsForRegistration().forEach(field -> spm.register(TicketField.class, (Object)field));
        Tickets.getFieldDefinitionsForRegistration().forEach(fieldDefinition -> spm.register(TicketFieldDefinition.class, fieldDefinition));
        ReaStepVO.getAttributesForRegistration().forEach(att -> spm.register(ReaStepAttribute.class, (Object)att));
        ReaStepVO.getFieldsForRegistration().forEach(field -> spm.register(ReaStepField.class, (Object)field));
        ExtensionArguments.getExtArgsForRegistration().forEach(extArg -> spm.register(ExtensionArguments.ExtArg.class, extArg));
        spm.register(ExtensionArguments.ExtArg.class, UnbundleTicketActionExtensionFactory.EXTARG_UNBUNDLE_TICKETS);
        SearchTagTicketTags.getTagsForRegistration().forEach(tag -> spm.register(SearchTagTicketTags.TicketTag.class, tag));
        spm.register(TicketActionExtensionFactory.class, (Object)new EscalateOrAuthorizeTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new BundleTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new UnbundleTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new ReactivateTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new ProcessingTimeActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new UpdateReaStepTextExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new DeadlineMahnenTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new CloseTicketActionExtensionFactory());
        spm.register(TicketActionExtensionFactory.class, (Object)new ReopenTicketActionExtensionFactory());
        spm.register(AutoTextManager.class, (Object)new AutoTextManager());
        spm.register(TicketActionFilter.class, (Object)new TicketActionFilter(){

            @Override
            public void filterActions(int ticketId, List<ActionVO> actions) throws IOException {
                actions.removeIf(a -> a.getId() == -25 && TicketManager.getReaderForSystem().getTicket(ticketId).getValue(Tickets.FIELD_TERMINVEREINBARUNG) == null);
            }
        });
        DeadlineUpdateExtensionFactory deadlineUpdateExtensionFactory = new DeadlineUpdateExtensionFactory();
        spm.register(CreateTicketExtensionFactory.class, (Object)deadlineUpdateExtensionFactory);
        spm.register(UpdateTicketDataExtension.class, (Object)deadlineUpdateExtensionFactory);
        spm.register(CreateTicketExtensionFactory.class, (Object)new CreateTicketFromMailExtension());
        spm.register(VetoPower.class, (Object)new VetoPower(){

            public VetoType getType() {
                return TicketManagerVetoPower.TYPE;
            }

            public VetoSemaphore checkForVeto() {
                return TicketManager.getVetoPower().checkForVeto();
            }
        });
        spm.register(TicketManagerFactory.class, (Object)new TicketManagerFactoryImpl());
        this.ticketDataConnector.setupOnRegister(this.serverDataConnector, this.serverValuesConnector, userDataConnector, this.connectionFactory);
        spm.register(UserGroupEventListener.class, (Object)new ResourceDataReloaderForOOC());
        spm.register(UserEventListener.class, (Object)new UserEventAdapter(){

            public void userAccountBeforeDeleted(UserAccount userAccount) {
                REMOVE_USERREFERENCES_ON_DELETE.userAccountBeforeDeleted(userAccount);
            }
        });
        ItilLinkManagerImpl itilLinkManager = new ItilLinkManagerImpl();
        spm.register(ItilLinkManager.class, (Object)itilLinkManager);
        spm.register(ConnectionCreationListener.class, (Object)itilLinkManager);
        spm.register(UserGroupField.class, UserFieldsWithClientSettings.USER_FIELDS_WITH_CLIENT_SETTINGS);
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_ALLUSERS, new HashSet<String>(Arrays.asList(UserFieldsWithClientSettings.USER_FIELDS_WITH_CLIENT_SETTINGS.getKey()))));
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_STANDARD, new HashSet<String>(Arrays.asList(UserFieldsWithClientSettings.USER_FIELDS_WITH_CLIENT_SETTINGS.getKey()))));
        spm.register(UserFieldsWithClientSettings.class, (Object)new UserFieldsWithClientSettingsForTicketList());
        spm.register(TicketViewManager.class, (Object)new TicketViewManagerImpl());
        spm.register(UserField.class, TicketViewManager.TICKET_VIEW_USERFIELD);
        spm.register(UserField.class, TicketViewManager.TICKET_VIEW_VISIBILITY);
        spm.register(UserGroupField.class, TicketViewManager.GLOBAL_TICKET_VIEW);
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_ALLUSERS, new String[]{TicketViewManager.GLOBAL_TICKET_VIEW.getKey()}));
        spm.register(TicketEventListener.class, (Object)TicketViewTicketEventListener.getInstance());
        spm.register(TicketEventListener.class, (Object)new EventLogTicketEventListener());
        spm.register(TicketEventListener.class, (Object)new ItilChangedTicketEventListener());
        spm.register(TicketEventListener.class, (Object)this.timelineDataHandler);
        spm.runIfPluginLoaded("statistics", () -> new Executable(){

            public void execute() {
                spm.register(EventLogDescription.class, (Object)new TicketEventLogDescription());
            }
        });
        spm.register(UserGroupEventListener.class, (Object)new TicketViewGroupEventListener());
        spm.register(UserEventListener.class, (Object)new TicketViewUserEventListener());
        spm.register(TicketViewFactory.class, (Object)new OwnTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new SupervisorTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new InquiryTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new OpenTicketViewDefinition());
        spm.register(TicketViewFactory.class, (Object)new LastEditorTicketViewDefinition());
        spm.register(SubViewGroupingDefinition.class, (Object)ResourceSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)MyResourceSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)SupervisorSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)PrioritySubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CATEGORY_ID));
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CLASSIFICATION_ID));
        spm.register(SubViewGroupingDefinition.class, (Object)new UserFieldSubViewGrouping(HDUsersAndGroups.FIELD_LOCATION_ID));
        spm.register(SubViewGroupingDefinition.class, (Object)ItilSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)ItilMasterSubViewGrouping.INSTANCE);
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CUSTOM_1));
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CUSTOM_2));
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CUSTOM_3));
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CUSTOM_4));
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CUSTOM_5));
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CUSTOM_6));
        spm.register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(Tickets.FIELD_CUSTOM_7));
        ItilMasterSubViewGroupingEventListener itilMasterSubViewGroupingEventListener = new ItilMasterSubViewGroupingEventListener();
        ItilManager.getInstance().addDataChangeListener(itilMasterSubViewGroupingEventListener);
        itilLinkManager.registerListener(itilMasterSubViewGroupingEventListener);
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("globalsearch"));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("globalviews"));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("myviews"));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("supervisor"));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("resourceid", () -> Tickets.getFieldDisplayName("resourceid")));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("itil", () -> HDFieldDisplayNameProvider.getDisplayNameForCustomField(Tickets.FIELD_ITIL_ID)));
        spm.register(TicketViewCategory.class, (Object)new TicketViewCategory("priority", () -> HDFieldDisplayNameProvider.getDisplayNameForCustomField(Tickets.FIELD_PRIORITY_ID)));
        spm.register(ConnectionCreationListener.class, () -> ServerUtilities.getOpenOrderController().init());
        spm.register(ConnectionCreationListener.class, () -> this.timelineDataHandler.init());
        new ReportingServerPluginRegistration().registerExtension(spm);
        spm.register(TicketEventListener.class, (Object)new TicketEventToTicketChangeListener());
        spm.runIfPluginLoaded("webapi.core", () -> new Executable(){

            public void execute() {
                HelpDeskTicketWebAPIExtension.registerExtension(spm, new RequestHandlerBase[]{new HelpDeskTicketSearchHandler()});
            }
        });
        spm.register(ActionCreationNotificator.class, (Object)new ActionCreationNotificatorImpl());
    }

    private static void registerCustomFieldDefinition(DynamicExtensionManager dem) {
        List<ServerValuesConnector.ValueProvider> providers = QueryValueProvider.getQueryValueProviders();
        UserField[] fields = new UserField[]{HDUsersAndGroups.FIELD_CUSTOM_1, HDUsersAndGroups.FIELD_CUSTOM_2, HDUsersAndGroups.FIELD_CUSTOM_3, HDUsersAndGroups.FIELD_CUSTOM_4, HDUsersAndGroups.FIELD_CUSTOM_5};
        int[] customFieldsSettingsIds = new int[]{2, 3, 4, 5, 6};
        int settingsCounter = 0;
        int prio = 200;
        for (final UserField userField : fields) {
            int settingId = customFieldsSettingsIds[settingsCounter++];
            ServerValuesConnector.ValueProvider valueProvider = null;
            for (ServerValuesConnector.ValueProvider provider : providers) {
                Field field = Field.valueOf(provider.getFieldKey());
                if (userField != HDFieldLocator.getFieldForOldDbField(field)) continue;
                valueProvider = provider;
                break;
            }
            Object def = valueProvider == null ? new HDOptionStringUserFieldDefinition("user.masterdata", userField.getKey(), prio++, settingId){

                public String getLabel() {
                    return HDFieldDisplayNameProvider.getDisplayNameForCustomField(userField);
                }
            } : new ValueProviderUserFieldDefinition("user.masterdata", userField, prio++, valueProvider, settingId){};
            dem.register(FieldDefinition.class, def);
        }
        dem.register(FieldDefinition.class, (Object)new HDOptionStringUserFieldDefinition("user.masterdata", HDUsersAndGroups.FIELD_CUSTOM_6.getKey(), "fieldtype_multiline", prio, 7){

            public String getLabel() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_CUSTOM_6);
            }
        });
    }

    public void init(final ServerPluginManager spm) {
        if (ConfigurationManager.isHelpCenterMode()) {
            return;
        }
        this.throwIfValuesOfRegisteredExtArgsDoNotImplementHashCodeAndEquals(spm);
        List fieldDefinitions = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        fieldDefinitions.stream().filter(f -> f instanceof LoginsUserFieldDefinition).findFirst().ifPresent(f -> DynamicExtensionManager.getInstance().unregister(FieldDefinition.class, f));
        HDLoginsUserFieldDefinition loginFieldDef = new HDLoginsUserFieldDefinition("logins", "logins", 100);
        DynamicExtensionManager.getInstance().register(FieldDefinition.class, (Object)loginFieldDef);
        this.serverInitializer.start();
        this.serverDataConnector.init();
        this.serverValuesConnector.init();
        this.ticketDataConnector.init(UserManager.getInstance(), ServerUtilities.conti.getTicketAccessController(), spm);
        new ReportingServerPluginRegistration().init(spm);
        ((ItilLinkManager)spm.getSingleInstance(ItilLinkManager.class)).registerListener(new GeneratedAttributeItilCountEventListener());
        spm.runIfPluginLoaded("configuration", () -> new Executable(){

            public void execute() {
                ConfigAngularApplicationServlet configAngularApplicationServlet = (ConfigAngularApplicationServlet)spm.getSingleInstance(ConfigAngularApplicationServlet.class);
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new ScaledTicketValueIcon());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadAvailableAutoTexts());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new AutoTextIcon());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new CreateOrEditAutoText());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new SaveAutoText());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new DeleteAutoText());
            }
        });
    }

    private void throwIfValuesOfRegisteredExtArgsDoNotImplementHashCodeAndEquals(ServerPluginManager spm) {
        for (ExtensionArguments.ExtArg extArg : spm.get(ExtensionArguments.ExtArg.class)) {
            try {
                if (extArg.getValueType().isEnum()) continue;
                Method methodHashCode = extArg.getValueType().getMethod("hashCode", new Class[0]);
                if (methodHashCode.getDeclaringClass() != extArg.getValueType()) {
                    throw new IllegalStateException("ValueType of ExtArg with key \"" + extArg.getKey() + "\" must implement hashCode.");
                }
                Method methodEquals = extArg.getValueType().getMethod("equals", Object.class);
                if (methodEquals.getDeclaringClass() == extArg.getValueType()) continue;
                throw new IllegalStateException("ValueType of ExtArg with key \"" + extArg.getKey() + "\" must implement equals.");
            }
            catch (NoSuchMethodException | SecurityException ex) {
                HDLogger.error("Error while checking whether ValueType of ExtArg with key \"" + extArg.getKey() + "\" implements hashCode and equals.");
                throw new RuntimeException(ex);
            }
        }
    }

    public void reset() {
        this.serverInitializer.interruptExecution();
    }

    public void restart() {
    }

    public RecoveryConfiguration getRecoveryLauncher() {
        return new HdStandaloneConfiguration();
    }

    public ApplicationDescription getApplicationDescription() {
        return new HelpdeskApplicationDescription();
    }

    static {
        ConfigurationManager.NAME_DEFAULT = HelpDeskInstanceName.get();
        REMOVE_USERREFERENCES_ON_DELETE = new UserEventAdapter(){

            public void userAccountBeforeDeleted(UserAccount userAccount) {
                TicketManager.getMaintenance().removeReferencesToUserAccountFromAllTicketsAndReaSteps(userAccount.getID());
            }
        };
    }
}

