/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.HDLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import srv.controller.ticket.Auftrag;

public class SqlBuilder {
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SIMPLE_OR = 0;
    public static final int SIMPLE_AND = 1;
    public static final int ONE_OF = 2;
    private int dbTyp;
    private int[] availableResources;

    public SqlBuilder(int dbTyp, int[] availableResources) {
        this.dbTyp = dbTyp;
        this.availableResources = availableResources;
    }

    protected void setDbTyp(int dbTyp) {
        this.dbTyp = dbTyp;
    }

    public int buildSql(int searchIn, int firstGroupType, String firstGroupValue, int secondGroupType, String secondGroupValue, StringBuilder buf, String searchText, boolean searchInRequest, boolean searchInSubject, boolean searchInComment, boolean searchInEmailAddress, boolean searchInNachname, boolean searchInTicketID, int ticketOwnerId, int statusID, int classificationID, Date from, Date to, int[] groupIds) {
        int caseCounter;
        String string = searchText = searchText == null ? "" : searchText.trim();
        if (searchInRequest) {
            searchIn |= 1;
        }
        if (searchInSubject) {
            searchIn |= 2;
        }
        if (searchInComment) {
            searchIn |= 4;
        }
        int n = caseCounter = searchIn == 0 ? 0 : 1;
        if (searchText.length() > 0) {
            int typ;
            if (searchInEmailAddress) {
                typ = 0;
                if (caseCounter == 0) {
                    typ = searchInNachname || searchInTicketID ? 2 : 1;
                }
                ++caseCounter;
                this.addLike(buf, "tblUser.Email", searchText, typ);
            }
            if (searchInNachname) {
                typ = 0;
                if (caseCounter == 0) {
                    typ = searchInTicketID ? 2 : 1;
                }
                ++caseCounter;
                this.addLike(buf, "tblUser.Nachname", searchText, typ);
            }
            if (searchInTicketID) {
                String success;
                if ((success = this.getAufIDsql(searchText, ++caseCounter > 1)).length() > 0) {
                    buf.append(success);
                } else {
                    --caseCounter;
                }
            }
        }
        if (caseCounter > 1) {
            buf.append(") ");
        } else if (caseCounter > 0) {
            buf.append(" ");
        }
        if (ticketOwnerId > -1) {
            buf.append("AND tblUser.UsrID = ").append(ticketOwnerId).append(' ');
        }
        if (classificationID > -1) {
            buf.append("AND tblAuftraege.KlaID = ").append(classificationID).append(' ');
        }
        if (to != null) {
            to.setTime(to.getTime());
            to = new Date(to.getTime() + 86400000L);
        }
        if (from != null && to != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            buf.append("AND ((tblBuendel.BearbeitungsDatum Between {d '").append(df.format(from)).append("'} AND {d '").append(df.format(to)).append("'}) OR (tblBuendel.AnfrageDatum Between {d '").append(df.format(from)).append("'} AND {d '").append(df.format(to)).append("'})) ");
        } else if (to != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            buf.append("AND (tblBuendel.BearbeitungsDatum < {d '").append(df.format(to)).append("'} OR tblBuendel.AnfrageDatum < {d '").append(df.format(to)).append("'}) ");
        } else if (from != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            buf.append("AND (tblBuendel.BearbeitungsDatum > {d '").append(df.format(from)).append("'} OR tblBuendel.AnfrageDatum > {d '").append(df.format(from)).append("'}) ");
        }
        if (groupIds != null && groupIds.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int gid : groupIds) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("" + gid);
            }
            buf.append("AND tblUser.BgrID IN (").append(sb.toString()).append(") ");
        }
        if (statusID > 99) {
            buf.append("AND tblBuendel.Status = ").append(statusID).append(' ');
        } else if (buf.length() == 0) {
            buf.append("AND 0 = 1 ");
        } else if (statusID != 0) {
            buf.append("AND tblBuendel.Status > 99 ");
        }
        if (firstGroupType == Auftrag.Field.RESOURCE.ordinal()) {
            int firstGroupNumber = Integer.parseInt(firstGroupValue);
            SqlBuilder.addResourcesToSql(firstGroupNumber, this.availableResources, buf);
        } else if (firstGroupType > 0) {
            buf.append("AND ").append(Auftrag.Field.values()[firstGroupType].getKeyColumn()).append(" = ").append(firstGroupValue).append(' ');
        }
        if (secondGroupType > 0) {
            buf.append("AND ").append(Auftrag.Field.values()[secondGroupType].getKeyColumn()).append(" = ").append(secondGroupValue).append(' ');
        }
        return searchIn;
    }

    private static void addResourcesToSql(int resource, int[] availableResources, StringBuilder buf) {
        if (resource != -1) {
            buf.append("AND tblAuftraege.ResID = ").append(resource).append(' ');
        } else if (availableResources != null) {
            if (availableResources.length == 1) {
                buf.append("AND tblAuftraege.ResID = ").append(availableResources[0]).append(' ');
            } else {
                buf.append("AND tblAuftraege.ResID IN (");
                for (int i = 0; i < availableResources.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(availableResources[i]);
                }
                buf.append(") ");
            }
        }
    }

    private void addLike(StringBuilder buf, String fieldName, String sqlText, int typ) {
        if (typ == 0) {
            buf.append(buf.length() > 0 ? " OR " : "OR ");
        } else if (typ == 1) {
            buf.append("AND ");
        } else if (typ == 2) {
            buf.append("AND (");
        }
        if (this.dbTyp == 3) {
            buf.append("LOWER(").append(fieldName).append(") Like LOWER('");
            this.addSqlString(buf, sqlText);
            buf.append("')");
        } else {
            buf.append(fieldName).append(" LIKE '");
            this.addSqlString(buf, sqlText);
            buf.append("'");
        }
        buf.append(" ESCAPE '|'");
        if (typ != 0) {
            buf.append(' ');
        }
    }

    private void addSqlString(StringBuilder buf, String str) {
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\'': {
                    buf.append("''");
                    continue block6;
                }
                case '*': {
                    buf.append('%');
                    continue block6;
                }
                case '?': {
                    buf.append('_');
                    continue block6;
                }
                case '|': {
                    buf.append("||");
                    continue block6;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
    }

    private String normalizeInput(String input) {
        StringBuffer testBuf = new StringBuffer();
        boolean syntaxZeichen = true;
        boolean missingSyntaxZeichen = false;
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch == '.') continue;
            if (!(testBuf.length() <= 0 || ch != ' ' && ch != ',' && ch != '-' || syntaxZeichen)) {
                if (ch == ' ') {
                    missingSyntaxZeichen = true;
                    continue;
                }
                syntaxZeichen = true;
                missingSyntaxZeichen = false;
                testBuf.append(ch);
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                if (missingSyntaxZeichen && !syntaxZeichen && testBuf.length() > 0) {
                    testBuf.append(',');
                }
                missingSyntaxZeichen = false;
                testBuf.append(ch);
                syntaxZeichen = false;
                continue;
            }
            missingSyntaxZeichen = true;
        }
        return testBuf.toString().trim();
    }

    private String getSimpleOrderSQL(String searchString, boolean orCase) {
        if (orCase) {
            return "OR tblAuftraege.AufID IN(" + searchString + ")";
        }
        return "AND tblAuftraege.AufID IN(" + searchString + ")";
    }

    private String getAufIDsql(String searchString, boolean orCase) {
        if ((searchString = this.normalizeInput(searchString)).length() == 0) {
            return searchString;
        }
        Object ret = null;
        try {
            if (searchString.indexOf(44) > -1 && searchString.indexOf(45) == -1) {
                return this.getSimpleOrderSQL(searchString, orCase);
            }
            if (searchString.indexOf(44) > -1 && searchString.indexOf(45) != -1) {
                Vector<String> bereiche = new Vector<String>();
                StringTokenizer st = new StringTokenizer(searchString, ",");
                String teil = "";
                while (st.hasMoreTokens()) {
                    teil = st.nextToken();
                    if (ret == null && teil.indexOf(45) == -1) {
                        ret = teil;
                        continue;
                    }
                    if (teil.indexOf(45) == -1) {
                        ret = (String)ret + "," + teil;
                        continue;
                    }
                    bereiche.addElement(teil);
                }
                ret = ret == null ? (orCase ? "OR (" : "AND (") : (orCase ? "OR (tblAuftraege.AufID IN(" + (String)ret + ") OR " : "AND (tblAuftraege.AufID IN(" + (String)ret + ") OR ");
                for (int i = 0; i < bereiche.size(); ++i) {
                    teil = (String)bereiche.elementAt(i);
                    ret = i == 0 ? (String)ret + "(tblAuftraege.AufID >= " + teil.substring(0, teil.indexOf(45)) + " AND tblAuftraege.AufID <= " + teil.substring(teil.indexOf(45) + 1) + ")" : (String)ret + " OR (tblAuftraege.AufID >= " + teil.substring(0, teil.indexOf(45)) + " AND tblAuftraege.AufID <= " + teil.substring(teil.indexOf(45) + 1) + ")";
                }
                ret = orCase ? (String)ret + "))" : (String)ret + ")";
            } else if (searchString.indexOf(45) > -1) {
                String leftExpression = searchString.substring(0, searchString.indexOf(45));
                String rightExpression = searchString.substring(searchString.indexOf(45) + 1);
                if (rightExpression.length() == 0) {
                    rightExpression = leftExpression;
                }
                if (leftExpression.length() > 0) {
                    ret = orCase ? "OR tblAuftraege.AufID >= " + leftExpression + " AND tblAuftraege.AufID <= " + rightExpression : "AND tblAuftraege.AufID >= " + leftExpression + " AND tblAuftraege.AufID <= " + rightExpression;
                }
            } else if (searchString.indexOf(32) > -1) {
                boolean gotNumber = false;
                StringBuffer buf = orCase ? new StringBuffer("OR tblAuftraege.AufID IN(") : new StringBuffer("AND tblAuftraege.AufID IN(");
                for (int i = 0; i < searchString.length(); ++i) {
                    int ch = searchString.charAt(i);
                    if (ch > 47 && ch < 58) {
                        gotNumber = true;
                    } else if (gotNumber) {
                        if (ch == 32) {
                            ch = 44;
                        }
                        gotNumber = false;
                    }
                    buf.append((char)ch);
                }
                buf.append(')');
                if (orCase) {
                    buf.append(')');
                }
                ret = buf.toString();
            } else {
                ret = orCase ? "OR tblAuftraege.AufID = " + searchString : "AND tblAuftraege.AufID = " + searchString;
            }
        }
        catch (Throwable e) {
            HDLogger.error(e);
            return "";
        }
        return ret;
    }
}

