/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.model.dataimport.ConnectionEntry;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import srv.automatic.GeraeteImporter;
import srv.automatic.UserImporter;

public class DataImportRunner {
    private ArrayList<DataImportJob> jobs = new ArrayList();

    public DataImportJob createJob(String uid) {
        long now = System.currentTimeMillis();
        Iterator<DataImportJob> iterator = this.jobs.iterator();
        while (iterator.hasNext()) {
            DataImportJob dataImportJob = iterator.next();
            if (dataImportJob.getEndTime() <= 0L || dataImportJob.getEndTime() + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS) >= now) continue;
            iterator.remove();
        }
        DataImportJob job = new DataImportJob();
        job.setUid(uid);
        this.jobs.add(job);
        return job;
    }

    public ArrayList<DataImportJob> getJobs(String uid) {
        ArrayList<DataImportJob> result = new ArrayList<DataImportJob>();
        for (DataImportJob job : this.jobs) {
            if (!job.getUid().equals(uid)) continue;
            result.add(job);
        }
        Collections.sort(result, new Comparator<DataImportJob>(){

            @Override
            public int compare(DataImportJob o1, DataImportJob o2) {
                long e1 = o1.getEndTime();
                long s1 = o1.getStartTime();
                long e2 = o2.getEndTime();
                long s2 = o2.getStartTime();
                if (e1 == e2) {
                    return (int)(s1 - s2);
                }
                if (e1 == 0L && e2 > 0L) {
                    return -1;
                }
                if (e2 == 0L && e1 > 0L) {
                    return 1;
                }
                return (int)(e2 - e1);
            }
        });
        return result;
    }

    public void executeJob(final DeviceImportConfigInfo deviceConfig, final String importName, ConnectionEntry connection) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block10: {
                    DataImportJob job = DataImportRunner.this.createJob(deviceConfig.getUid());
                    ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                    try (Connection connection = connectionFactory.getConnection();){
                        new GeraeteImporter().runNow(connection, deviceConfig, importName, job);
                    }
                    catch (Exception e) {
                        LogManager.getLogger((String)"Data Import").error((Object)e);
                        String message = StringFunctions.getUserFriendlyErrorMessage((Throwable)e);
                        if (message == null) {
                            message = "Server error!";
                        }
                        job.setError(message);
                        if (job.getStartTime() == 0L) {
                            job.setStartTime(System.currentTimeMillis());
                        }
                        if (job.getEndTime() != 0L) break block10;
                        job.setEndTime(System.currentTimeMillis());
                    }
                }
            }
        }, "DeviceImport - " + importName).start();
    }

    public void executeJob(final UserImportConfigInfo userImportConfigInfo, String importName, ConnectionEntry connection) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    DataImportJob job = DataImportRunner.this.createJob(userImportConfigInfo.getUid());
                    try {
                        new UserImporter().runNow(userImportConfigInfo, job);
                    }
                    catch (Exception e) {
                        LogManager.getLogger((String)"Data Import").error((Object)e);
                        String message = StringFunctions.getUserFriendlyErrorMessage((Throwable)e);
                        if (message == null) {
                            message = "Server error!";
                        }
                        job.setError(message);
                        if (job.getStartTime() == 0L) {
                            job.setStartTime(System.currentTimeMillis());
                        }
                        if (job.getEndTime() != 0L) break block4;
                        job.setEndTime(System.currentTimeMillis());
                    }
                }
            }
        }, "UserImport - " + importName).start();
    }
}

