/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetHeaders;

public class PartContent
implements Part {
    static final String CONTENT_TYPE = "Content-Type";
    static final String CONTENT_DISPOSITION = "Content-Disposition";
    static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    static final String FILE_NAME = "filename=";
    private String contentType;
    private String disposition;
    private String fileName;
    private String transferEncoding;
    private InternetHeaders headers = new InternetHeaders();
    private Object content;

    protected PartContent(String headerValues) throws Exception {
        int end;
        int start = 0;
        while ((end = headerValues.indexOf("\r\n", start)) > -1) {
            int propertyCut;
            String headerLine = headerValues.substring(start, end);
            if (headerLine.toLowerCase().startsWith("content-type") && headerLine.indexOf("multipart/") > -1 && headerValues.indexOf("boundary=", end) > -1) {
                end = headerValues.indexOf("\r\n", end + 2);
                headerLine = headerValues.substring(start, end);
            }
            if ((propertyCut = headerLine.indexOf(": ")) > -1) {
                this.setHeader(headerLine.substring(0, propertyCut), headerLine.substring(propertyCut + 2));
            }
            start = end + 2;
        }
    }

    public String getTransferEncoding() {
        return this.transferEncoding;
    }

    public void setTransferEncoding(String transferEncoding) {
        this.transferEncoding = transferEncoding;
    }

    public void setHeader(String name, String value) throws MessagingException {
        if (CONTENT_TYPE.equalsIgnoreCase(name)) {
            this.contentType = value;
        } else if (CONTENT_DISPOSITION.equalsIgnoreCase(name)) {
            String lower = value.toLowerCase();
            int filenameIndex = lower.indexOf(FILE_NAME);
            if (filenameIndex == -1 && lower.indexOf("filename") > -1) {
                int filenamePos = lower.indexOf("filename");
                String test = value.substring(filenamePos + "filename".length());
                char ch = test.charAt(0);
                if (ch > '\u007f') {
                    int first = ch / 16;
                    int second = ch % 16;
                    char[] signs = new char[]{(char)(first + (first < 10 ? 48 : 55)), (char)(second + (second < 10 ? 48 : 55))};
                    this.setFileName(new String(signs) + value.substring(filenamePos + FILE_NAME.length()));
                }
            } else if (filenameIndex > -1) {
                this.setFileName(value.substring(filenameIndex + FILE_NAME.length()));
            }
            if (lower.startsWith("attachment")) {
                this.setDisposition("attachment");
            } else if (lower.startsWith("inline")) {
                this.setDisposition("inline");
            } else {
                this.setDisposition(value);
            }
        } else if (CONTENT_TRANSFER_ENCODING.equalsIgnoreCase(name)) {
            this.setTransferEncoding(value);
        }
        this.headers.setHeader(name, value);
    }

    public String getContentType() throws MessagingException {
        return this.contentType;
    }

    public String getFileName() throws MessagingException {
        return this.fileName;
    }

    public void setFileName(String fileName) throws MessagingException {
        if (fileName.indexOf(34) > -1) {
            fileName = fileName.replace('\"', ' ').trim();
        }
        this.fileName = fileName;
    }

    public String getDisposition() throws MessagingException {
        return this.disposition;
    }

    public void setDisposition(String disposition) throws MessagingException {
        this.disposition = disposition;
    }

    public void addHeader(String header_name, String header_value) throws MessagingException {
        this.headers.addHeader(header_name, header_value);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Object getContent() throws IOException, MessagingException {
        return this.content;
    }

    public DataHandler getDataHandler() throws MessagingException {
        return null;
    }

    public String getDescription() throws MessagingException {
        return null;
    }

    public String[] getHeader(String header_name) throws MessagingException {
        return this.headers.getHeader(header_name);
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return null;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public Enumeration getMatchingHeaders(String[] header_names) throws MessagingException {
        return this.headers.getMatchingHeaders(header_names);
    }

    public Enumeration getNonMatchingHeaders(String[] header_names) throws MessagingException {
        return this.headers.getNonMatchingHeaders(header_names);
    }

    public int getSize() throws MessagingException {
        return 0;
    }

    public boolean isMimeType(String mimeType) throws MessagingException {
        return false;
    }

    public void removeHeader(String header_name) throws MessagingException {
        this.headers.removeHeader(header_name);
    }

    public void setContent(Multipart mp) throws MessagingException {
    }

    public void setContent(Object obj, String type) throws MessagingException {
        this.content = obj;
    }

    public void setDataHandler(DataHandler dh) throws MessagingException {
    }

    public void setDescription(String description) throws MessagingException {
    }

    public void setText(String text) throws MessagingException {
        this.content = text;
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
    }
}

