/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.utils.AttachedFile;
import com.inet.helpdesk.core.utils.PartContent;
import com.inet.helpdesk.core.utils.PartHandler;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Multipart;
import javax.mail.Part;

public class MailAttachmentUtilities {
    private static final String HEADER_END = "\r\n\r\n";
    private static final String BOUNDARY = "boundary=";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator", "//");

    public static boolean testAttachmentName(String theName, String patternString) {
        if (patternString == null || patternString.length() == 0) {
            return false;
        }
        int thePosition = patternString.indexOf(42);
        if (thePosition > -1) {
            if (thePosition == 0) {
                return theName.endsWith(patternString.substring(1));
            }
            if (thePosition == patternString.length() - 1) {
                return theName.startsWith(patternString.substring(0, patternString.length() - 1));
            }
            String prefix = patternString.substring(0, thePosition);
            String suffix = patternString.substring(thePosition + 1);
            return theName.startsWith(prefix) && theName.indexOf(suffix, prefix.length()) > -1 && theName.endsWith(suffix);
        }
        return patternString.equals(theName);
    }

    public static String getContentType(Part part) {
        try {
            String partContentType = part.getContentType();
            partContentType = partContentType != null ? partContentType.toLowerCase() : "";
            String[] contentType = part.getHeader("Content-Type");
            if (contentType != null && contentType.length > 0) {
                String typeFromHeader = contentType[0];
                if (partContentType.startsWith("text/plain") && typeFromHeader.startsWith("text/html")) {
                    partContentType = typeFromHeader.toLowerCase();
                } else if (partContentType.startsWith("text/plain") && typeFromHeader.startsWith("multipart/") && typeFromHeader.indexOf(BOUNDARY) > -1) {
                    partContentType = typeFromHeader;
                }
            }
            return partContentType;
        }
        catch (Exception ex) {
            HDLogger.error(ex);
            return "";
        }
    }

    public static void fetchParts(Part part, ArrayList<PartHandler> list, boolean alternativePart) throws Exception {
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            boolean isAlternativePart = part.isMimeType("multipart/alternative");
            for (int i = 0; i < mp.getCount(); ++i) {
                MailAttachmentUtilities.fetchParts((Part)mp.getBodyPart(i), list, isAlternativePart);
            }
        } else {
            String contentType = MailAttachmentUtilities.getContentType(part);
            if (contentType.startsWith("multipart/")) {
                MailAttachmentUtilities.fixWebDeProblem(part, list, contentType);
            } else {
                list.add(new PartHandler(part, alternativePart));
            }
        }
    }

    public static void fixWebDeProblem(Part messagePart, ArrayList<PartHandler> list, String cotentTypeString) throws Exception {
        String contentTyp = messagePart.getContentType();
        String string = contentTyp = contentTyp != null ? contentTyp.toLowerCase() : "";
        if (cotentTypeString.indexOf(BOUNDARY) == -1 || !contentTyp.startsWith("text/plain")) {
            throw new IllegalArgumentException("no boundarys");
        }
        String theMessage = messagePart.getContent().toString();
        MailAttachmentUtilities.splitMultipart(list, theMessage, cotentTypeString);
    }

    private static void splitMultipart(ArrayList<PartHandler> list, String theMessage, String cotentTypeString) throws Exception {
        String bundary = cotentTypeString.substring(cotentTypeString.indexOf(BOUNDARY) + BOUNDARY.length());
        int start = theMessage.indexOf(bundary);
        int end = theMessage.indexOf(bundary, start + bundary.length());
        while (end > -1) {
            int cutStart = start + bundary.length();
            while (theMessage.charAt(cutStart) < ' ') {
                ++cutStart;
            }
            int cutEnd = end - 1;
            while (theMessage.charAt(cutEnd) < ' ' || theMessage.charAt(cutEnd) == '-') {
                --cutEnd;
            }
            MailAttachmentUtilities.createPart(theMessage.substring(cutStart, cutEnd + 1), list);
            start = end;
            end = theMessage.indexOf(bundary, start + bundary.length());
        }
    }

    private static void createPart(String content, ArrayList<PartHandler> list) throws Exception {
        int endOfHeader = content.indexOf(HEADER_END);
        if (endOfHeader > -1) {
            String header = content.substring(0, endOfHeader + 2);
            String partContent = content.substring(endOfHeader + 4);
            PartContent newPart = new PartContent(header);
            if (newPart.getContentType().indexOf("multipart/") > -1) {
                MailAttachmentUtilities.splitMultipart(list, partContent, newPart.getContentType());
            } else {
                newPart.setContent(partContent, null);
                list.add(new PartHandler(newPart, false));
            }
        }
    }

    public static String extractCharset(String meta, int charsetIndex) {
        int end = (meta = meta.replace('\"', ' ')).indexOf(32, charsetIndex + 10);
        if (end > -1) {
            return meta.substring(charsetIndex + 8, end).trim();
        }
        return meta.substring(charsetIndex + 8).trim();
    }

    public static String getFileName(String name, String ext, List<AttachedFile> atts) {
        String nameTest = (name = MailAttachmentUtilities.normalisiertenFileName(name)) + ext;
        if (MailAttachmentUtilities.fileNameExists(nameTest, atts)) {
            for (int n = 1; n < 100 && MailAttachmentUtilities.fileNameExists(nameTest = name + "(" + n + ")" + ext, atts); ++n) {
            }
        }
        return nameTest;
    }

    private static boolean fileNameExists(String name, List<AttachedFile> anlagen) {
        for (int i = 0; i < anlagen.size(); ++i) {
            AttachedFile anl = anlagen.get(i);
            if (!anl.getFileName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String normalisiertenFileName(String name) {
        name = name.replace("%20", "_");
        name = name.replace("=20", "_");
        name = name.replace('?', '_');
        name = name.replace('*', '_');
        name = name.replace('/', '_');
        name = name.replace('\\', '_');
        name = name.replace(':', '_');
        name = name.replace('\"', '_');
        return name;
    }
}

