/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistence;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class DatabaseVersionChecker {
    private static ConfigValue<DatabaseStructureValue> DATABASE_STRUCTURE_VERSIONS = new ConfigValue<DatabaseStructureValue>(HDConfigKeys.DATABASESTRUCTURE){

        protected DatabaseStructureValue convert(String strValue) throws IllegalArgumentException {
            if (strValue == null || strValue.isEmpty()) {
                return new DatabaseStructureValue();
            }
            return (DatabaseStructureValue)new Json().fromJson(strValue, DatabaseStructureValue.class);
        }
    };

    public boolean isDatabaseStructureChanged(String structureKey, URL structureResource) {
        long currentCrc = this.getCRCFromResource(structureResource);
        long lastCrc = -1L;
        Long longObj = ((DatabaseStructureValue)DatabaseVersionChecker.DATABASE_STRUCTURE_VERSIONS.get()).settings.get(structureKey);
        lastCrc = longObj == null ? -1L : longObj;
        return lastCrc != currentCrc;
    }

    public void markDatabaseStructureChanged(String structureKey, URL structureResource) {
        long currentCrc = this.getCRCFromResource(structureResource);
        this.save(structureKey, currentCrc);
    }

    public void resetAllDatabaseStructureMarker() {
        ((DatabaseStructureValue)DatabaseVersionChecker.DATABASE_STRUCTURE_VERSIONS.get()).settings.clear();
        ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.DATABASESTRUCTURE.getKey(), new Json().toJson(DATABASE_STRUCTURE_VERSIONS.get()));
    }

    private void save(String structureKey, long currentCrc) {
        ((DatabaseStructureValue)DatabaseVersionChecker.DATABASE_STRUCTURE_VERSIONS.get()).settings.put(structureKey, currentCrc);
        ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.DATABASESTRUCTURE.getKey(), new Json().toJson(DATABASE_STRUCTURE_VERSIONS.get()));
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only by the software created files will be read to calculate a CRC32.")
    private long getCRCFromResource(URL structureResource) {
        CRC32 crc32 = new CRC32();
        try (InputStream in = structureResource.openStream();){
            byte[] bytes = IOFunctions.readBytes((InputStream)in);
            crc32.update(bytes);
        }
        catch (IOException e) {
            LogManager.getApplicationLogger().error((Object)e);
        }
        return crc32.getValue();
    }

    @JsonData
    public static class DatabaseStructureValue {
        Map<String, Long> settings = new HashMap<String, Long>();
    }

    @InternalApi
    public static class DVCMigrator
    implements ConfigurationMigrator {
        public void migrate(Configuration config) {
            for (String structureKey : new String[]{"knowledgebase", "push"}) {
                Path kb = ((FilePersistence)Persistence.getInstance()).getPersistenceFolder().resolve(String.format("AllUsers/databasestructure/%s.long", structureKey));
                if (!Files.isRegularFile(kb, new LinkOption[0])) continue;
                try {
                    Long crc = Long.valueOf(new String(Files.readAllBytes(kb), StandardCharsets.UTF_8));
                    new DatabaseVersionChecker().save(structureKey, crc);
                }
                catch (IOException | NumberFormatException e) {
                    LogManager.getApplicationLogger().error((Object)e);
                }
                try {
                    Files.delete(kb);
                }
                catch (IOException e) {
                    LogManager.getApplicationLogger().error((Object)e);
                }
            }
        }
    }
}

