/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview.subview;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.id.GUID;
import com.inet.search.index.IndexSearchEngine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public class TicketFieldSubViewGrouping
extends SimpleSubViewGrouping {
    private TicketField<?> field;

    public TicketFieldSubViewGrouping(@Nonnull TicketField<?> field) {
        super(field.getKey());
        this.field = field;
    }

    @Override
    public String getDisplayName() {
        return this.field.getSearchTag().getDisplayName();
    }

    @Override
    public List<TicketViewFactory> getSubViews(TicketViewFactory parent, GUID accountID, Locale locale) {
        ArrayList<TicketViewFactory> result = new ArrayList<TicketViewFactory>();
        switch (this.field.getSearchTag().getDataType()) {
            case IntegerMap: 
            case StringMap: {
                for (Map.Entry entry : this.field.getSearchTag().getMapData().entrySet()) {
                    result.add(new SubView<Comparable>(parent, this, (Comparable)entry.getKey(), (String)entry.getValue(), null, null));
                }
                result.sort((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getDisplayName(), b.getDisplayName()));
                break;
            }
            default: {
                IndexSearchEngine<Integer> engine = TicketManager.getReader().getSearchEngine();
                Iterator it = engine.createDisplayValuesIterator(this.field.getSearchTag(), (Comparable)((Object)""));
                while (it.hasNext()) {
                    String val = (String)it.next();
                    result.add(new SubView<String>(parent, this, val, val, null, null));
                }
                break block0;
            }
        }
        return result;
    }
}

