/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview.subview;

import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.id.GUID;
import com.inet.search.command.SearchCommand;
import com.inet.search.index.IndexSearchEngine;
import java.util.Locale;
import javax.annotation.Nonnull;

public class SubView<ID>
implements TicketViewFactory {
    private final TicketViewFactory parent;
    private final SubViewGroupingDefinition subViewGrouping;
    private final ID id;
    private final String displayName;
    private final String description;
    private final String iconKey;

    public SubView(@Nonnull TicketViewFactory parent, @Nonnull SubViewGroupingDefinition subViewGrouping, ID id, String displayName, String description, String iconKey) {
        this.parent = parent;
        this.subViewGrouping = subViewGrouping;
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.iconKey = iconKey;
    }

    @Override
    public String getID() {
        return this.parent.getID() + "." + this.getChildID();
    }

    public ID getChildID() {
        return this.id;
    }

    public Object getFilterID() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            return "";
        }
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIconKey() {
        return this.iconKey;
    }

    @Override
    public String getCategoryKey() {
        return this.parent.getCategoryKey();
    }

    @Override
    public SearchCommand createSearchCommand(@Nonnull GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
        SearchCommand command = this.parent.createSearchCommand(accountID, locale, engine);
        if (command != null) {
            this.subViewGrouping.patchSearchCommand(this.getFilterID(), command, accountID);
        }
        return command;
    }
}

