/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.timeline;

import java.util.Date;

public class PeriodOfTime {
    private Date begin;
    private Date end;

    public PeriodOfTime(Date begin, Date end) throws IllegalArgumentException {
        this.begin = begin;
        this.end = end;
        if (begin == null || end == null || end.before(begin)) {
            throw new IllegalArgumentException("Invalid period definition!");
        }
    }

    public Date getWithOffset(long offset, boolean start) {
        if (start) {
            return new Date(this.begin.getTime() + offset);
        }
        return new Date(this.end.getTime() + offset);
    }

    public int compare(PeriodOfTime anotherPeriod) {
        long otherLength;
        long otherStart;
        long thisStart = this.begin.getTime();
        if (thisStart > (otherStart = anotherPeriod.begin.getTime())) {
            return 1;
        }
        if (thisStart < otherStart) {
            return -1;
        }
        long thisLength = this.getPeriodLength();
        if (thisLength > (otherLength = anotherPeriod.getPeriodLength())) {
            return 1;
        }
        if (thisLength < otherLength) {
            return -1;
        }
        return 0;
    }

    public boolean isBeforePeriod(Date toTest) {
        return toTest.before(this.begin);
    }

    public boolean isAfterPeriod(Date toTest) {
        return toTest.after(this.end);
    }

    public boolean isInPeriod(Date toTest) {
        long start = this.begin.getTime();
        long theEnd = this.end.getTime();
        return start <= toTest.getTime() && theEnd > toTest.getTime();
    }

    public long gapToEnd(Date otherDate) {
        return this.end.getTime() - otherDate.getTime();
    }

    public long gapToStart(Date otherDate) {
        return otherDate.getTime() - this.begin.getTime();
    }

    public long getPeriodLength() {
        return this.end.getTime() - this.begin.getTime();
    }

    public String toString() {
        return this.begin + " - " + this.end;
    }
}

