/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.GuidTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@InternalApi
public class TicketFieldResourceGuid
extends TicketField<GUID> {
    public static final String KEY = "resourceid";

    public TicketFieldResourceGuid() {
        super(TicketFieldResourceGuid.createSearchTag(), null);
    }

    private static SearchTag createSearchTag() {
        return new SearchTag(KEY, SearchDataType.StringMap, true, (SearchTokenizer)GuidTokenizer.INSTANCE, 100, KEY, true){

            public String getDisplayName() {
                return Tickets.getFieldDisplayName(TicketFieldResourceGuid.KEY);
            }

            public Map<String, String> getMapData() {
                return UserGroupManager.getInstance().getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE).stream().collect(Collectors.toMap(ugi -> ugi.getID().toString(), UserGroupInfo::getDisplayName));
            }
        };
    }

    public GUID copyValue(GUID value) {
        return value;
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    @Override
    public String valueToString(GUID resId) {
        UserGroupManager groupManager = UserGroupManager.getInstance();
        UserGroupInfo ressourceGroup = groupManager.getGroup(resId);
        if (ressourceGroup != null) {
            UserGroupInfo parent;
            Object displayName = ressourceGroup.getDisplayName();
            GUID parentID = ressourceGroup.getParentID();
            while (parentID != null && (parent = groupManager.getGroup(parentID)) != null) {
                displayName = parent.getDisplayName() + " \\ " + (String)displayName;
                parentID = parent.getParentID();
            }
            return displayName;
        }
        return Tickets.MSG.getMsg("value.deleted", new Object[0]);
    }

    @Override
    public OperationNewReaStep createStringFieldChangeReaStep(GUID oldFieldValue, GUID newFieldValue, OperationChangedTicket ticket) {
        if (ticket.getOldTicket().get().isInquiry()) {
            OperationNewReaStep authorizationStep = this.findAuthorizationStep(ticket);
            if (authorizationStep != null) {
                authorizationStep.getFields().put(ReaStepVO.FIELD_DESC, this.constructReaStepDescriptionForFieldChange(oldFieldValue, newFieldValue));
                return null;
            }
            return super.createStringFieldChangeReaStep(oldFieldValue, newFieldValue, ticket);
        }
        return null;
    }

    @Nullable
    private OperationNewReaStep findAuthorizationStep(OperationChangedTicket ticket) {
        for (OperationNewReaStep step : ticket.getAddedReaSteps()) {
            if (step.getAttributes().get(ReaStepVO.ATTRIBUTE_ACTION_ID) != 5) continue;
            return step;
        }
        return null;
    }

    @Override
    protected int getFieldChangeReaStepActionId() {
        return -29;
    }

    @Override
    public String getFieldDisplayName(Locale locale) {
        return Tickets.getFieldDisplayName(this.getKey(), locale);
    }
}

