/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.id.GUID;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.Map;

public class TicketFieldCategoryId
extends TicketField<Integer> {
    public static final String KEY = "categoryid";

    public TicketFieldCategoryId() {
        super(TicketFieldCategoryId.createSearchTag(), null);
    }

    private static SearchTag createSearchTag() {
        return new SearchTag(KEY, SearchDataType.IntegerMap, false, 100, KEY, true){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(Tickets.FIELD_CATEGORY_ID);
            }

            public Map<Integer, String> getMapData() {
                return CategoryManager.getInstance().getAllPathNames(false);
            }
        };
    }

    public Integer getValidOrDefaultValue(Integer value, GUID entryID) {
        if (value != null && value == 0) {
            value = null;
        }
        return (Integer)super.getValidOrDefaultValue((Object)value, entryID);
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        if (value != null) {
            BasicFieldValidation.throwIfZero((int)value);
            BasicFieldValidation.throwIfNegative((int)value);
        }
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    @Override
    public String valueToString(Integer fieldValue) {
        CategoryVO oldCategoryVO = (CategoryVO)CategoryManager.getInstance().get(fieldValue);
        if (oldCategoryVO != null) {
            return oldCategoryVO.getDisplayValue();
        }
        return null;
    }

    @Override
    protected int getFieldChangeReaStepActionId() {
        return -26;
    }
}

