/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class StorageLocationInfo<VALUE> {
    private final DbTable table;
    private final String columnName;

    public StorageLocationInfo(DbTable table, String columnName) {
        if (table == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        if (columnName == null) {
            throw new IllegalArgumentException("columnName must not be null");
        }
        if ((columnName = columnName.trim()).isEmpty()) {
            throw new IllegalArgumentException("columnName must not be empty after trim");
        }
        this.table = table;
        this.columnName = columnName;
    }

    public DbTable getTable() {
        return this.table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object convertToValueToStore(VALUE fieldValue) {
        return fieldValue;
    }

    public Object convertStoredValueToDesiredType(Object storedValue, Class<VALUE> desiredValueType) {
        if (storedValue == null) {
            return null;
        }
        if (storedValue instanceof Long && Integer.class.equals(desiredValueType)) {
            return ((Long)storedValue).intValue();
        }
        if (storedValue instanceof Timestamp && Long.class.equals(desiredValueType)) {
            return ((Timestamp)storedValue).getTime();
        }
        if (storedValue instanceof LocalDateTime && Long.class.equals(desiredValueType)) {
            LocalDateTime time = (LocalDateTime)storedValue;
            return ZonedDateTime.of(time, ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        return storedValue;
    }

    public static enum DbTable {
        TBLBUENDEL;

    }
}

