/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.priority;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.Deletable;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import java.util.Objects;

@JsonData
public class PriorityVO
extends FieldVO
implements Deletable {
    private String PriBezeichnung;
    private double EskaZeit;
    private double DeadLine;
    private String PriImage;
    private boolean geloescht;

    private PriorityVO() {
    }

    public PriorityVO(int id, String name, double escalationTimeout, double deadline, String imageName) {
        super(id);
        this.PriBezeichnung = name;
        this.geloescht = false;
        this.EskaZeit = escalationTimeout;
        this.DeadLine = deadline;
        this.PriImage = imageName;
    }

    public PriorityVO(int id, String name, double escalationTimeout, double deadline, String imageName, boolean geloescht) {
        super(id);
        this.PriBezeichnung = name;
        this.EskaZeit = escalationTimeout;
        this.DeadLine = deadline;
        this.PriImage = imageName;
        this.geloescht = geloescht;
    }

    public PriorityVO(int id, String name) {
        this(id, name, 0.0, 0.0, null);
    }

    @Override
    public String getDisplayValue() {
        return this.PriBezeichnung;
    }

    public double getEscalationTimeout() {
        return this.EskaZeit;
    }

    public double getDeadline() {
        return this.DeadLine;
    }

    public String getImageName() {
        return this.PriImage;
    }

    public void setImageName(String PriImage) {
        this.PriImage = PriImage;
    }

    @Override
    public boolean isDeleted() {
        return this.geloescht;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PriorityVO)) {
            return false;
        }
        PriorityVO other = (PriorityVO)obj;
        return this.getId() == other.getId() && this.EskaZeit == other.EskaZeit && this.DeadLine == other.DeadLine && this.geloescht == other.geloescht && Objects.equals(this.PriBezeichnung, other.PriBezeichnung) && Objects.equals(this.PriImage, other.PriImage);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.DeadLine);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.EskaZeit);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.PriBezeichnung == null ? 0 : this.PriBezeichnung.hashCode());
        result = 31 * result + (this.PriImage == null ? 0 : this.PriImage.hashCode());
        result = 31 * result + (this.geloescht ? 1231 : 1237);
        return result;
    }
}

