/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOption;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOptions;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.UserGroupTreeUtils;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TicketFieldDefinitionResourceId
extends AbstractTicketFieldDefinitionWithField<GUID> {
    public TicketFieldDefinitionResourceId() {
        super(Tickets.FIELD_RESOURCE_GUID, true, true);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/resources_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/resources_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/resources_16@3x.png");
    }

    @Override
    public SelectEditDefinition getEditDefinition() {
        return new SelectEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                if (!HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
                    return false;
                }
                if (tickets != null && !tickets.isEmpty()) {
                    for (TicketVO ticket : tickets) {
                        if (ticket.isInquiry()) continue;
                        return false;
                    }
                    return HDUsersAndGroups.isDispatcher(UserManager.getInstance().getCurrentUserAccount());
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                    String valueString = selectOption.getValue();
                    if (!StringFunctions.isEmpty((String)valueString)) {
                        GUID resourceId = GUID.valueOf((String)valueString);
                        if (resourceId != null) {
                            ticketData.put(Tickets.FIELD_RESOURCE_GUID, resourceId);
                        }
                    } else {
                        ticketData.put(Tickets.FIELD_RESOURCE_GUID, null);
                    }
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                UserGroupInfo groupInfo;
                GUID resourceId = null;
                if (ticket != null) {
                    resourceId = ticket.getResourceID();
                }
                SelectOption option = new SelectOption(null, "", "");
                if (resourceId != null && (groupInfo = UserGroupManager.getInstance().getGroup(resourceId)) != null) {
                    option = new SelectOption(resourceId.toString(), groupInfo.getDisplayName(), HDUsersAndGroups.getResourceIconKey(groupInfo));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionResourceId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionResourceId.this.getDisplayName();
            }

            @Override
            public SelectOptions getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                boolean noneAuthorized = true;
                if (tickets != null && !tickets.isEmpty()) {
                    for (TicketVO ticket : tickets) {
                        if (!ticket.isDispatched()) continue;
                        noneAuthorized = false;
                        break;
                    }
                }
                if (noneAuthorized) {
                    list.add(new SelectOption(null, "", ""));
                }
                SearchID searchID = new SearchID((Object)("recource_getSelectOptions_" + searchTerm));
                ArrayList boostingExpressions = new ArrayList();
                ArrayList<SearchCondition> additionalExpressions = new ArrayList<SearchCondition>();
                UserGroupManager manager = UserGroupManager.getInstance();
                additionalExpressions.add(new SearchCondition("grouptype", SearchCondition.SearchTermOperator.Equals, (Object)HDUsersAndGroups.RESOURCE.getName()));
                SearchResult searchResult = manager.search(manager.getSearchEngine().getTag("groupname").getDisplayName() + ":" + searchTerm, additionalExpressions, boostingExpressions, 500, searchID);
                if (searchResult.isPartialResult() && searchResult.getEntries().isEmpty()) {
                    return new SelectOptions(list, 0);
                }
                HashSet knownIds = new HashSet();
                ArrayList result = new ArrayList();
                Consumer<List> fillFinalResultWithEntries = entries -> {
                    for (SearchResultEntry e : entries) {
                        if (knownIds.contains(e.getId())) continue;
                        knownIds.add((GUID)e.getId());
                        result.add(e);
                    }
                };
                fillFinalResultWithEntries.accept(searchResult.getEntries());
                HashSet<UserGroupInfo> foundGroups = new HashSet<UserGroupInfo>();
                for (SearchResultEntry entry : searchResult.getEntries()) {
                    UserGroupInfo group = manager.getGroup((GUID)entry.getId());
                    if (group == null || !group.isActive()) continue;
                    foundGroups.add(group);
                }
                Function<Set, Set> getParentGroups = groups -> {
                    HashSet<UserGroupInfo> parentGroups = new HashSet<UserGroupInfo>();
                    for (UserGroupInfo group : groups) {
                        UserGroupInfo parent;
                        GUID parentID = group.getParentID();
                        if (parentID == null || (parent = manager.getGroup(parentID)) == null || !parent.isActive()) continue;
                        parentGroups.add(parent);
                    }
                    return parentGroups;
                };
                HashSet<GUID> allAncestorIDs = new HashSet<GUID>();
                Set parentGroups = getParentGroups.apply(foundGroups);
                while (!parentGroups.isEmpty()) {
                    for (UserGroupInfo parent : parentGroups) {
                        allAncestorIDs.add(parent.getID());
                    }
                    parentGroups = getParentGroups.apply(parentGroups);
                }
                HashSet<GUID> allDescendantIDs = new HashSet<GUID>();
                Set allDescendantGroups = UserGroupTreeUtils.findDescendantGroups(foundGroups, (Set)manager.getAllGroups(), (boolean)false);
                for (UserGroupTreeUtils.DescendantGroups entry : allDescendantGroups) {
                    for (UserGroupInfo group : entry.getDescendantGroups()) {
                        allDescendantIDs.add(group.getID());
                    }
                }
                HashSet<GUID> allAncestorAndDescendantIDs = new HashSet<GUID>();
                allAncestorAndDescendantIDs.addAll(allAncestorIDs);
                allAncestorAndDescendantIDs.addAll(allDescendantIDs);
                if (!allAncestorAndDescendantIDs.isEmpty()) {
                    int maxResults = allAncestorAndDescendantIDs.size();
                    ArrayList searchConditions = new ArrayList();
                    OrSearchExpression orSearchExpression = new OrSearchExpression();
                    allAncestorAndDescendantIDs.forEach(groupID -> orSearchExpression.add((Object)new SearchCondition("groupname", SearchCondition.SearchTermOperator.Equals, (Object)groupID.toString())));
                    searchConditions.add(orSearchExpression);
                    List searchResultEntries = manager.search("", (List)searchConditions, Collections.emptyList(), maxResults, searchID).getEntries();
                    fillFinalResultWithEntries.accept(searchResultEntries);
                }
                HashMap<SearchResultEntry, String> pathes = new HashMap<SearchResultEntry, String>();
                for (SearchResultEntry entry : result) {
                    String path = this.getPath((GUID)entry.getId(), "");
                    pathes.put(entry, path);
                }
                List sortedResult = pathes.entrySet().stream().sorted(Map.Entry.comparingByValue(String.CASE_INSENSITIVE_ORDER)).map(Map.Entry::getKey).collect(Collectors.toList());
                int start = currentSize;
                int end = start + chunkSize;
                end = Math.min(end, sortedResult.size());
                List subList = sortedResult.subList(start, end);
                for (SearchResultEntry searchExpression : subList) {
                    UserGroupInfo resourceGroup = manager.getGroup((GUID)searchExpression.getId());
                    int level = this.getLevel(resourceGroup);
                    list.add(new SelectOption(resourceGroup.getID().toString(), resourceGroup.getDisplayName(), HDUsersAndGroups.getResourceIconKey(resourceGroup), level));
                }
                return new SelectOptions(list, sortedResult.size());
            }

            private int getLevel(UserGroupInfo resourceGroup) {
                int level = 0;
                GUID parentId = resourceGroup.getParentID();
                while (parentId != null) {
                    ++level;
                    UserGroupInfo parent = UserGroupManager.getInstance().getGroup(parentId);
                    if (parent != null) {
                        parentId = parent.getParentID();
                        continue;
                    }
                    parentId = null;
                }
                return level;
            }

            private String getPath(GUID id, String parentPath) {
                parentPath = this.getName(id) + "/" + (String)parentPath;
                GUID parentId = this.getParentId(id);
                if (id.equals((Object)parentId)) {
                    return parentPath;
                }
                if (parentId != null) {
                    parentPath = this.getPath(parentId, (String)parentPath);
                }
                return parentPath;
            }

            private String getName(GUID id) {
                UserGroupInfo group = UserGroupManager.getInstance().getGroup(id);
                return group == null || !group.isActive() ? null : group.getName();
            }

            private GUID getParentId(GUID id) {
                UserGroupInfo group = UserGroupManager.getInstance().getGroup(id);
                if (group != null && group.isActive()) {
                    return group.getParentID();
                }
                return null;
            }
        };
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        GUID resId = ticket.getResourceID();
        if (resId == null) {
            return null;
        }
        return this.getRessourceState(resId);
    }

    private String getRessourceState(GUID resId) {
        UserGroupInfo ressourceGroup = UserGroupManager.getInstance().getGroup(resId);
        return HDUsersAndGroups.getResourceIconKey(ressourceGroup);
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        if ("deleted".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/delete_16.gif");
        }
        if ("write".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/resources_16.gif");
        }
        if ("read".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/resources_read_16.gif");
        }
        if ("blocked".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/resource_forign_16.gif");
        }
        return null;
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation(Tickets.FIELD_RESOURCE_GUID.getKey(), sortGroupKey -> {
            if (StringFunctions.isEmpty((String)sortGroupKey)) {
                return new SortGroup(Tickets.MSG.getMsg("value.unset", new Object[0]), false, null);
            }
            GUID resID = GUID.valueOf((String)sortGroupKey);
            UserGroupManager groupManager = UserGroupManager.getInstance();
            UserGroupInfo ressourceGroup = groupManager.getGroup(resID);
            Object displayName = "";
            if (ressourceGroup != null) {
                UserGroupInfo parent;
                displayName = ressourceGroup.getDisplayName();
                GUID parentID = ressourceGroup.getParentID();
                while (parentID != null && (parent = groupManager.getGroup(parentID)) != null) {
                    displayName = parent.getDisplayName() + " \\ " + (String)displayName;
                    parentID = parent.getParentID();
                }
            } else {
                displayName = Tickets.MSG.getMsg("value.deleted", new Object[0]);
            }
            String iconKey = this.getRessourceState(resID);
            return new SortGroup((String)displayName, true, iconKey);
        });
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator nullsFirst = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }
}

