/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithGenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldClassificationId;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOption;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOptions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionClassificationId
extends AbstractTicketFieldDefinitionWithGenericFieldsManager {
    public TicketFieldDefinitionClassificationId() {
        super(Tickets.FIELD_CLASSIFICATION_ID, ClassificationManager.getInstance());
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_classification_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_classification_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_classification_16@3x.png");
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new SelectEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                if (!HDUsersAndGroups.isSupporter(currentUserAccount)) {
                    MandatoryFieldsManager mandatoryFieldsManager = (MandatoryFieldsManager)ServerPluginManager.getInstance().getSingleInstance(MandatoryFieldsManager.class);
                    List<MandatoryFieldVO> mandatoryFieldSettings = mandatoryFieldsManager.getMandatoryFieldSettings();
                    MandatoryFieldVO mandatoryField = mandatoryFieldSettings.stream().filter(f -> ((Object)((Object)f.getTicketField())).equals((Object)Tickets.FIELD_CLASSIFICATION_ID)).findFirst().orElse(null);
                    return mandatoryField != null && mandatoryField.getUserMandatorySetting() != MandatoryFieldVO.MandatoryType.HIDDEN;
                }
                if (tickets != null) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(-28);
                    for (TicketVO ticket : tickets) {
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                Integer classificationId;
                SelectOption selectOption;
                String valueString;
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value) && !StringFunctions.isEmpty((String)(valueString = (selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class)).getValue())) && (classificationId = Integer.valueOf(valueString)) != null) {
                    ticketData.put(Tickets.FIELD_CLASSIFICATION_ID, classificationId);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                int classificationId = 0;
                classificationId = ticket != null ? ticket.getClassificationID() : TicketFieldClassificationId.DEFAULT_ID.intValue();
                SelectOption option = new SelectOption(null, "");
                ClassificationVO classificationVO = (ClassificationVO)ClassificationManager.getInstance().get(classificationId);
                if (classificationVO != null) {
                    option = new SelectOption(String.valueOf(classificationId), classificationVO.getDisplayValue(), String.valueOf(classificationVO.getId()));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionClassificationId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionClassificationId.this.getDisplayName();
            }

            @Override
            public SelectOptions getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                Comparator<ClassificationVO> comparator = new Comparator<ClassificationVO>(){

                    @Override
                    public int compare(ClassificationVO o1, ClassificationVO o2) {
                        return o1.getDisplayValue().compareToIgnoreCase(o2.getDisplayValue());
                    }
                };
                List calssifications = ClassificationManager.getInstance().getAll(true);
                calssifications.sort(comparator);
                for (ClassificationVO classificationVO : calssifications) {
                    String classificationDisplayValue = classificationVO.getDisplayValue();
                    if (classificationDisplayValue == null) {
                        classificationDisplayValue = "";
                    }
                    if (!classificationDisplayValue.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                    list.add(new SelectOption(String.valueOf(classificationVO.getId()), classificationDisplayValue, String.valueOf(classificationVO.getId())));
                }
                if (list.size() < currentSize) {
                    return new SelectOptions(new ArrayList<SelectOption>(), 0);
                }
                List<SelectOption> subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptions(subList, list.size());
            }
        };
    }
}

