/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByFirstLetterSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.image.UserAvatar;
import com.inet.usersandgroups.api.Field;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.Comparator;

@InternalApi
public abstract class AbstractTicketFieldDefinitionWithUser
extends TicketFieldDefinition {
    private Field<?> fieldInstance;

    public AbstractTicketFieldDefinitionWithUser(TicketAttribute<?> fieldInstance) {
        super(fieldInstance, true, true);
        this.fieldInstance = fieldInstance;
    }

    public AbstractTicketFieldDefinitionWithUser(TicketField<?> fieldInstance) {
        super(fieldInstance, true, true);
        this.fieldInstance = fieldInstance;
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        byte[] bytes;
        if (iconSize == null) {
            iconSize = 128;
        }
        if ((bytes = UserAvatar.getCircleAvatar((GUID)null, (int)iconSize)) != null) {
            try {
                return new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(bytes));
            }
            catch (MalformedURLException e) {
                HDLogger.warn(e);
            }
        }
        return null;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        Object value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        UserAccount userAccount = UserManager.getInstance().getUserAccount((GUID)value);
        if (userAccount == null) {
            return null;
        }
        return userAccount.getDisplayName();
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        Object value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        GUID guid = GUID.valueOf((String)valueAsString);
        byte[] bytes = UserAvatar.getCircleAvatar((GUID)guid, (int)(size * 8));
        if (bytes != null) {
            try {
                return new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(bytes));
            }
            catch (MalformedURLException e) {
                HDLogger.warn(e);
            }
        }
        return null;
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByFirstLetterSortGroupInformation(this);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator nullsFirst = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }
}

