/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.servlets.rpc;

import com.inet.helpdesk.core.servlets.rpc.PacketHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractPacketHandler<InputType, OutputType>
implements PacketHandler {
    private Class<InputType> inputType;

    public AbstractPacketHandler() {
        this.determineInputType(this.getClass());
        if (this.inputType == null) {
            throw new IllegalArgumentException(this.getClass() + " is not a ParameterizedType");
        }
    }

    private void determineInputType(Class<?> clazz) {
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            this.inputType = (Class)types[0];
        } else {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                this.determineInputType(superclass);
            }
        }
    }

    protected Class<InputType> getInputType() {
        return this.inputType;
    }

    protected abstract OutputType handle(HttpServletRequest var1, InputType var2);

    @Override
    public void handle(HttpServletRequest request, Reader jsonData, Writer output) throws IOException {
        Class<InputType> type = this.getInputType();
        Object input = type != Void.class ? JSON.fromJson(jsonData, type) : null;
        OutputType result = this.handle(request, input);
        JSON.toJson(result, (Appendable)output);
    }

    @Override
    public boolean encryptionRequired() {
        return true;
    }
}

