/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.permissions;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.List;

public class HdPermissionsMapper {
    private static List<PartialMapper> partialMappers;
    private PermissionCheckerWrapper permissionCheckerWrapper;

    public HdPermissionsMapper(final UserAccount account) {
        PermissionCheckerWrapper permissionCheckerWrapper;
        partialMappers = new ArrayList<PartialMapper>(){
            {
                this.add(HdPermissionsMapper.simpleMapper(Permission.CONFIGURATION, 0x200000));
                this.add(HdPermissionsMapper.simpleMapper(HdPermissions.OPTIONS, 1));
                this.add(HdPermissionsMapper.simpleMapper(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER, 8));
                this.add(HdPermissionsMapper.simpleMapper(HdPermissions.REPORTS, 16));
                this.add(HdPermissionsMapper.simpleMapper(HdPermissions.ITIL_DEFINITION, 2048));
                this.add(HdPermissionsMapper.simpleMapper(HdPermissions.FREE_LINKING, 32768));
                this.add(HdPermissionsMapper.simpleMapper(HdPermissions.TEMPLATE_DEFINITION, 262144));
                this.add(permissionCheckerWrapper1 -> {
                    boolean hasRead = permissionCheckerWrapper1.checkAccess(HdPermissions.INVENTORY_READ);
                    boolean hasReadAndWrite = permissionCheckerWrapper1.checkAccess(HdPermissions.INVENTORY_READ_WRITE);
                    if (hasReadAndWrite && hasRead) {
                        return 4;
                    }
                    if (hasRead) {
                        return 260;
                    }
                    return 0;
                });
                this.add(permissionCheckerWrapper1 -> {
                    boolean isDispatcher = permissionCheckerWrapper1.checkAccess(HdPermissions.DISPATCHER);
                    boolean isResourcesRead = permissionCheckerWrapper1.checkAccess(HdPermissions.TICKET_RESOURCES_READ);
                    boolean isResourcesReadAndWrite = permissionCheckerWrapper1.checkAccess(HdPermissions.TICKET_RESOURCES_READ_WRITE);
                    if (isResourcesReadAndWrite && isResourcesRead) {
                        return 0x180000;
                    }
                    if (isResourcesRead) {
                        return 524800;
                    }
                    if (isDispatcher) {
                        return 1024;
                    }
                    return 0;
                });
                this.add(permissionCheckerWrapper1 -> {
                    boolean hasBase = permissionCheckerWrapper1.checkAccess(Permission.valueOfExistingOrCreate((String)"knowledgeBase"));
                    boolean hasBaseAllCustomers = permissionCheckerWrapper1.checkAccess(Permission.valueOfExistingOrCreate((String)"knowledgeBaseAllCustomers"));
                    boolean hasBaseExperts = permissionCheckerWrapper1.checkAccess(Permission.valueOfExistingOrCreate((String)"knowledgeBaseExperts"));
                    boolean hasBaseEditDelete = permissionCheckerWrapper1.checkAccess(Permission.valueOfExistingOrCreate((String)"knowledgeBaseEditDelete"));
                    if (hasBaseExperts && hasBaseAllCustomers && hasBase) {
                        int value = 131106;
                        if (hasBaseEditDelete) {
                            value += 64;
                        }
                        return value;
                    }
                    if (hasBaseAllCustomers && hasBase) {
                        int value = 131074;
                        if (hasBaseEditDelete) {
                            value += 64;
                        }
                        return value;
                    }
                    if (hasBase) {
                        int value = 2;
                        if (hasBaseEditDelete) {
                            value += 64;
                        }
                        return value;
                    }
                    return 0;
                });
                this.add(permissionCheckerWrapper1 -> {
                    boolean hasManagement = permissionCheckerWrapper1.checkAccess(HdPermissions.ITIL_MANAGEMENT);
                    boolean hasProtected = permissionCheckerWrapper1.checkAccess(HdPermissions.ITIL_PROTECTED);
                    if (hasProtected && hasManagement) {
                        return 20480;
                    }
                    if (hasManagement) {
                        return 16384;
                    }
                    return 0;
                });
            }
        };
        if (account == null) {
            throw new IllegalArgumentException("web user info must not be null");
        }
        this.permissionCheckerWrapper = permissionCheckerWrapper = new PermissionCheckerWrapper(){

            @Override
            public boolean checkAccess(Permission permission) {
                return SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{permission});
            }
        };
    }

    HdPermissionsMapper(PermissionCheckerWrapper permissionCheckerWrapper) {
        partialMappers = new /* invalid duplicate definition of identical inner class */;
        if (permissionCheckerWrapper == null) {
            throw new IllegalArgumentException("permission checker wrapper must not be null");
        }
        this.permissionCheckerWrapper = permissionCheckerWrapper;
    }

    private static PartialMapper simpleMapper(Permission permission, int permissionValue) {
        return permissionCheckerWrapper1 -> {
            if (permissionCheckerWrapper1.checkAccess(permission)) {
                return permissionValue;
            }
            return 0;
        };
    }

    public int userPermissions() {
        int userPermissionsAsValue = 0;
        for (PartialMapper mapper : partialMappers) {
            userPermissionsAsValue += mapper.map(this.permissionCheckerWrapper);
        }
        return userPermissionsAsValue;
    }

    public boolean isDispatcher() {
        return this.permissionCheckerWrapper.checkAccess(HdPermissions.DISPATCHER);
    }

    private static interface PartialMapper {
        public int map(PermissionCheckerWrapper var1);
    }

    public static interface PermissionCheckerWrapper {
        public boolean checkAccess(Permission var1);
    }
}

