/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext.handler;

import com.inet.helpdesk.config.autotext.data.AutoTextEntry;
import com.inet.helpdesk.config.autotext.data.AvailableAutoTextsRequest;
import com.inet.helpdesk.config.autotext.data.AvailableAutoTextsResponse;
import com.inet.helpdesk.config.autotext.handler.AutoTextAttachmentHelper;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoadAvailableAutoTexts
extends ServiceMethod<AvailableAutoTextsRequest, AvailableAutoTextsResponse> {
    public String getMethodName() {
        return "autotext.loadavailableautotexts";
    }

    public short getMethodType() {
        return 1;
    }

    public AvailableAutoTextsResponse invoke(HttpServletRequest req, HttpServletResponse resp, AvailableAutoTextsRequest payload) throws IOException {
        List<AutoTextVO> allAutoTexts;
        ArrayList<AutoTextEntry> entries = new ArrayList<AutoTextEntry>();
        AutoTextManager man = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
        List<String> groups = man.getAutoTextGroups();
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (!HDUsersAndGroups.isSupporter(currentUserAccount) && !SystemPermissionChecker.checkAccess((Permission)HdPermissions.TEMPLATE_DEFINITION)) {
            return new AvailableAutoTextsResponse(entries, groups);
        }
        Integer currentUserId = HDUsersAndGroups.getUserID(currentUserAccount.getID());
        Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(currentUserAccount.getID());
        boolean isAdminGroup = groupsForUser.contains(UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ADMIN));
        boolean userIsAdmin = currentUserAccount.getAccountType().equals((Object)UserAccountType.Administrator);
        boolean userHasPermission = SystemPermissionChecker.hasAnyPermission((GUID)currentUserAccount.getID(), (Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION});
        switch (payload.getFilter()) {
            case "admin": {
                if (userIsAdmin || isAdminGroup) {
                    allAutoTexts = man.getAllAutoTextsForAdministrator(currentUserAccount.getID());
                    break;
                }
            }
            case "visible": {
                allAutoTexts = man.getAllAutoTextsForUser(currentUserAccount.getID(), true);
                break;
            }
            default: {
                allAutoTexts = man.getAllAutoTextsForUser(currentUserAccount.getID(), false);
            }
        }
        HashSet<String> usergroups = new HashSet<String>();
        for (AutoTextVO autoTextVO : allAutoTexts) {
            UserAccount userAccount;
            Object convertToPlainText;
            Boolean hasAttachments = Boolean.FALSE;
            if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                hasAttachments = !AutoTextAttachmentHelper.getAutoTextAttachments(autoTextVO.getId()).isEmpty();
            }
            if (((String)(convertToPlainText = TicketFunctions.convertToPlainText((String)autoTextVO.getContentText()))).length() > 500) {
                convertToPlainText = ((String)convertToPlainText).substring(0, 497) + "...";
            }
            GUID userGUID = null;
            if (autoTextVO.getUserId() != null && (userAccount = HDUsersAndGroups.getUserAccount(autoTextVO.getUserId())) != null) {
                userGUID = userAccount.getID();
            }
            AutoTextEntry e = new AutoTextEntry(autoTextVO.getId(), autoTextVO.getLabel(), autoTextVO.getUserId(), userGUID, autoTextVO.getShortcut(), autoTextVO.getTyp(), autoTextVO.getGroupLabel(), hasAttachments, (String)convertToPlainText, autoTextVO.isEmailSignature(), autoTextVO.getMemberships() == null, userIsAdmin || isAdminGroup || userHasPermission || Objects.equals(currentUserId, autoTextVO.getUserId()));
            entries.add(e);
            usergroups.add(autoTextVO.getGroupLabel());
        }
        groups.retainAll(usergroups);
        Collections.sort(entries, (a, b) -> a.getLabel().compareToIgnoreCase(b.getLabel()));
        Collections.sort(groups, (a, b) -> {
            if (StringFunctions.isEmpty((String)a)) {
                if (!StringFunctions.isEmpty((String)b)) {
                    return 1;
                }
            } else if (StringFunctions.isEmpty((String)b)) {
                return -1;
            }
            return a.compareToIgnoreCase((String)b);
        });
        AvailableAutoTextsResponse availableAutoTextsResponse = new AvailableAutoTextsResponse(entries, groups);
        availableAutoTextsResponse.setUserHasPermission(userHasPermission);
        availableAutoTextsResponse.setUserIsAdmin(userIsAdmin || isAdminGroup);
        return availableAutoTextsResponse;
    }
}

