/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.config.autotext.data.TargetChild;
import com.inet.helpdesk.config.autotext.data.TargetParent;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.ui.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonData
public class TargetEntry {
    private GUID guid;
    private String membershipType = "";
    private String membershipGroupKey;
    private Type entryType;
    private String entryTypeKey;
    private String displayName;
    private ArrayList<TargetParent> parents = null;
    private ArrayList<TargetChild> children = null;
    private boolean dummy = false;
    private boolean preventEditing = false;
    private int level = 0;
    private String sortPath;

    private TargetEntry() {
    }

    public TargetEntry(GUID guid, Type entryType, String entryTypeKey, String displayName) {
        this.guid = guid;
        this.entryType = entryType;
        this.entryTypeKey = entryTypeKey;
        this.displayName = displayName;
        this.sortPath = displayName;
    }

    public void setDummy(boolean dummy) {
        this.dummy = dummy;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEntryTypeKey() {
        return this.entryTypeKey;
    }

    public void setPreventEditing(boolean preventEditing) {
        this.preventEditing = preventEditing;
    }

    public boolean isPreventEditing() {
        return this.preventEditing;
    }

    public String getMembershipType() {
        return this.membershipType;
    }

    public String getMembershipGroupKey() {
        return this.membershipGroupKey;
    }

    public GUID getGuid() {
        return this.guid;
    }

    public Type getEntryType() {
        return this.entryType;
    }

    public void setParents(ArrayList<TargetParent> parents) {
        if (parents != null && parents.isEmpty()) {
            parents = null;
        }
        this.parents = parents;
        if (parents != null) {
            this.level = parents.size();
            String joined = parents.stream().map(TargetParent::getDisplayName).collect(Collectors.joining("/"));
            this.sortPath = joined + "/" + this.displayName;
        }
    }

    public List<TargetParent> getParents() {
        if (this.parents == null) {
            return null;
        }
        return new ArrayList<TargetParent>(this.parents);
    }

    public void setChildren(ArrayList<TargetChild> children) {
        this.children = children;
    }

    public List<TargetChild> getChildren() {
        if (this.children == null) {
            return null;
        }
        return new ArrayList<TargetChild>(this.children);
    }
}

