/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.HDConfigStructureProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MailSenderOrderConfigUtils {
    static void saveTo(ConfigStructureSettings settings) {
        String originalValueStr = settings.getOriginalValue(HDConfigKeys.MAIL_SENDER_ORDER);
        String origChoiceString = originalValueStr + "4444";
        String choice1 = origChoiceString.substring(0, 1);
        String choice2 = origChoiceString.substring(1, 2);
        String choice3 = origChoiceString.substring(2, 3);
        String choice4 = origChoiceString.substring(3, 4);
        Object resultChoice = null;
        String k = HDConfigKeys.MAIL_SENDER_ORDER.getKey();
        String newChoice1 = settings.getValue(k + ".01234");
        boolean changedChoice = false;
        if (newChoice1 != null && !choice1.equals(newChoice1)) {
            choice1 = newChoice1;
            changedChoice = true;
        }
        Object keyOfValueToCheck = "";
        switch (choice1) {
            case "0": {
                keyOfValueToCheck = k + ".1234";
                break;
            }
            case "1": {
                keyOfValueToCheck = k + ".0234";
                break;
            }
            case "2": {
                keyOfValueToCheck = k + ".0134";
                break;
            }
            case "3": {
                keyOfValueToCheck = k + ".0124";
                break;
            }
            case "4": {
                resultChoice = "4";
                break;
            }
        }
        if (resultChoice != null) {
            settings.save(HDConfigKeys.MAIL_SENDER_ORDER, (String)resultChoice);
            return;
        }
        String newChoice2 = settings.getValue((String)keyOfValueToCheck);
        if (changedChoice && newChoice2 == null) {
            newChoice2 = "4";
        }
        if (newChoice2 != null && !choice2.equals(newChoice2)) {
            choice2 = newChoice2;
            changedChoice = true;
        }
        switch (choice1 + choice2) {
            case "01": 
            case "10": {
                keyOfValueToCheck = k + ".234";
                break;
            }
            case "02": 
            case "20": {
                keyOfValueToCheck = k + ".134";
                break;
            }
            case "03": 
            case "30": {
                keyOfValueToCheck = k + ".124";
                break;
            }
            case "12": 
            case "21": {
                keyOfValueToCheck = k + ".034";
                break;
            }
            case "13": 
            case "31": {
                keyOfValueToCheck = k + ".024";
                break;
            }
            case "23": 
            case "32": {
                keyOfValueToCheck = k + ".014";
                break;
            }
            case "04": 
            case "14": 
            case "24": 
            case "34": {
                resultChoice = choice1 + choice2;
            }
        }
        if (resultChoice != null) {
            settings.save(HDConfigKeys.MAIL_SENDER_ORDER, (String)resultChoice);
            return;
        }
        String newChoice3 = settings.getValue((String)keyOfValueToCheck);
        if (changedChoice && newChoice3 == null) {
            newChoice3 = "4";
        }
        if (newChoice3 != null && !choice3.equals(newChoice3)) {
            choice3 = newChoice3;
            changedChoice = true;
        }
        switch (choice1 + choice2 + choice3) {
            case "012": 
            case "021": 
            case "102": 
            case "201": 
            case "120": 
            case "210": {
                keyOfValueToCheck = k + ".34";
                break;
            }
            case "013": 
            case "031": 
            case "103": 
            case "301": 
            case "130": 
            case "310": {
                keyOfValueToCheck = k + ".24";
                break;
            }
            case "023": 
            case "032": 
            case "203": 
            case "302": 
            case "230": 
            case "320": {
                keyOfValueToCheck = k + ".14";
                break;
            }
            case "123": 
            case "132": 
            case "213": 
            case "312": 
            case "231": 
            case "321": {
                keyOfValueToCheck = k + ".04";
                break;
            }
            default: {
                if (!"4".equals(choice3)) break;
                resultChoice = choice1 + choice2 + choice3;
            }
        }
        if (resultChoice != null) {
            settings.save(HDConfigKeys.MAIL_SENDER_ORDER, (String)resultChoice);
            return;
        }
        String newChoice4 = settings.getValue((String)keyOfValueToCheck);
        if (changedChoice && newChoice4 == null) {
            newChoice4 = "4";
        }
        if (newChoice4 != null && !choice4.equals(newChoice4)) {
            choice4 = newChoice4;
        }
        resultChoice = choice1 + choice2 + choice3 + choice4;
        if (!choice4.equals("4")) {
            resultChoice = (String)resultChoice + "4";
        }
        settings.save(HDConfigKeys.MAIL_SENDER_ORDER, (String)resultChoice);
    }

    static void addSenderOrderSelects(HDConfigStructureProvider provider, Set<ConfigProperty> configProperties, ConfigStructureSettings settings) {
        Object choiceString = settings.getValue(HDConfigKeys.MAIL_SENDER_ORDER);
        choiceString = (String)choiceString + "4444";
        List<LocalizedKey> options01234 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 0, 1, 2, 3, 4);
        List<LocalizedKey> options1234 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 1, 2, 3, 4);
        List<LocalizedKey> options234 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 2, 3, 4);
        List<LocalizedKey> options34 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 3, 4);
        List<LocalizedKey> options4 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 4);
        List<LocalizedKey> options24 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 2, 4);
        List<LocalizedKey> options134 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 1, 3, 4);
        List<LocalizedKey> options14 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 1, 4);
        List<LocalizedKey> options124 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 1, 2, 4);
        List<LocalizedKey> options0234 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 0, 2, 3, 4);
        List<LocalizedKey> options034 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 0, 3, 4);
        List<LocalizedKey> options04 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 0, 4);
        List<LocalizedKey> options024 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 0, 2, 4);
        List<LocalizedKey> options0134 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 0, 1, 3, 4);
        List<LocalizedKey> options014 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 0, 1, 4);
        List<LocalizedKey> options0124 = MailSenderOrderConfigUtils.getSenderOptions(provider, settings, 0, 1, 2, 4);
        String choice1 = ((String)choiceString).substring(0, 1);
        String choice2 = ((String)choiceString).substring(1, 2);
        String choice3 = ((String)choiceString).substring(2, 3);
        String choice4 = ((String)choiceString).substring(3, 4);
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".01234", choice1, "SimpleText", settings, options01234);
        String presetValue = choice1.equals("0") ? choice2 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".1234", presetValue, "SimpleText", settings, options1234);
        presetValue = choice1.equals("3") ? choice2 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".0124", presetValue, "SimpleText", settings, options0124);
        presetValue = choice1.equals("1") ? choice2 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".0234", presetValue, "SimpleText", settings, options0234);
        presetValue = choice1.equals("2") ? choice2 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".0134", presetValue, "SimpleText", settings, options0134);
        presetValue = "12".contains(choice1) && "12".contains(choice2) ? choice3 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".034", presetValue, "SimpleText", settings, options034);
        presetValue = "03".contains(choice1) && "03".contains(choice2) ? choice3 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".124", presetValue, "SimpleText", settings, options124);
        presetValue = "02".contains(choice1) && "02".contains(choice2) ? choice3 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".134", presetValue, "SimpleText", settings, options134);
        presetValue = "01".contains(choice1) && "01".contains(choice2) ? choice3 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".234", presetValue, "SimpleText", settings, options234);
        presetValue = "13".contains(choice1) && "13".contains(choice2) ? choice3 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".024", presetValue, "SimpleText", settings, options024);
        presetValue = "23".contains(choice1) && "23".contains(choice2) ? choice3 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".014", presetValue, "SimpleText", settings, options014);
        presetValue = "012".contains(choice1) && "012".contains(choice2) && "012".contains(choice3) ? choice4 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".34", presetValue, "SimpleText", settings, options34);
        presetValue = "013".contains(choice1) && "013".contains(choice2) && "013".contains(choice3) ? choice4 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".24", presetValue, "SimpleText", settings, options24);
        presetValue = "023".contains(choice1) && "023".contains(choice2) && "023".contains(choice3) ? choice4 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".14", presetValue, "SimpleText", settings, options14);
        presetValue = "123".contains(choice1) && "123".contains(choice2) && "123".contains(choice3) ? choice4 : "4";
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".04", presetValue, "SimpleText", settings, options04);
        provider.addSelectBox(configProperties, HDConfigKeys.MAIL_SENDER_ORDER.getKey() + ".4", "4", "SimpleText", settings, options4);
    }

    private static List<LocalizedKey> getSenderOptions(final AbstractStructureProvider provider, final ConfigStructureSettings settings, int ... options) {
        String fallbackSender = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.MAIL_SENDER);
        if (fallbackSender.trim().isEmpty()) {
            fallbackSender = provider.translate(settings, "attachmentfilebehavior.none", new Object[0]);
        }
        final String fallbackAddress = fallbackSender;
        HashMap<Integer, String> values = new HashMap<Integer, String>(){
            {
                this.put(0, provider.translate(settings, "mail.sender.order.supporterAddress", new Object[0]));
                this.put(1, provider.translate(settings, "mail.sender.order.postfach", new Object[0]));
                this.put(2, provider.translate(settings, "mail.sender.order.category", new Object[0]));
                this.put(3, provider.translate(settings, "mail.sender.order.resource", new Object[0]));
                this.put(4, provider.translate(settings, "mail.sender.order.fallbackAddress", new Object[]{fallbackAddress}));
            }
        };
        return Arrays.stream(options).mapToObj(o -> new LocalizedKey("" + o, (String)values.get(o))).collect(Collectors.toList());
    }

    static void addMailSenderOrderConditions(List<ConfigConditionAction> actions, ConditionGenerator g) {
        String key = HDConfigKeys.MAIL_SENDER_ORDER.getKey();
        ConfigCondition first0 = MailSenderOrderConfigUtils.eq(key + ".01234", "0");
        ConfigCondition first1 = MailSenderOrderConfigUtils.eq(key + ".01234", "1");
        ConfigCondition first2 = MailSenderOrderConfigUtils.eq(key + ".01234", "2");
        ConfigCondition first3 = MailSenderOrderConfigUtils.eq(key + ".01234", "3");
        ConfigCondition chose01 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(first0, MailSenderOrderConfigUtils.eq(key + ".1234", "1")), MailSenderOrderConfigUtils.and(first1, MailSenderOrderConfigUtils.eq(key + ".0234", "0")));
        ConfigCondition chose02 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(first0, MailSenderOrderConfigUtils.eq(key + ".1234", "2")), MailSenderOrderConfigUtils.and(first2, MailSenderOrderConfigUtils.eq(key + ".0134", "0")));
        ConfigCondition chose03 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(first0, MailSenderOrderConfigUtils.eq(key + ".1234", "3")), MailSenderOrderConfigUtils.and(first3, MailSenderOrderConfigUtils.eq(key + ".0124", "0")));
        ConfigCondition chose12 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(first1, MailSenderOrderConfigUtils.eq(key + ".0234", "2")), MailSenderOrderConfigUtils.and(first2, MailSenderOrderConfigUtils.eq(key + ".0134", "1")));
        ConfigCondition chose13 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(first1, MailSenderOrderConfigUtils.eq(key + ".0234", "3")), MailSenderOrderConfigUtils.and(first3, MailSenderOrderConfigUtils.eq(key + ".0124", "1")));
        ConfigCondition chose23 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(first2, MailSenderOrderConfigUtils.eq(key + ".0134", "3")), MailSenderOrderConfigUtils.and(first3, MailSenderOrderConfigUtils.eq(key + ".0124", "2")));
        ConfigCondition chose012 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(chose01, MailSenderOrderConfigUtils.eq(key + ".234", "2")), MailSenderOrderConfigUtils.and(chose02, MailSenderOrderConfigUtils.eq(key + ".134", "1")), MailSenderOrderConfigUtils.and(chose12, MailSenderOrderConfigUtils.eq(key + ".034", "0")));
        ConfigCondition chose013 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(chose01, MailSenderOrderConfigUtils.eq(key + ".234", "3")), MailSenderOrderConfigUtils.and(chose03, MailSenderOrderConfigUtils.eq(key + ".124", "1")), MailSenderOrderConfigUtils.and(chose13, MailSenderOrderConfigUtils.eq(key + ".024", "0")));
        ConfigCondition chose023 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(chose02, MailSenderOrderConfigUtils.eq(key + ".134", "3")), MailSenderOrderConfigUtils.and(chose03, MailSenderOrderConfigUtils.eq(key + ".124", "2")), MailSenderOrderConfigUtils.and(chose23, MailSenderOrderConfigUtils.eq(key + ".014", "0")));
        ConfigCondition chose123 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(chose12, MailSenderOrderConfigUtils.eq(key + ".034", "3")), MailSenderOrderConfigUtils.and(chose13, MailSenderOrderConfigUtils.eq(key + ".024", "2")), MailSenderOrderConfigUtils.and(chose23, MailSenderOrderConfigUtils.eq(key + ".014", "1")));
        ConfigCondition chose0123 = MailSenderOrderConfigUtils.or(MailSenderOrderConfigUtils.and(chose012, MailSenderOrderConfigUtils.eq(key + ".34", "3")), MailSenderOrderConfigUtils.and(chose013, MailSenderOrderConfigUtils.eq(key + ".24", "2")), MailSenderOrderConfigUtils.and(chose023, MailSenderOrderConfigUtils.eq(key + ".14", "1")), MailSenderOrderConfigUtils.and(chose123, MailSenderOrderConfigUtils.eq(key + ".04", "0")));
        ConfigCondition show1234 = first0;
        ConfigCondition show234 = chose01;
        ConfigCondition show34 = chose012;
        ConfigCondition show4 = chose0123;
        ConfigCondition show24 = chose013;
        ConfigCondition show134 = chose02;
        ConfigCondition show14 = chose023;
        ConfigCondition show124 = chose03;
        ConfigCondition show0234 = first1;
        ConfigCondition show034 = chose12;
        ConfigCondition show04 = chose123;
        ConfigCondition show024 = chose13;
        ConfigCondition show0134 = first2;
        ConfigCondition show014 = chose23;
        ConfigCondition show0124 = first3;
        actions.add(g.visibleActionFor(show1234, key + ".1234"));
        actions.add(g.visibleActionFor(show234, key + ".234"));
        actions.add(g.visibleActionFor(show34, key + ".34"));
        actions.add(g.visibleActionFor(show4, key + ".4"));
        actions.add(g.visibleActionFor(show24, key + ".24"));
        actions.add(g.visibleActionFor(show134, key + ".134"));
        actions.add(g.visibleActionFor(show14, key + ".14"));
        actions.add(g.visibleActionFor(show124, key + ".124"));
        actions.add(g.visibleActionFor(show0234, key + ".0234"));
        actions.add(g.visibleActionFor(show034, key + ".034"));
        actions.add(g.visibleActionFor(show04, key + ".04"));
        actions.add(g.visibleActionFor(show024, key + ".024"));
        actions.add(g.visibleActionFor(show0134, key + ".0134"));
        actions.add(g.visibleActionFor(show014, key + ".014"));
        actions.add(g.visibleActionFor(show0124, key + ".0124"));
        ConfigCondition includeOtherEntries = g.createCondition().property(HDConfigKeys.CLIENT_START_OPTION.getKey() + ".268435456").equals().value((Object)"true");
        actions.add(g.enableActionFor(includeOtherEntries, key + ".01234"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".1234"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".234"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".34"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".4"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".24"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".134"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".14"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".124"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".0234"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".034"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".04"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".024"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".0134"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".014"));
        actions.add(g.enableActionFor(includeOtherEntries, key + ".0124"));
    }

    private static ConfigCondition and(ConfigCondition ... args) {
        ConditionGenerator g = new ConditionGenerator();
        return g.createCondition().and(args);
    }

    private static ConfigCondition or(ConfigCondition ... args) {
        ConditionGenerator g = new ConditionGenerator();
        return g.createCondition().or(args);
    }

    private static ConfigCondition eq(String key, String value) {
        return new ConditionGenerator().createCondition().property(key).equals().value((Object)value);
    }
}

