/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.ConfigKey;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.helpdesk.config.AliasMapper;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.DatabaseConfigInfoListConfigProperty;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.EmailAccountListConfigProperty;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.config.LdapConnectionInfoListConfigProperty;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.config.LocalizedKeyListFactory;
import com.inet.helpdesk.config.MailResourceToAbsenderAndAliasMap;
import com.inet.helpdesk.config.MailSenderOrderConfigUtils;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.utils.SqlServerSearcher;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.FieldInformation;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.list.PairList;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.GraphicsEnvironment;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;

public class HDConfigStructureProvider
extends AbstractStructureProvider {
    private static final String CATEGORY_JTAPI = "helpdesk.main.jtapi";
    private static final String CATEGORY_EMAIL_AUTOMAILS = "helpdesk.email.automails";
    private static final String CATEGORY_LOGIN = "category.login";
    private static final String CATEGORY_EMAIL_SENDEN = "helpdesk.email.senden";
    private static final String CATEGORY_EMAIL_EINLESEN = "helpdesk.email.einlesen";
    private static final String CATEGORY_EMAIL_ACCOUNTS = "helpdesk.email.accounts";
    private static final String CATEGORY_DB = "helpdesk.main.db";
    private static final String CATEGORY_CITRIX = "helpdesk.main.citrix";
    private static final String CATEGORY_DEVICE = "helpdesk.main.device";
    private static final String CATEGORY_JAVASCRIPT_TRIGGER = "helpdesk.main.trigger";
    public static final String PROP_GROUP_HELPDESK_DB = "helpdesk.main.db.hds";
    public static final String PROP_GROUP_HELPDESK_LOGIN = "helpdesk.main.login.helpdesk";
    public static final String PROP_GROUP_DB = "helpdesk.main.db.main";
    public static final String PROP_GROUP_LDAP_DBS = "helpdesk.main.db.ldap";
    public static final String PROP_GROUP_TRIGGER = "helpdesk.main.trigger.main";
    public static final String PROP_GROUP_DEVICE = "helpdesk.device.main";
    public static final String PROP_GROUP_JTAPI = "helpdesk.main.jtapi.main";
    public static final String PROP_GROUP_JTAPI_TITLE_LABEL = "helpdesk.main.jtapi.main.title.label";
    public static final String PROP_GROUP_GENERAL = "helpdesk.main.general.main";
    public static final String PROP_GROUP_CITRIX = "helpdesk.main.citrix.main";
    public static final String PROP_GROUP_EMAIL_RESOURCE = "helpdesk.email.automails.resource";
    public static final String PROP_GROUP_TRIGGER_TITLE_LABEL = "trigger.title_label";
    public static final String PROP_GROUP_AUTOMAIL_WARNING_LABEL = "automail.warning_label";
    public static final String PROP_GROUP_EMAIL_DISPATCHER = "helpdesk.email.automails.dispatcher";
    public static final String PROP_GROUP_EMAIL_USER = "helpdesk.email.automails.user";
    public static final String PROP_GROUP_EMAIL_SENDEN_CLIENT_MAIL = "helpdesk.email.senden.client";
    public static final String PROP_GROUP_EMAIL_SENDEN_CLIENT_MAIL_ABSENDER_REIHENFOLGE = "helpdesk.email.senden.client.senden.reihenfolge";
    public static final String PROP_GROUP_EMAIL_SENDEN_RESOURCE_TO_ABSENDER = "helpdesk.email.senden.resToAbsender";
    public static final String PROP_GROUP_EMAIL_SENDEN_MAIL_HEADERS = "helpdesk.email.senden.mailHeaders";
    public static final String PROP_GROUP_AUTOMAILS_ANDERE = "helpdesk.automails.andere";
    public static final String PROP_GROUP_EMAIL_EINLESEN = "helpdesk.email.einlesen.main";
    public static final String PROP_GROUP_INTERNE_EMAILS = "helpdesk.email.einlesen.internal";
    public static final String PROP_GROUP_EMAIL_EINLESEN_PARAM_TAGS = "helpdesk.email.einlesen.main.tags";
    public static final String PROP_GROUP_EMAIL_ACCOUNTS = "helpdesk.email.accounts.main";
    private static final String ACTION_TEST_DB = "helpdesk.db.testdb";
    private static final String ACTION_TEST_DB_NEW = "helpdesk.db.testdb.new";
    public static final String ACTION_TEST_EMAIL = "helpdesk.testemail";
    public static final String ACTION_TEST_ALL_EMAIL_ACCOUNTS = "helpdesk.testallemailaccounts";
    private static final String ACTION_RELOAD_TRIGGERS = "helpdesk.main.email.reloadTriggers";
    static final Integer[] FLIPPED_BITS = new Integer[]{16384, 0x10000000, 0x200000, 0x400000, 0x20000000};
    private final ConnectionFactory connectionFactory;
    private DatabaseConfigInfoList availableSqlServers;
    private long lastScan = 0L;

    public HDConfigStructureProvider(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void addGroupsTo(Set<ConfigGroup> groups, boolean advanced, ConfigStructureSettings settings) {
        groups.add(this.getCommunicationGroup(settings));
    }

    public void addCategoriesTo(Set<ConfigCategory> categories, String groupKey, boolean advanced, ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.system": {
                categories.add(new ConfigCategory(70, CATEGORY_DB, this.translate(settings, "DATENBANK", new Object[0]), "system.database"));
                break;
            }
            case "categorygroup.components": {
                categories.add(new ConfigCategory(123, CATEGORY_JAVASCRIPT_TRIGGER, this.translate(settings, "TRIGGER", new Object[0]), "components.trigger"));
                if (!advanced) break;
                categories.add(new ConfigCategory(131, CATEGORY_CITRIX, this.translate(settings, "CITRIX", new Object[0]), "advanced.citrix"));
                categories.add(new ConfigCategory(133, CATEGORY_DEVICE, this.translate(settings, "DEVICE", new Object[0]), "advanced.device"));
                break;
            }
            case "categorygroup.communication": {
                categories.add(new ConfigCategory(131, CATEGORY_EMAIL_ACCOUNTS, this.translate(settings, "EMAILACCOUNTS", new Object[0]), "email.accounts"));
                categories.add(new ConfigCategory(132, CATEGORY_EMAIL_AUTOMAILS, this.translate(settings, "AUTOMAILS", new Object[0]), "email.automails"));
                categories.add(new ConfigCategory(133, CATEGORY_JTAPI, this.translate(settings, "Telefonie", new Object[0]), "email.jtapi"));
                if (!advanced) break;
                categories.add(new ConfigCategory(134, CATEGORY_EMAIL_SENDEN, this.translate(settings, "SENDEN", new Object[0]), "email.senden"));
                categories.add(new ConfigCategory(135, CATEGORY_EMAIL_EINLESEN, this.translate(settings, "EINLESEN", new Object[0]), "email.einlesen"));
                break;
            }
        }
    }

    public URL getCategoryIcon(String categoryKey) {
        try {
            switch (categoryKey) {
                case "helpdesk.main.db": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/dataconnection_48.png");
                }
                case "helpdesk.main.trigger": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/jscript_trigger_48.png");
                }
                case "helpdesk.main.jtapi": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/telephone_48.png");
                }
                case "helpdesk.main.citrix": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/citrix_48.png");
                }
                case "helpdesk.main.device": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/inventar_48.png");
                }
                case "helpdesk.email.automails": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/email_auto_48.png");
                }
                case "helpdesk.email.senden": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/email_send_48.png");
                }
                case "helpdesk.email.einlesen": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/email_receive_48.png");
                }
                case "helpdesk.email.accounts": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/email_server_in_48.png");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addPropertyGroupsTo(Set<ConfigPropertyGroup> configPropertyGroups, String categoryKey, boolean advanced, ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.login": {
                configPropertyGroups.add(new ConfigPropertyGroup(99999, PROP_GROUP_HELPDESK_LOGIN));
                break;
            }
            case "helpdesk.main.jtapi": {
                configPropertyGroups.add(new ConfigPropertyGroup(0, PROP_GROUP_JTAPI_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_JTAPI));
                break;
            }
            case "helpdesk.main.device": {
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_DEVICE));
                break;
            }
            case "helpdesk.main.db": {
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_HELPDESK_DB, this.translate(settings, "inetHelpDeskDatenbank", new Object[0]), new ConfigAction(ACTION_TEST_DB, this.translate(settings, ACTION_TEST_DB, new Object[0]))));
                configPropertyGroups.add(new ConfigPropertyGroup(124, PROP_GROUP_LDAP_DBS, this.translate(settings, "LdapDatenbanken", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(125, PROP_GROUP_DB, this.translate(settings, "WeitereDatenbanken", new Object[0])));
                break;
            }
            case "helpdesk.main.trigger": {
                configPropertyGroups.add(new ConfigPropertyGroup(0, PROP_GROUP_TRIGGER_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_TRIGGER, this.translate(settings, "TRIGGER", new Object[0]), new ConfigAction(ACTION_RELOAD_TRIGGERS, this.translate(settings, ACTION_RELOAD_TRIGGERS, new Object[0]))));
                break;
            }
            case "helpdesk.email.automails": {
                configPropertyGroups.add(new ConfigPropertyGroup(0, PROP_GROUP_AUTOMAIL_WARNING_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_EMAIL_RESOURCE, this.translate(settings, "AutoEmailsanRessourcen", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(124, PROP_GROUP_EMAIL_DISPATCHER, this.translate(settings, "AutoEmailsanDispatcher", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(126, PROP_GROUP_EMAIL_USER, this.translate(settings, "AutoEmailsanBenutzer", new Object[0])));
                if (!advanced) break;
                configPropertyGroups.add(new ConfigPropertyGroup(127, PROP_GROUP_AUTOMAILS_ANDERE, this.translate(settings, "AndereEinstellungen", new Object[0])));
                break;
            }
            case "helpdesk.email.senden": {
                if (!advanced) break;
                configPropertyGroups.add(new ConfigPropertyGroup(126, PROP_GROUP_EMAIL_SENDEN_CLIENT_MAIL, this.translate(settings, "EmailDialogimClient", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(128, PROP_GROUP_EMAIL_SENDEN_CLIENT_MAIL_ABSENDER_REIHENFOLGE, this.translate(settings, "EmailDialogimClientAbsendenReihenfolge", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(129, PROP_GROUP_EMAIL_SENDEN_MAIL_HEADERS, this.translate(settings, "EmailHeader", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(130, PROP_GROUP_EMAIL_SENDEN_RESOURCE_TO_ABSENDER, this.translate(settings, "RessourcenAbsender", new Object[0])));
                break;
            }
            case "helpdesk.email.einlesen": {
                configPropertyGroups.add(new ConfigPropertyGroup(127, PROP_GROUP_EMAIL_EINLESEN, this.translate(settings, "EmpfangenvonEmails", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(128, PROP_GROUP_INTERNE_EMAILS, this.translate(settings, "InterneEmails", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(129, PROP_GROUP_EMAIL_EINLESEN_PARAM_TAGS, this.translate(settings, "EmpfangenvonEmails_Params", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_GENERAL));
                break;
            }
            case "helpdesk.email.accounts": {
                configPropertyGroups.add(new ConfigPropertyGroup(128, PROP_GROUP_EMAIL_ACCOUNTS, this.translate(settings, "EmailKonten", new Object[0]), new ConfigAction(ACTION_TEST_ALL_EMAIL_ACCOUNTS, this.translate(settings, ACTION_TEST_ALL_EMAIL_ACCOUNTS, new Object[0]))));
                break;
            }
            case "helpdesk.main.citrix": {
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_CITRIX, this.translate(settings, PROP_GROUP_CITRIX, new Object[0])));
                break;
            }
        }
    }

    public void action(@Nonnull String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        switch (actionKey) {
            case "helpdesk.main.email.reloadTriggers": {
                ConfigValidator validator = new ConfigValidator(messages, settings);
                String current = settings.getValue(HDConfigKeys.TRIGGER_FILES);
                HashMap triggerFiles = current == null ? new HashMap() : (HashMap)new Json().fromJson(current, HashMap.class);
                for (String key2 : new String[]{"TRIGGER_MAIL_NEW_IN", "TRIGGER_MAIL_IN", "TRIGGER_MAIL_OUT", "TRIGGER_STATUS_CHANGE", "TRIGGER_ITIL_CHANGE", "TRIGGER_NEW_USER_TICKET"}) {
                    String v = settings.getChangedValue(key2);
                    if (v == null || v.length() != 0 && (v.length() <= 0 || !validator.checkFileExists(v, key2))) continue;
                    triggerFiles.remove(key2);
                    triggerFiles.put(key2.substring("TRIGGER_".length()), v);
                }
                if (messages.size() != 0) break;
                this.checkAndReadTriggers(messages, settings, triggerFiles);
                break;
            }
            case "helpdesk.db.testdb.new": {
                boolean emptyDbForNonOracle;
                DatabaseConfigInfo hds = new DatabaseConfigInfo();
                List<String> dbSettings = Arrays.asList("driver", "hostmssql", "host", "portmssql", "portmysql", "portoracle", "odbcsource", "catalog", "sid", "user", "password", "url");
                if (settings.getValue("driver") == null || settings.getValue("driver").trim().isEmpty()) {
                    this.addValidationMessage(settings, messages, hds, this.translate(settings, "NeedDriver", new Object[0]));
                    break;
                }
                dbSettings.stream().filter(key -> settings.getValue(key) != null).forEach(key -> this.setDbConfigInfoValueForKey((String)key, settings.getValue(key), hds));
                String className = hds.getDriverClassName();
                if (!DatabaseConfigInfo.DatabaseType.other.equals((Object)hds.getDriver()) && !DatabaseConfigInfo.DatabaseType.unknown.equals((Object)hds.getDriver())) {
                    hds.setCustomUrl(null);
                }
                boolean bl = emptyDbForNonOracle = !"com.inet.ora.OraDriver".equals(className) && !DatabaseConfigInfo.DatabaseType.odbc.equals((Object)hds.getDriver()) && !DatabaseConfigInfo.DatabaseType.other.equals((Object)hds.getDriver()) && hds.getCatalog().isEmpty();
                if (emptyDbForNonOracle && hds.getCustomUrl() == null) {
                    this.addValidationMessage(settings, messages, hds, this.translate(settings, "NeedCatalog", new Object[0]));
                    break;
                }
                if (hds.getHost().isEmpty() && !DatabaseConfigInfo.DatabaseType.odbc.equals((Object)hds.getDriver()) && !DatabaseConfigInfo.DatabaseType.other.equals((Object)hds.getDriver()) && hds.getCustomUrl() == null) {
                    this.addValidationMessage(settings, messages, hds, this.translate(settings, "NeedHost", new Object[0]));
                    break;
                }
                String msg = ServerUtilities.testDB(hds.getUrl(), hds.getDecodedPassword(), hds.getUser(), className, null, false);
                this.addValidationMessage(settings, messages, hds, msg);
                break;
            }
            case "helpdesk.db.testdb": {
                DatabaseConfigInfoList list = HDConfigStructureProvider.getDatabaseConfigInfoList(settings);
                DatabaseConfigInfo hds = this.getHDS(list, settings);
                String msg = this.testHDSConnection(settings, hds);
                if (!DatabaseConfigInfo.DatabaseType.inetora.equals((Object)hds.getDriver()) && !DatabaseConfigInfo.DatabaseType.odbc.equals((Object)hds.getDriver()) && !DatabaseConfigInfo.DatabaseType.other.equals((Object)hds.getDriver()) && hds.getCatalog().isEmpty() && hds.getCustomUrl() == null) {
                    this.addValidationMessage(settings, messages, hds, this.translate(settings, "NeedCatalog", new Object[0]));
                    break;
                }
                if (hds.getHost().isEmpty() && !DatabaseConfigInfo.DatabaseType.odbc.equals((Object)hds.getDriver()) && !DatabaseConfigInfo.DatabaseType.other.equals((Object)hds.getDriver()) && hds.getCustomUrl() == null) {
                    this.addValidationMessage(settings, messages, hds, this.translate(settings, "NeedHost", new Object[0]));
                    break;
                }
                this.addValidationMessage(settings, messages, hds, msg);
                break;
            }
            case "helpdesk.testemail": {
                String errorMessage;
                String emailPort;
                String emailHost = settings.getValue("host");
                String emailAccountName = settings.getValue("account");
                String emailPassword = settings.getValue("password");
                String emailProtokoll = settings.getValue("protocol");
                String preventPlainAuth = settings.getValue("preventPlainAuth");
                String preventNtlmAuth = settings.getValue("preventNtlmAuth");
                String portKey = EmailAccountListConfigProperty.portFieldForProtocol(emailProtokoll);
                if (portKey != null) {
                    emailPort = settings.getValue(portKey);
                    if ("null".equals(emailPort)) {
                        emailPort = null;
                    }
                } else {
                    emailPort = "0";
                }
                if ((errorMessage = EmailAccountListConfigProperty.checkEmailAccountConnection(emailHost, emailAccountName, emailPassword, emailProtokoll, emailPort, preventPlainAuth, preventNtlmAuth)) != null) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, errorMessage, ""));
                    break;
                }
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, ListResourceBundle.getBundle("lang.HDSMsg", settings.getLocale()).getString("VerbM") + emailHost, ""));
                break;
            }
            case "action.generateTrial": {
                CoreSystemStructureProvider.requestTrialLicense((ConfigStructureSettings)settings);
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Reload, "", "action.generateTrial"));
                break;
            }
            case "helpdesk.testallemailaccounts": {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Reload, "", "helpdesk.testallemailaccounts.ok"));
                break;
            }
            case "helpdesk.testallemailaccounts.ok": {
                String validatedValue;
                HashMap[] changedValue = (HashMap[])settings.getChangedValue(HDConfigKeys.MAIL_ACCOUNTS, HashMap[].class);
                if (changedValue == null) {
                    String originalValue = settings.getOriginalValue(HDConfigKeys.MAIL_ACCOUNTS);
                    EmailAccountList emailAccountList = (EmailAccountList)new Json().fromJson(originalValue, EmailAccountList.class);
                    ArrayList<HashMap<String, String>> emailAccounts = EmailAccountListConfigProperty.convertAccountsToHashMaps(emailAccountList, t -> this.translate(settings, t));
                    HashMap[] convertedOriginalValue = new HashMap[emailAccounts.size()];
                    for (int index = 0; index < emailAccounts.size(); ++index) {
                        HashMap<String, String> account = emailAccounts.get(index);
                        String errorMsg = EmailAccountListConfigProperty.testConnectionToEmailAccount(account);
                        account.put("errorMessage", errorMsg);
                        convertedOriginalValue[index] = account;
                    }
                    validatedValue = new Json().toJson((Object)convertedOriginalValue);
                } else {
                    for (HashMap account : changedValue) {
                        String errorMsg = EmailAccountListConfigProperty.testConnectionToEmailAccount(account);
                        account.put("errorMessage", errorMsg);
                    }
                    validatedValue = new Json().toJson((Object)changedValue);
                }
                settings.getValues().setProperty(HDConfigKeys.MAIL_ACCOUNTS.getKey(), validatedValue);
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Reload, "", "helpdesk.testallemailaccounts.ok"));
                break;
            }
            default: {
                super.action(actionKey, messages, settings);
            }
        }
    }

    protected void checkAndReadTriggers(@Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings, @Nonnull HashMap<String, String> files) {
        String[] msgs = ServerUtilities.TRIGGERS.readTriggers(files, true);
        String reduced = Arrays.asList(msgs).stream().reduce("", (orig, n) -> orig + n + ", ");
        if (reduced.length() > 1) {
            reduced = reduced.substring(0, reduced.length() - 2);
            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "InvalidTrigger", new Object[]{reduced}), HDConfigKeys.TRIGGER_FILES));
        } else {
            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "TriggersValid", new Object[0]), HDConfigKeys.TRIGGER_FILES));
        }
    }

    String testHDSConnection(ConfigStructureSettings settings, DatabaseConfigInfo hds) {
        List<String> dbSettings = Arrays.asList("Treiber", "hostmssql", "host", "portmssql", "portmysql", "portoracle", "ODBCSource", "Catalog", "SID", "Benutzername", "Passwort", "URL");
        dbSettings.stream().filter(key -> "URL".equals(key) && settings.getValues() != null && settings.getValues().containsKey("HDSURL") || settings.getValue("HDS" + key) != null).forEach(key -> this.setDbConfigInfoValueForKey((String)key, settings.getValue("HDS" + key), hds));
        return this.testHDSConnection(hds);
    }

    private String testHDSConnection(DatabaseConfigInfo hds) {
        String className = hds.getDriverClassName();
        return ServerUtilities.testDB(hds.getUrl(), hds.getDecodedPassword(), hds.getUser(), className, "HDS", false);
    }

    private void addValidationMessage(ConfigStructureSettings settings, ArrayList<ConfigValidationMsg> messages, DatabaseConfigInfo hds, String msg) {
        if (msg != null) {
            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, (String)msg, ""));
            hds.setStatus(DatabaseConfigInfo.Status.Invalid);
        } else {
            msg = ((ListResourceBundle)ListResourceBundle.getBundle("lang.HDSMsg", settings.getLocale())).getString("VerbM");
            msg = (String)msg + (hds.getCustomUrl() == null ? hds.getHost() : "JDBC-URL");
            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, (String)msg, ""));
            hds.setStatus(DatabaseConfigInfo.Status.Valid);
        }
    }

    public void addPropertiesTo(Set<ConfigProperty> configProperties, String propertyGroupKey, boolean advanced, final @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "propertygroup.companyinfo": {
                List langlist = Arrays.asList(Locale.getISOCountries()).stream().filter(l -> !"US".equals(l) && !"DE".equals(l)).collect(Collectors.toList());
                langlist.add(0, "US");
                langlist.add(0, "DE");
                List langs = langlist.stream().map(l -> new LocalizedKey(l, l)).collect(Collectors.toList());
                langs.add(0, new LocalizedKey("", ""));
                this.addTo(configProperties, HDConfigKeys.DEFAULT_COMPANY_ADDRESS, "MultiLineText", settings);
                break;
            }
            case "helpdesk.main.login.helpdesk": {
                this.addBitMaskTo(configProperties, HDConfigKeys.CLIENT_START_OPTION, settings, 16384);
                break;
            }
            case "trigger.title_label": {
                this.addTo(configProperties, PROP_GROUP_TRIGGER_TITLE_LABEL, "Label", settings);
                break;
            }
            case "automail.warning_label": {
                this.addTo(configProperties, "automail.warning_label.left", "KeyLabel", this.translate(settings, "automail.warning_label.right", new Object[0]), settings);
                break;
            }
            case "helpdesk.device.main": {
                this.addSelectTo(configProperties, HDConfigKeys.ADDITIONAL_DEVICE_COLUMN.getKey(), this.normalizeFieldNames(settings, HDConfigKeys.ADDITIONAL_DEVICE_COLUMN), "SimpleText", settings, this.getDeviceKeyColumnValues(settings.getLocale().getLanguage()));
                this.addTo(configProperties, HDConfigKeys.GERAETE_VERERBUNG, settings);
                break;
            }
            case "helpdesk.main.trigger.main": {
                HashMap triggerFiles = (HashMap)new Json().fromJson(settings.getValue(HDConfigKeys.TRIGGER_FILES), HashMap.class);
                this.addFileTo(configProperties, "TRIGGER_MAIL_NEW_IN", settings, System.getProperty("user.dir"), System.getProperty("user.dir"), new String[]{"*.js", "*.txt"}, (String)triggerFiles.get("MAIL_NEW_IN"));
                this.addFileTo(configProperties, "TRIGGER_MAIL_IN", settings, System.getProperty("user.dir"), System.getProperty("user.dir"), new String[]{"*.js", "*.txt"}, (String)triggerFiles.get("MAIL_IN"));
                this.addFileTo(configProperties, "TRIGGER_MAIL_OUT", settings, System.getProperty("user.dir"), System.getProperty("user.dir"), new String[]{"*.js", "*.txt"}, (String)triggerFiles.get("MAIL_OUT"));
                this.addFileTo(configProperties, "TRIGGER_STATUS_CHANGE", settings, System.getProperty("user.dir"), System.getProperty("user.dir"), new String[]{"*.js", "*.txt"}, (String)triggerFiles.get("STATUS_CHANGE"));
                configProperties.add((ConfigProperty)new BooleanConfigProperty(configProperties.size() * 100, HDConfigKeys.EXTENDED_STATE_EVENTS.getKey(), "Boolean", this.translate(settings, HDConfigKeys.EXTENDED_STATE_EVENTS.getKey(), new Object[0]), this.translate(settings, "TriggerOption", new Object[0]), null, (Object)settings.getValue(HDConfigKeys.EXTENDED_STATE_EVENTS)));
                this.addFileTo(configProperties, "TRIGGER_ITIL_CHANGE", settings, System.getProperty("user.dir"), System.getProperty("user.dir"), new String[]{"*.js", "*.txt"}, (String)triggerFiles.get("ITIL_CHANGE"));
                this.addFileTo(configProperties, "TRIGGER_NEW_USER_TICKET", settings, System.getProperty("user.dir"), System.getProperty("user.dir"), new String[]{"*.js", "*.txt"}, (String)triggerFiles.get("NEW_USER_TICKET"));
                break;
            }
            case "helpdesk.main.db.hds": {
                DatabaseConfigInfoList list = HDConfigStructureProvider.getDatabaseConfigInfoList(settings);
                DatabaseConfigInfo hds = this.getHDS(list, settings);
                this.addSelectTo(configProperties, "HDSTreiber", hds.getDriver().name(), "SimpleText", settings, new ArrayList<LocalizedKey>(){
                    {
                        this.add(new LocalizedKey("inetdae7", "MS SQL Server"));
                        this.add(new LocalizedKey("mysql", "MySQL"));
                        this.add(new LocalizedKey("inetora", "Oracle"));
                    }
                });
                configProperties.add(HDConfigStructureProvider.propWith(configProperties.size() * 100, "SelectEdit", this.translate(settings, "DatabaseHost", new Object[0]), "HDShostmssql", hds.getHost(), ""));
                configProperties.add(HDConfigStructureProvider.propWith(configProperties.size() * 100, "SimpleText", this.translate(settings, "DatabaseHost", new Object[0]), "HDShost", hds.getHost(), ""));
                configProperties.add(HDConfigStructureProvider.propWith(configProperties.size() * 100, "SimpleText", this.translate(settings, "Port_oder_Instanz", new Object[0]), "HDSportmssql", DatabaseConfigInfo.DatabaseType.inetdae7.equals((Object)hds.getDriver()) ? hds.getPort() : "", "1433"));
                configProperties.add(HDConfigStructureProvider.propWith(configProperties.size() * 100, "SimpleText", this.translate(settings, "Port", new Object[0]), "HDSportmysql", DatabaseConfigInfo.DatabaseType.mysql.equals((Object)hds.getDriver()) ? hds.getPort() : "", "3306"));
                configProperties.add(HDConfigStructureProvider.propWith(configProperties.size() * 100, "SimpleText", this.translate(settings, "Port", new Object[0]), "HDSportoracle", DatabaseConfigInfo.DatabaseType.inetora.equals((Object)hds.getDriver()) ? hds.getPort() : "", "1521"));
                this.addTo(configProperties, "HDSODBCSource", "SimpleText", hds.getCatalog(), settings);
                this.addTo(configProperties, "HDSCatalog", "SimpleText", hds.getCatalog(), settings);
                this.addTo(configProperties, "HDSSID", "SimpleText", hds.getSid(), settings);
                if (advanced) {
                    String defaultURL = hds.getCustomUrl() != null && !hds.getCustomUrl().isEmpty() ? "" : hds.getUrl();
                    this.addTo(configProperties, "HDSURL", "SimpleText", hds.getCustomUrl(), settings, defaultURL);
                }
                this.addTo(configProperties, "HDSBenutzername", "SimpleText", hds.getUser(), settings);
                this.addTo(configProperties, "HDSPasswort", "Password", hds.getDecodedPassword(), settings);
                break;
            }
            case "helpdesk.main.db.main": {
                configProperties.add((ConfigProperty)new DatabaseConfigInfoListConfigProperty(settings, t -> this.translate(settings, t)));
                break;
            }
            case "helpdesk.main.db.ldap": {
                configProperties.add((ConfigProperty)new LdapConnectionInfoListConfigProperty(settings, t -> this.translate(settings, t)));
                break;
            }
            case "helpdesk.email.automails.dispatcher": {
                this.addTo(configProperties, HDConfigKeys.MAIL_ANFRAGE_DISP, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_MAILEINGANG_DISP, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_MANU_ESCA_DISP, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_AUTO_ESCA_DISP, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_DEADLINE_DISP, settings);
                ConfigProperty columns = new ConfigProperty(0, "", "SimpleText", null, null, null, null);
                ConfigAction[] emailToDispacherActions = new ConfigAction[]{new ConfigAction(this.translate(settings, "email.to.dispatcher.add", new Object[0]))};
                configProperties.add(new ConfigProperty(configProperties.size() * 100, "email.to.dispatcher.explanation", "KeyLabel", null, (Object)this.translate(settings, "email.to.dispatcher.explanation", new Object[0]), null, null));
                this.addTableTo(configProperties, HDConfigKeys.MAILTO_DISPATCHER.getKey(), "SimpleText", settings, this.getValuesFor(HDConfigKeys.MAILTO_DISPATCHER, settings), emailToDispacherActions, new ConfigProperty[]{columns});
                break;
            }
            case "helpdesk.email.automails.resource": {
                this.addTo(configProperties, "emailToResource.title_label.left", "KeyLabel", this.translate(settings, "emailToResource.title_label.right", new Object[0]), settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_AUTORISIERUNG_RES, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_MAILEINGANG_RES, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_WIEDERVORLAGE_RES, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_MANU_ESCA_NEWRES, settings);
                this.addTo(configProperties, HDConfigKeys.AUTOMAIL_WHEN_YELLOW_ESCALATION_THRESHOLD_PASSED, settings);
                this.addTo(configProperties, HDConfigKeys.AUTOMAIL_WHEN_RED_ESCALATION_THRESHOLD_PASSED, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_AUTO_ESCA_NEWRES, settings);
                this.addTo(configProperties, HDConfigKeys.AUTOMAIL_WHEN_YELLOW_DEADLINE_THRESHOLD_PASSED, settings);
                this.addTo(configProperties, HDConfigKeys.AUTOMAIL_WHEN_RED_DEADLINE_THRESHOLD_PASSED, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_DEADLINE_RES, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_RESOURCES_DEF_ABSENDER, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_RESOURCES_DEF_ABSENDER_NAME, settings);
                break;
            }
            case "helpdesk.email.automails.user": {
                this.addTo(configProperties, "emailToUsers.title_label.left", "KeyLabel", this.translate(settings, "emailToUsers.title_label.right", new Object[0]), settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_AUTORISIERUNG_USER, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_BEENDEN_USER, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_ANFRAGEN_USER, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_USERS_DEF_ABSENDER, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_USERS_DEF_ABSENDER_NAME, settings);
                break;
            }
            case "helpdesk.automails.andere": {
                if (!advanced) break;
                this.addSelectTo(configProperties, HDConfigKeys.MAIL_FORMAT.getKey(), settings.getValue(HDConfigKeys.MAIL_FORMAT), "SimpleText", settings, new ArrayList<LocalizedKey>(){
                    {
                        this.add(new LocalizedKey("html", HDConfigStructureProvider.this.translate(settings, "HTML", new Object[0])));
                        this.add(new LocalizedKey("text", HDConfigStructureProvider.this.translate(settings, "PlainText", new Object[0])));
                    }
                });
                this.addTo(configProperties, ConfigKey.SERVER_URL, settings);
                this.addSelectTo(configProperties, HDConfigKeys.SUBTEMPLATE_ORDER.getKey(), String.valueOf(settings.getValue(HDConfigKeys.SUBTEMPLATE_ORDER)), "SimpleText", settings, this.getSubtemplateOrderValues(settings));
                break;
            }
            case "helpdesk.email.senden.client": {
                this.addBitMaskTo(configProperties, HDConfigKeys.CLIENT_START_OPTION, settings, 524288);
                this.addTo(configProperties, HDConfigKeys.SPERRLIST, settings, this.translate(settings, "sperrlist.example", new Object[0]));
                break;
            }
            case "helpdesk.email.senden.client.senden.reihenfolge": {
                this.addBitMaskTo(configProperties, HDConfigKeys.CLIENT_START_OPTION, settings, 0x10000000);
                MailSenderOrderConfigUtils.addSenderOrderSelects(this, configProperties, settings);
                this.addTo(configProperties, HDConfigKeys.MAIL_SENDER_ADD_ALIAS, settings);
                break;
            }
            case "helpdesk.email.senden.mailHeaders": {
                if (!advanced) break;
                ConfigAction[] emailHeaderActions = new ConfigAction[]{new ConfigAction(this.translate(settings, "email.send.header.add", new Object[0]))};
                this.addTableTo(configProperties, HDConfigKeys.OUTGOING_MAIL_HEADERS.getKey(), "SimpleText", settings, this.getValuesFor(HDConfigKeys.OUTGOING_MAIL_HEADERS, settings), emailHeaderActions, this.getConfigPropertiesFor(HDConfigKeys.OUTGOING_MAIL_HEADERS, settings));
                break;
            }
            case "helpdesk.email.senden.resToAbsender": {
                if (!advanced) break;
                ConfigAction[] emailResourceActions = new ConfigAction[]{new ConfigAction(this.translate(settings, "email.send.resource.add", new Object[0]))};
                this.addTableTo(configProperties, HDConfigKeys.MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP.getKey(), "SimpleText", settings, this.getValuesFor(HDConfigKeys.MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP, settings), emailResourceActions, this.getConfigPropertiesFor(HDConfigKeys.MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP, settings));
                break;
            }
            case "helpdesk.email.einlesen.main": {
                ArrayList<UnitConfigProperty.Unit> units = new ArrayList<UnitConfigProperty.Unit>();
                units.add(new UnitConfigProperty.Unit(1.0, this.translate(settings, "mail.timer.minutes", new Object[0])));
                units.add(new UnitConfigProperty.Unit(0.016666666666666666, this.translate(settings, "mail.timer.hours", new Object[0])));
                this.addUnitTo(configProperties, HDConfigKeys.MAIL_TIMER, settings, units);
                this.addTo(configProperties, HDConfigKeys.MAIL_USE_RECEIVED_DATE, settings);
                this.addTableTo(configProperties, HDConfigKeys.EMAIL_FILE_FILTER.getKey(), "SimpleText", settings, this.getValuesFor(HDConfigKeys.EMAIL_FILE_FILTER, settings), new ConfigAction[]{new ConfigAction(this.translate(settings, "email.filefilter.add", new Object[0]))}, this.getConfigPropertiesFor(HDConfigKeys.EMAIL_FILE_FILTER, settings));
                break;
            }
            case "helpdesk.email.einlesen.internal": {
                this.addTo(configProperties, "email.internaladdresses.hint", "Label", settings);
                ArrayList<LocalizedKey> optionList = new ArrayList<LocalizedKey>();
                optionList.add(new LocalizedKey("false", this.translate(settings, "email.internaladdresses.blacklistoption", new Object[0])));
                optionList.add(new LocalizedKey("true", this.translate(settings, "email.internaladdresses.whitelistoption", new Object[0])));
                this.addSelectTo(configProperties, HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_IS_WHITELIST.getKey(), settings.getValue(HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_IS_WHITELIST), "SimpleText", settings, optionList);
                this.addTableTo(configProperties, HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_LIST.getKey(), "SimpleText", settings, this.getValuesFor(HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_LIST, settings), new ConfigAction[]{new ConfigAction(this.translate(settings, "email.internaladdresses.add", new Object[0]))}, this.getConfigPropertiesFor(HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_LIST, settings));
                break;
            }
            case "helpdesk.email.einlesen.main.tags": {
                this.addTo(configProperties, HDConfigKeys.PARAM_START_TAG, settings, this.translate(settings, "paramstarttagexample", new Object[0]));
                this.addTo(configProperties, HDConfigKeys.PARAM_END_TAG, settings, this.translate(settings, "paramendtagexample", new Object[0]));
                break;
            }
            case "helpdesk.email.accounts.main": {
                this.addTo(configProperties, HDConfigKeys.MAIL_ACCOUNTS_DISABLED, settings);
                configProperties.add((ConfigProperty)new EmailAccountListConfigProperty(configProperties.size() * 100, advanced, settings, this.connectionFactory, t -> this.translate(settings, t)));
                if (!advanced) break;
                this.addTo(configProperties, HDConfigKeys.RES_MAIL_NO_STATUS_CHANGED, settings);
                break;
            }
            case "helpdesk.main.general.main": {
                this.addTo(configProperties, HDConfigKeys.TICKET_ID_PREFIX, settings, this.translate(settings, "TicketIDprefixexample", new Object[0]));
                this.addTo(configProperties, HDConfigKeys.TICKET_ID_SUFFIX, settings, this.translate(settings, "TicketIDsuffixexample", new Object[0]));
                if (!advanced) break;
                ConfigAction[] emailReadActions = new ConfigAction[]{new ConfigAction(this.translate(settings, "email.read.add", new Object[0]))};
                this.addTableTo(configProperties, HDConfigKeys.TICKET_ID_DEF_LIST.getKey(), "SimpleText", settings, this.getValuesFor(HDConfigKeys.TICKET_ID_DEF_LIST, settings), emailReadActions, this.getConfigPropertiesFor(HDConfigKeys.TICKET_ID_DEF_LIST, settings));
                this.addTo(configProperties, HDConfigKeys.TICKET_ID_SERVER_UID, settings);
                this.addTo(configProperties, HDConfigKeys.TICKET_ID_FIRST, settings);
                this.addSelectTo(configProperties, HDConfigKeys.FOREIGN_KEY_COLUMN.getKey(), this.normalizeFieldNames(settings, HDConfigKeys.FOREIGN_KEY_COLUMN), "SimpleText", settings, this.getForeignKeyColumnValues(settings.getLocale().getLanguage()));
                break;
            }
            case "helpdesk.main.citrix.main": {
                this.addTo(configProperties, HDConfigKeys.CLIENT_HOSTNAME, settings);
                this.addTo(configProperties, HDConfigKeys.CLIENT_CONFIG_FILE, settings);
                break;
            }
            case "helpdesk.main.jtapi.main.title.label": {
                this.addTo(configProperties, "jtapi.title_label", "Label", settings);
                break;
            }
            case "helpdesk.main.jtapi.main": {
                this.addTo(configProperties, HDConfigKeys.JTAPI_PROVIDER, settings);
                this.addTo(configProperties, HDConfigKeys.JTAPI_PEER, settings);
                this.addTo(configProperties, HDConfigKeys.JTAPI_NATIONALVW, settings, "+49");
                this.addTo(configProperties, HDConfigKeys.JTAPI_LOCALVW, "FixNumber", settings, this.translate(settings, "localVW.example", new Object[0]));
                this.addTo(configProperties, HDConfigKeys.JTAPI_BASIS_RUF_NR, "FixNumber", settings, this.translate(settings, "basis.placeholder", new Object[0]));
                this.addTo(configProperties, HDConfigKeys.JTAPI_DISPATCHERS_ONLY, settings);
                break;
            }
        }
    }

    void addSelectBox(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, String value, @Nonnull String type, @Nonnull ConfigStructureSettings settings, @Nonnull List<LocalizedKey> options) {
        super.addSelectTo(configProperties, key, value, type, settings, options);
    }

    private String translate(ConfigStructureSettings settings, String[] t) {
        if (t != null && t.length > 0) {
            if (t.length == 1) {
                return this.translate(settings, t[0], new Object[0]);
            }
            return this.translate(settings, t[0], Arrays.copyOfRange(t, 1, t.length));
        }
        return null;
    }

    private String getKeyTimeOptionType(String key) {
        if (key.length() == 0) {
            return "0";
        }
        return key.substring(0, 1);
    }

    private DatabaseConfigInfo getHDS(DatabaseConfigInfoList list, ConfigStructureSettings settings) {
        DatabaseConfigInfo hds = list.get("HDS");
        if (hds == null) {
            hds = new DatabaseConfigInfo();
            hds.setDbName("HDS");
            list.add(hds);
        }
        return hds;
    }

    static DatabaseConfigInfoList getDatabaseConfigInfoList(ConfigStructureSettings settings) {
        DatabaseConfigInfoList list;
        HashMap[] changedValue = (HashMap[])settings.getChangedValue(HDConfigKeys.DB_CONFIGS, HashMap[].class);
        if (changedValue == null) {
            String dbConfigs = settings.getValue(HDConfigKeys.DB_CONFIGS);
            list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        } else {
            DatabaseConfigInfo hds;
            list = DatabaseConfigInfoListConfigProperty.convertToList(changedValue);
            String originalValue = settings.getOriginalValue(HDConfigKeys.DB_CONFIGS);
            if (originalValue != null && (hds = ((DatabaseConfigInfoList)new Json().fromJson(originalValue, DatabaseConfigInfoList.class)).get("HDS")) != null) {
                list.add(hds);
            }
        }
        return list;
    }

    private LdapConnectionInfoMap getLdapConnectionInfos(ConfigStructureSettings settings) {
        LdapConnectionInfoMap map;
        HashMap[] changedValue = (HashMap[])settings.getChangedValue(HDConfigKeys.LDAP_CONNECTION_INFOS, HashMap[].class);
        if (changedValue == null) {
            String dbConfigs = settings.getValue(HDConfigKeys.LDAP_CONNECTION_INFOS);
            map = (LdapConnectionInfoMap)new Json().fromJson(dbConfigs, LdapConnectionInfoMap.class);
        } else {
            map = LdapConnectionInfoListConfigProperty.convertToMap(changedValue);
        }
        return map;
    }

    static List<LocalizedKey> getColumnValues(@Nonnull String lang, List<String> requestedColumns) {
        ServerDataConnector sdc = (ServerDataConnector)ServerPluginManager.getInstance().getSingleInstance(ServerDataConnector.class);
        FieldInformation fields = null;
        try {
            fields = sdc.getFieldInformation(lang);
        }
        catch (ServerDataException e) {
            HDLogger.error(e);
        }
        ArrayList<LocalizedKey> columnValues = new ArrayList<LocalizedKey>();
        for (String alias : requestedColumns) {
            Field field = AliasMapper.getFieldForAlias(alias);
            String displayName = fields != null && field != null ? fields.getFieldDisplayName(field.name()) : alias;
            columnValues.add(new LocalizedKey(alias, displayName));
        }
        columnValues.sort((o1, o2) -> {
            String lab1 = o1.getLabel().toUpperCase();
            String lab2 = o2.getLabel().toUpperCase();
            return lab1.compareTo(lab2);
        });
        return columnValues;
    }

    private String normalizeFieldNames(@Nonnull ConfigStructureSettings settings, @Nonnull ConfigKey key) {
        String keyValue = String.valueOf(settings.getValue(key));
        return AliasMapper.getAliasForFieldKey(keyValue);
    }

    private List<LocalizedKey> getDeviceKeyColumnValues(@Nonnull String lang) {
        ArrayList<String> requestedColumns = new ArrayList<String>(){
            {
                this.add("geraet1");
                this.add("geraet2");
                this.add("geraet3");
                this.add("geraet4");
                this.add("geraet5");
                this.add("geraet6");
                this.add("geraet7");
                this.add("geraet8");
                this.add("geraet9");
            }
        };
        List<LocalizedKey> dviceColumnValues = HDConfigStructureProvider.getColumnValues(lang, (List<String>)requestedColumns);
        dviceColumnValues.add(0, new LocalizedKey("", ""));
        return dviceColumnValues;
    }

    private List<LocalizedKey> getForeignKeyColumnValues(@Nonnull String lang) {
        ArrayList<String> requestedColumns = new ArrayList<String>(){
            {
                this.add("auftrag1");
                this.add("auftrag2");
                this.add("auftrag3");
                this.add("auftrag4");
                this.add("auftrag5");
                this.add("auftrag6");
                this.add("auftrag7");
            }
        };
        List<LocalizedKey> foreignKeyColumnValues = HDConfigStructureProvider.getColumnValues(lang, (List<String>)requestedColumns);
        foreignKeyColumnValues.add(0, new LocalizedKey("", ""));
        return foreignKeyColumnValues;
    }

    private List<LocalizedKey> getSubtemplateOrderValues(final ConfigStructureSettings settings) {
        return new ArrayList<LocalizedKey>(){
            {
                this.add(new LocalizedKey("", HDConfigStructureProvider.this.translate(settings, "Vonaltnachneu", new Object[0])));
                this.add(new LocalizedKey("LastTop", HDConfigStructureProvider.this.translate(settings, "Vonneunachalt", new Object[0])));
                this.add(new LocalizedKey("LastOnly", HDConfigStructureProvider.this.translate(settings, "NurdenneuestenSchritt", new Object[0])));
            }
        };
    }

    private ConfigProperty propWith(String type, String label) {
        return new ConfigProperty(0, "", type, label, null, null, null);
    }

    private static ConfigProperty propWith(int sortID, String type, String label, String keyName, String value, String placeholder) {
        return new ConfigProperty(sortID, keyName, type, label, (Object)value, null, placeholder);
    }

    private ConfigProperty[] getConfigPropertiesFor(ConfigKey key, final ConfigStructureSettings settings) {
        switch (key.getKey()) {
            case "mail.resourceToAbsenderAndAliasMap": {
                return new ConfigProperty[]{new SelectConfigProperty(123, "Resource", "SimpleText", this.translate(settings, "Resource", new Object[0]), null, this.translate(settings, "Resource", new Object[0]), LocalizedKeyListFactory.getResourceNames(this.connectionFactory)), this.propWith("SimpleText", this.translate(settings, "Absender", new Object[0])), this.propWith("SimpleText", this.translate(settings, "Alias", new Object[0]))};
            }
            case "TicketIDdefList": {
                return new ConfigProperty[]{new ConfigProperty(0, "", "SimpleText", null, null, null, "")};
            }
            case "incomingmailheaders": {
                return new ConfigProperty[]{this.propWith("SimpleText", this.translate(settings, "Mailheader", new Object[0]))};
            }
            case "mailheaders": {
                return new ConfigProperty[]{this.propWith("SimpleText", this.translate(settings, "Mailheader", new Object[0])), this.propWith("SimpleText", this.translate(settings, "Wert", new Object[0]))};
            }
            case "email.filefilter": {
                return new ConfigProperty[]{this.propWith("SimpleText", this.translate(settings, "attachmentfiletype", new Object[0])), new SelectConfigProperty(999, "attachmentfilebehavior", "SimpleText", this.translate(settings, "attachmentfilebehavior", new Object[0]), (Object)"none", this.translate(settings, "attachmentfilebehaviorTooltip", new Object[0]), (List)new ArrayList<LocalizedKey>(){
                    {
                        this.add(new LocalizedKey("none", HDConfigStructureProvider.this.translate(settings, "attachmentfilebehavior.none", new Object[0])));
                        this.add(new LocalizedKey("read", HDConfigStructureProvider.this.translate(settings, "attachmentfilebehavior.read", new Object[0])));
                        this.add(new LocalizedKey("open", HDConfigStructureProvider.this.translate(settings, "attachmentfilebehavior.open", new Object[0])));
                        this.add(new LocalizedKey("full", HDConfigStructureProvider.this.translate(settings, "attachmentfilebehavior.full", new Object[0])));
                    }
                })};
            }
            case "email.internaladdresses": {
                return new ConfigProperty[]{this.propWith("SimpleText", this.translate(settings, "internaladdress", new Object[0]))};
            }
        }
        return new ConfigProperty[0];
    }

    /*
     * Exception decompiling
     */
    List<String[]> getValuesFor(ConfigKey key, ConfigStructureSettings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD", "PATH_TRAVERSAL_IN"}, justification="logo file only set by the admin")
    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        String logoFile;
        ConfigValidator validator = new ConfigValidator(messages, settings);
        if (categoryKey == null) return;
        if (categoryKey.equals("dbconfig.new")) {
            String dbName = settings.getChangedValue("dbName");
            if (!DatabaseConfigInfo.DatabaseType.inetora.name().equals(settings.getValue("driver"))) {
                validator.checkNotEmpty("dbName");
            }
            if (!"HDS".equals(dbName)) return;
            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "nichtHDS", new Object[0]), "dbName"));
            return;
        }
        if (categoryKey.equals(CATEGORY_DB)) {
            void var10_34;
            HashSet<String> allDbAliases;
            HashMap[] changedValue = (HashMap[])settings.getChangedValue(HDConfigKeys.DB_CONFIGS, HashMap[].class);
            if (changedValue != null) {
                DatabaseConfigInfoList dbConfigInfos = DatabaseConfigInfoListConfigProperty.convertToList(changedValue);
                allDbAliases = new HashSet<String>();
                for (DatabaseConfigInfo databaseConfigInfo : dbConfigInfos) {
                    if (!allDbAliases.add(databaseConfigInfo.getDbName())) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "NichtmehralseinmaldasgleicheDBAliasbitte", new Object[0]), HDConfigKeys.DB_CONFIGS.getKey()));
                    }
                    if (databaseConfigInfo.getDbName() != null && !databaseConfigInfo.getDbName().isEmpty()) continue;
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "NameNotwendig", new Object[0]), HDConfigKeys.DB_CONFIGS.getKey()));
                }
            }
            if ((changedValue = (HashMap[])settings.getChangedValue(HDConfigKeys.LDAP_CONNECTION_INFOS, HashMap[].class)) != null) {
                LdapConnectionInfoMap ldapConfigInfos = LdapConnectionInfoListConfigProperty.convertToMap(changedValue);
                allDbAliases = new HashSet();
                for (Map.Entry entry : ldapConfigInfos.entrySet()) {
                    String name = ((LdapConnectionInfo)entry.getValue()).getName();
                    if (!allDbAliases.add(name)) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "NichtmehralseinmaldasgleicheDBAliasbitte", new Object[0]), HDConfigKeys.LDAP_CONNECTION_INFOS.getKey()));
                    }
                    if (name != null && !name.isEmpty()) continue;
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "NameNotwendig", new Object[0]), HDConfigKeys.LDAP_CONNECTION_INFOS.getKey()));
                }
            }
            DatabaseConfigInfoList list = HDConfigStructureProvider.getDatabaseConfigInfoList(settings);
            DatabaseConfigInfo hds = this.getHDS(list, settings);
            String originalValue = settings.getOriginalValue(HDConfigKeys.DB_CONFIGS);
            if (originalValue != null) {
                DatabaseConfigInfoList originalList = (DatabaseConfigInfoList)new Json().fromJson(originalValue, DatabaseConfigInfoList.class);
                DatabaseConfigInfo databaseConfigInfo = originalList.get("HDS");
            } else {
                Object var10_33 = null;
            }
            String msg2 = this.testHDSConnection(settings, hds);
            if (hds.getCustomUrl() != null && !hds.getCustomUrl().isEmpty() && !hds.getCustomUrl().contains(":" + hds.getDriver().name() + ":")) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "HDSCustomURLIssue", new Object[0]), "HDSURL"));
            } else if (msg2 != null) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(settings, "HDSConnectionSettingsArentOKAreYouSure", new Object[0]), HDConfigKeys.DB_CONFIGS));
            }
            if (hds.equals(var10_34)) return;
            validator.checkNeedRestart(HDConfigKeys.DB_CONFIGS, "abc", "def");
            return;
        }
        if (categoryKey.equals(CATEGORY_EMAIL_SENDEN)) {
            String[][] changedValue = (String[][])settings.getChangedValue("mail.resourceToAbsenderAndAliasMap", String[][].class);
            if (changedValue != null && Arrays.asList(changedValue).stream().filter(row -> {
                if (row[1] == null || row[1].isEmpty()) {
                    return true;
                }
                validator.validateEmail(row[1], "mail.resourceToAbsenderAndAliasMap");
                return false;
            }).count() > 0L) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "AbsenderBrauchtEmail", new Object[0]), "mail.resourceToAbsenderAndAliasMap"));
            }
            validator.validateEmails(HDConfigKeys.SPERRLIST);
            String[][] mailheaders = (String[][])settings.getChangedValue("mailheaders", String[][].class);
            if (mailheaders == null) return;
            HashSet<String> allKeys = new HashSet<String>();
            for (String[] row2 : mailheaders) {
                if (allKeys.add(row2[0])) continue;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "NichtMehrereGleicheHeaderKeysBitte", new Object[0]), "mailheaders"));
            }
            return;
        }
        if (categoryKey.equals(CATEGORY_EMAIL_EINLESEN)) {
            validator.validateStringLength(HDConfigKeys.TICKET_ID_SERVER_UID, 3, 50);
            validator.validateUnitNumberRangeWholeNumbers(HDConfigKeys.MAIL_TIMER, 1L, 120L, "m");
            String startTag = settings.getValue(HDConfigKeys.PARAM_START_TAG);
            String endTag = settings.getValue(HDConfigKeys.PARAM_END_TAG);
            if (startTag != null && startTag.length() > 0 && (endTag == null || endTag.length() == 0) || endTag != null && endTag.length() > 0 && (startTag == null || startTag.length() == 0)) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "EntwederBeideOderKeine", new Object[0]), HDConfigKeys.PARAM_START_TAG));
                return;
            } else {
                if (startTag == null || endTag == null || !startTag.equals(endTag) || startTag.length() <= 0) return;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "NichtGleich", new Object[0]), HDConfigKeys.PARAM_START_TAG));
            }
            return;
        }
        if (categoryKey.equals(CATEGORY_EMAIL_AUTOMAILS)) {
            String defAbsenderRes;
            String defAbsender;
            String originalValue;
            String[][] changedValue;
            if (validator.validateHttpURL(ConfigKey.SERVER_URL) && (changedValue = settings.getChangedValue(ConfigKey.SERVER_URL.getKey())) != null && ((originalValue = settings.getOriginalValue(ConfigKey.SERVER_URL)) == null || !originalValue.equals(changedValue))) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(settings, "DoNotChangeServerURLWithoutKnowingWhatYouAreDoingMister", new Object[0]), HDConfigKeys.PARAM_START_TAG));
            }
            if ((changedValue = (String[][])settings.getChangedValue(HDConfigKeys.MAILTO_DISPATCHER.getKey(), String[][].class)) != null) {
                Arrays.asList(changedValue).stream().forEach(row -> validator.validateEmail(row[0], HDConfigKeys.MAILTO_DISPATCHER.getKey()));
            }
            if ((defAbsender = settings.getValue(HDConfigKeys.MAIL_USERS_DEF_ABSENDER)) != null && defAbsender.trim().length() > 0) {
                validator.validateEmail(defAbsender, HDConfigKeys.MAIL_USERS_DEF_ABSENDER.getKey());
            }
            if ((defAbsenderRes = settings.getValue(HDConfigKeys.MAIL_RESOURCES_DEF_ABSENDER)) == null || defAbsenderRes.trim().length() <= 0) return;
            validator.validateEmail(defAbsenderRes, HDConfigKeys.MAIL_RESOURCES_DEF_ABSENDER.getKey());
            return;
        }
        if (categoryKey.equals(CATEGORY_JTAPI)) {
            Object nationalVW = settings.getValue(HDConfigKeys.JTAPI_NATIONALVW);
            if (nationalVW == null || ((String)nationalVW).trim().length() <= 0) return;
            if (!((String)nationalVW).startsWith("+")) {
                nationalVW = "+" + (String)nationalVW;
            }
            try {
                Integer.valueOf(((String)nationalVW).substring(1));
                return;
            }
            catch (NumberFormatException exc) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "IntVWNotNumber", new Object[0]), HDConfigKeys.JTAPI_NATIONALVW));
            }
            return;
        }
        if (!categoryKey.equals("category.companyinfo") || (logoFile = settings.getValue(HDConfigKeys.LOGO_FILE)).trim().length() <= 0) return;
        if (logoFile.startsWith("http:") || logoFile.startsWith("https:")) {
            try {
                URL logoURL = new URL(logoFile);
                if (((HttpURLConnection)logoURL.openConnection()).getResponseCode() == 200) return;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "CannotConnect", new Object[0]), HDConfigKeys.LOGO_FILE.getKey()));
                return;
            }
            catch (Exception e) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, e.getMessage(), HDConfigKeys.LOGO_FILE.getKey()));
            }
            return;
        }
        try {
            Properties values;
            Path path = Paths.get(logoFile, new String[0]);
            if (!path.isAbsolute()) {
                path = !path.toFile().toString().toLowerCase().replace('\\', '/').startsWith("client/images") ? AppDataLocation.getClientImageDirectoryPath().resolve(path) : AppDataLocation.getBaseLocationPath().resolve(path);
            }
            messages.removeIf(msg -> msg.getKey().equals(HDConfigKeys.LOGO_FILE.getKey()));
            if (!validator.checkFileExists(path.toAbsolutePath().toString(), HDConfigKeys.LOGO_FILE.getKey()) || (values = settings.getValues()) == null) return;
            try {
                path = AppDataLocation.getBaseLocationPath().relativize(path);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            values.setProperty(HDConfigKeys.LOGO_FILE.getKey(), path.toString());
            return;
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="only set by admin")
    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        if (key.startsWith(HDConfigKeys.CLIENT_START_OPTION.getKey() + ".")) {
            String bitmask = key.substring((HDConfigKeys.CLIENT_START_OPTION.getKey() + ".").length());
            key = HDConfigKeys.CLIENT_START_OPTION.getKey();
            boolean booleanValue = Boolean.valueOf((String)value);
            int toOrToValue = Integer.parseInt(bitmask);
            if (Arrays.asList(FLIPPED_BITS).contains(toOrToValue)) {
                booleanValue = !booleanValue;
            }
            Integer currValue = null;
            try {
                currValue = Integer.valueOf(settings.getOriginalValue(HDConfigKeys.CLIENT_START_OPTION));
            }
            catch (NumberFormatException exc) {
                currValue = Integer.valueOf(HDConfigKeys.CLIENT_START_OPTION.getDefault());
            }
            value = booleanValue ? String.valueOf(currValue | toOrToValue) : ((currValue & toOrToValue) == toOrToValue ? String.valueOf(currValue - toOrToValue) : String.valueOf(currValue));
            settings.save(key, (String)value);
        } else {
            if (key.equals(HDConfigKeys.CLIENT_EFFORTTIME_CONFIG.getKey())) {
                int clientbitmask = 0x800000;
                String clientoptionskey = HDConfigKeys.CLIENT_START_OPTION.getKey();
                boolean booleanValue = "0".equals(value);
                Integer currValue = null;
                try {
                    currValue = Integer.valueOf(settings.getOriginalValue(HDConfigKeys.CLIENT_START_OPTION));
                }
                catch (NumberFormatException exc) {
                    currValue = Integer.valueOf(HDConfigKeys.CLIENT_START_OPTION.getDefault());
                }
                String clientOptionsValue = currValue.toString();
                clientOptionsValue = booleanValue ? String.valueOf(currValue | clientbitmask) : ((currValue & clientbitmask) == clientbitmask ? String.valueOf(currValue - clientbitmask) : String.valueOf(currValue));
                settings.save(clientoptionskey, clientOptionsValue);
                settings.save(key, (String)value);
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals(HDConfigKeys.MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP.getKey())) {
                String[][] rows = (String[][])new Json().fromJson((String)value, String[][].class);
                MailResourceToAbsenderAndAliasMap m = new MailResourceToAbsenderAndAliasMap();
                Arrays.asList(rows).stream().forEach(r -> m.addEntry(r[0], r[1], r[2]));
                settings.save(key, m.toString());
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals(HDConfigKeys.CLIENT_ENDUSER_VISIBLE_TICKET_FIELDS.getKey())) {
                String[][] rows = (String[][])new Json().fromJson((String)value, String[][].class);
                List stringList = Arrays.asList(rows).stream().map(strArray -> strArray[0]).distinct().collect(Collectors.toList());
                settings.save(key, new Json().toJson(stringList));
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals(HDConfigKeys.MAILTO_DISPATCHER.getKey())) {
                String[][] rows = (String[][])new Json().fromJson((String)value, String[][].class);
                StringBuilder sb = new StringBuilder();
                Arrays.asList(rows).stream().forEach(row -> sb.append(row[0]).append(";"));
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                settings.save(key, sb.toString());
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals(HDConfigKeys.MAIL_ACCOUNTS.getKey())) {
                EmailAccountList emailAccountList = EmailAccountListConfigProperty.convertToList((String)value, t -> this.translate(settings, t));
                settings.save(HDConfigKeys.MAIL_ACCOUNTS, new Json().toJson((Object)emailAccountList));
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals(HDConfigKeys.DB_CONFIGS.getKey())) {
                DatabaseConfigInfoList list = HDConfigStructureProvider.getDatabaseConfigInfoList(settings);
                settings.save(HDConfigKeys.DB_CONFIGS, new Json().toJson((Object)list));
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals(HDConfigKeys.LDAP_CONNECTION_INFOS.getKey())) {
                LdapConnectionInfoMap map = this.getLdapConnectionInfos(settings);
                settings.save(HDConfigKeys.LDAP_CONNECTION_INFOS, new Json().toJson((Object)map));
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals(HDConfigKeys.FOREIGN_KEY_COLUMN.getKey())) {
                if ("".equals(value)) {
                    settings.save(HDConfigKeys.FOREIGN_KEY_COLUMN, null);
                    return ConfigStructure.SaveState.SAVE;
                }
            } else {
                if (key.startsWith("HDS")) {
                    key = key.substring(3);
                    DatabaseConfigInfoList list = HDConfigStructureProvider.getDatabaseConfigInfoList(settings);
                    DatabaseConfigInfo hds = this.getHDS(list, settings);
                    this.setDbConfigInfoValueForKey(key, (String)value, hds);
                    if (key.equalsIgnoreCase("Treiber")) {
                        Set<Object> changedKeys = settings.getValues().keySet();
                        if (changedKeys.stream().filter(s -> s.toString().toLowerCase().contains("port")).count() == 0L) {
                            this.setDbConfigInfoValueForKey("port", "", hds);
                        } else {
                            String portMssql = settings.getValues().getProperty("HDSportmssql");
                            String portOracle = settings.getValues().getProperty("HDSportmssql");
                            String portMysql = settings.getValues().getProperty("HDSportmssql");
                            hds.setPort(portMssql == null ? (portMysql == null ? (portOracle == null ? "" : portOracle) : portMysql) : portMssql);
                        }
                        if (changedKeys.contains("HDShost")) {
                            this.setDbConfigInfoValueForKey("host", settings.getValue("HDShost"), hds);
                        }
                        if (changedKeys.contains("HDShostmssql")) {
                            this.setDbConfigInfoValueForKey("hostmssql", settings.getValue("HDShostmssql"), hds);
                        }
                    }
                    settings.save(HDConfigKeys.DB_CONFIGS, new Json().toJson((Object)list));
                    return ConfigStructure.SaveState.SAVE;
                }
                if (key.startsWith("TRIGGER_")) {
                    key = key.substring("TRIGGER_".length());
                    String v = settings.getValue(HDConfigKeys.TRIGGER_FILES);
                    HashMap map = (HashMap)new Json().fromJson(v, HashMap.class);
                    map.put(key, value);
                    settings.save(HDConfigKeys.TRIGGER_FILES, new Json().toJson((Object)map));
                    ServerUtilities.TRIGGERS.readTriggers(map);
                    return ConfigStructure.SaveState.SAVE;
                }
                if (key.equals(HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_LIST.getKey())) {
                    String[][] rows = (String[][])new Json().fromJson((String)value, String[][].class);
                    ArrayList list = new ArrayList();
                    Arrays.asList(rows).stream().map(row -> row[0]).filter(row -> !row.isEmpty()).distinct().forEach(row -> list.add(row));
                    settings.save(key, new Json().toJson(list));
                    return ConfigStructure.SaveState.SAVE;
                }
                if (key.equals("mailheaders")) {
                    String[][] rows = (String[][])new Json().fromJson((String)value, String[][].class);
                    HashMap result = new HashMap();
                    Arrays.asList(rows).stream().filter(row -> row[0].trim().length() > 0 || row[1].trim().length() > 0).forEach(row -> result.put(row[0], row[1]));
                    settings.save(key, new Json().toJson(result));
                    return ConfigStructure.SaveState.SAVE;
                }
                if (key.equals("email.filefilter")) {
                    String[][] rows = (String[][])new Json().fromJson((String)value, String[][].class);
                    HashMap result = new HashMap();
                    Arrays.asList(rows).stream().filter(row -> row[0].trim().length() > 0 || row[1].trim().length() > 0).forEach(row -> result.put(row[0], row[1]));
                    settings.save(key, new Json().toJson(result));
                    return ConfigStructure.SaveState.SAVE;
                }
                if (key.equals(HDConfigKeys.JTAPI_NATIONALVW.getKey())) {
                    if (value != null && ((String)value).trim().length() > 0 && !((String)value).startsWith("+")) {
                        value = "+" + (String)value;
                        settings.save(key, (String)value);
                        return ConfigStructure.SaveState.SAVE;
                    }
                } else if (key.equals(HDConfigKeys.LOGO_FILE.getKey())) {
                    Path path;
                    if (!(((String)value).trim().length() <= 0 || ((String)value).startsWith("http:") || ((String)value).startsWith("https:") || (path = Paths.get((String)value, new String[0])).isAbsolute() || path.toFile().toString().toLowerCase().replace('\\', '/').startsWith("client/images"))) {
                        path = AppDataLocation.getClientImageDirectoryPath().resolve(path);
                        path = AppDataLocation.getBaseLocationPath().relativize(path);
                        value = path.toString();
                        settings.save(key, (String)value);
                        return ConfigStructure.SaveState.RELOAD;
                    }
                } else if (key.startsWith(HDConfigKeys.MAIL_SENDER_ORDER.getKey())) {
                    MailSenderOrderConfigUtils.saveTo(settings);
                    return ConfigStructure.SaveState.SAVE;
                }
            }
        }
        return ConfigStructure.SaveState.NONE;
    }

    protected void setDbConfigInfoValueForKey(String key, String value, DatabaseConfigInfo hds) {
        if (key.startsWith("port") && "null".equals(value)) {
            return;
        }
        switch (key.toLowerCase()) {
            case "catalog": {
                if (DatabaseConfigInfo.DatabaseType.odbc.equals((Object)hds.getDriver())) break;
                hds.setCatalog(value);
                break;
            }
            case "odbcsource": {
                if (!DatabaseConfigInfo.DatabaseType.odbc.equals((Object)hds.getDriver())) break;
                hds.setCatalog(value);
                break;
            }
            case "benutzername": 
            case "user": {
                hds.setUser(value);
                break;
            }
            case "passwort": 
            case "password": {
                hds.setDecodedPassword(value.toCharArray());
                break;
            }
            case "treiber": 
            case "driver": {
                hds.setDriver(DatabaseConfigInfo.DatabaseType.valueOf(value));
                hds.setPort(null);
                break;
            }
            case "hostmssql": {
                if (!DatabaseConfigInfo.DatabaseType.inetdae7.equals((Object)hds.getDriver())) break;
                hds.setHost(value);
                break;
            }
            case "host": {
                if (DatabaseConfigInfo.DatabaseType.inetdae7.equals((Object)hds.getDriver())) break;
                hds.setHost(value);
                break;
            }
            case "port": {
                hds.setPort(value);
                break;
            }
            case "portmysql": {
                if (!DatabaseConfigInfo.DatabaseType.mysql.equals((Object)hds.getDriver())) break;
                hds.setPort(value);
                break;
            }
            case "portmssql": {
                if (!DatabaseConfigInfo.DatabaseType.inetdae7.equals((Object)hds.getDriver())) break;
                hds.setPort(value);
                break;
            }
            case "portoracle": {
                if (!DatabaseConfigInfo.DatabaseType.inetora.equals((Object)hds.getDriver())) break;
                hds.setPort(value);
                break;
            }
            case "sid": {
                hds.setSid(value);
                break;
            }
            case "url": {
                hds.setCustomUrl(value);
                break;
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        ConditionGenerator g = new ConditionGenerator();
        if (categoryKey.equals(CATEGORY_EMAIL_AUTOMAILS)) {
            ConfigCondition manu = g.createCondition().property(HDConfigKeys.MAIL_MANU_ESCA_DISP).equals().value((Object)"true");
            ConfigCondition auto = g.createCondition().property(HDConfigKeys.MAIL_AUTO_ESCA_DISP).equals().value((Object)"true");
            ConfigCondition anf = g.createCondition().property(HDConfigKeys.MAIL_ANFRAGE_DISP).equals().value((Object)"true");
            ConfigCondition dead = g.createCondition().property(HDConfigKeys.MAIL_DEADLINE_DISP).equals().value((Object)"true");
            ConfigCondition maileingang = g.createCondition().property(HDConfigKeys.MAIL_MAILEINGANG_DISP).equals().value((Object)"true");
            ConfigCondition atLeastOne = g.createCondition().or(new ConfigCondition[]{manu, auto, anf, dead, maileingang});
            actions.add(g.enableActionFor(atLeastOne, HDConfigKeys.MAILTO_DISPATCHER));
            if (!"".equals(settings.getValue(HDConfigKeys.MAIL_HOST))) {
                actions.add(g.visibleActionFor(ConfigCondition.FALSE, PROP_GROUP_AUTOMAIL_WARNING_LABEL));
            }
        } else if (categoryKey.equals(CATEGORY_DB)) {
            ConfigCondition isOracle = g.createCondition().property("HDSTreiber").equals().value((Object)"inetora");
            ConfigCondition isOther = g.createCondition().property("HDSTreiber").equals().value((Object)"other");
            ConfigCondition isODBC = g.createCondition().property("HDSTreiber").equals().value((Object)"odbc");
            ConfigCondition isMysql = g.createCondition().property("HDSTreiber").equals().value((Object)"mysql");
            ConfigCondition isMssql = g.createCondition().property("HDSTreiber").equals().value((Object)"inetdae7");
            ConfigCondition isOtherOrODBCOrMssql = g.createCondition().or(new ConfigCondition[]{isOther, isODBC, isMssql});
            ConfigCondition isOneOfTheThree = g.createCondition().or(new ConfigCondition[]{isMssql, isMysql, isOracle});
            ConfigCondition isAdvanced = advanced ? g.alwaysTrue() : g.alwaysFalse();
            ConfigCondition showURL = g.createCondition().and(new ConfigCondition[]{isOneOfTheThree, isAdvanced});
            actions.add(g.visibleActionFor(g.createCondition().not(isOtherOrODBCOrMssql), "HDShost"));
            actions.add(g.visibleActionFor(isMssql, "HDShostmssql"));
            actions.add(g.visibleActionFor(isMssql, "HDSportmssql"));
            actions.add(g.visibleActionFor(isMysql, "HDSportmysql"));
            actions.add(g.visibleActionFor(isOracle, "HDSportoracle"));
            actions.add(g.visibleActionFor(g.createCondition().not(g.createCondition().or(new ConfigCondition[]{isODBC, isOracle})), "HDSCatalog"));
            actions.add(g.visibleActionFor(isODBC, "HDSODBCSource"));
            actions.add(g.visibleActionFor(g.createCondition().not(isODBC), "HDSBenutzername"));
            actions.add(g.visibleActionFor(g.createCondition().not(isODBC), "HDSPasswort"));
            actions.add(g.visibleActionFor(isOracle, "HDSSID"));
            if (advanced) {
                actions.add(g.visibleActionFor(showURL, "HDSURL"));
            }
        } else if (categoryKey.equals(CATEGORY_EMAIL_SENDEN)) {
            MailSenderOrderConfigUtils.addMailSenderOrderConditions(actions, g);
        }
        super.addConditionsTo(actions, categoryKey, advanced, settings);
    }

    public PairList<String, String> getCategoryVetoes(boolean advanced, ConfigStructureSettings settings) {
        PairList result = new PairList();
        if (!advanced) {
            result.add((Object)"categorygroup.system", (Object)"category.logging");
            result.add((Object)"categorygroup.report", (Object)"category.behavior");
            result.add((Object)"categorygroup.report", (Object)"category.font");
            result.add((Object)"categorygroup.components", (Object)"category.repository");
        }
        result.add((Object)"categorygroup.security", (Object)"category.ipfilter");
        result.add((Object)"categorygroup.security", (Object)"category.reportLocations");
        result.add((Object)"categorygroup.security", (Object)"category.urlParameter");
        result.add((Object)"categorygroup.components", (Object)"category.email");
        return result;
    }

    protected void addBitMaskTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, int bitMask) {
        if (Arrays.asList(FLIPPED_BITS).contains(bitMask)) {
            this.addFlippedBitMaskTo(configProperties, configKey, settings, bitMask);
        } else {
            super.addBitMaskTo(configProperties, configKey, settings, bitMask);
        }
    }

    @Nullable
    public List<LocalizedKey> getSelectValues(@Nonnull String key, String filter, ConfigStructureSettings settings) {
        switch (key) {
            case "fallbackOwner": {
                return this.getUsers(settings, filter);
            }
            case "hostmssql": 
            case "HDShostmssql": {
                if (System.currentTimeMillis() - this.lastScan > 10000L) {
                    this.availableSqlServers = null;
                    this.lastScan = System.currentTimeMillis();
                }
                if (this.availableSqlServers == null) {
                    this.availableSqlServers = SqlServerSearcher.generateList();
                }
                return this.availableSqlServers.stream().filter(dci -> dci.getHost().toLowerCase().startsWith(filter.toLowerCase())).map(dci -> new LocalizedKey(dci.getHost(), dci.getHost())).collect(Collectors.toList());
            }
            case "default.ticket.font.name": {
                GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                String[] familyNames = environment.getAvailableFontFamilyNames();
                ArrayList<LocalizedKey> options = new ArrayList<LocalizedKey>();
                if (familyNames != null && familyNames.length > 0) {
                    for (String font : familyNames) {
                        if (!font.toLowerCase().contains(filter.toLowerCase())) continue;
                        options.add(new LocalizedKey(font, font));
                    }
                } else {
                    options.add(new LocalizedKey(filter, filter));
                }
                return options;
            }
        }
        return super.getSelectValues(key, filter, settings);
    }

    private List<LocalizedKey> getUsers(ConfigStructureSettings settings, String filter) {
        LocalizedKey fallbackOwner;
        boolean fetchDefaultUsers = filter == null || filter.isEmpty();
        UserManager userManager = HelpDeskUserManager.getRecoveryEnabledInstance();
        HashSet<Object> result = new HashSet<Object>();
        String currentGuidValue = settings.getChangedValue("fallbackOwner");
        if (!StringFunctions.isEmpty((String)currentGuidValue) && !StringFunctions.isEmpty((String)(fallbackOwner = (LocalizedKey)new Json().fromJson(currentGuidValue, LocalizedKey.class)).getKey())) {
            result.add(GUID.valueOf((String)fallbackOwner.getKey()));
        }
        result.add(null);
        IndexSearchEngine searchEngine = userManager.getSearchEngine();
        if (fetchDefaultUsers) {
            String accounts = settings.getOriginalValue(HDConfigKeys.MAIL_ACCOUNTS);
            ArrayList emailAccounts = (ArrayList)new Json().fromJson(accounts, EmailAccountList.class);
            Set fallbackOwners = emailAccounts.stream().map(e -> e.getFallbackOwnerGUID()).filter(g -> g != null).collect(Collectors.toSet());
            result.addAll(fallbackOwners);
            SearchCommand active = new SearchCommand("useraccountid", SearchCondition.SearchTermOperator.StartsWith, (Object)"");
            active.setResultLimit(100);
            result.addAll(searchEngine.simpleSearch(active));
        } else {
            SearchCommand command = new TextSearchCommandBuilder(searchEngine, filter).build();
            command.setResultLimit(100);
            result.addAll(searchEngine.simpleSearch(command));
        }
        Comparator<LocalizedKey> sorter = new Comparator<LocalizedKey>(){

            @Override
            public int compare(LocalizedKey o1, LocalizedKey o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        };
        return result.stream().map(e -> {
            if (e == null) {
                return new LocalizedKey("", this.translate(settings, "fallbackOwner.none", new Object[0]));
            }
            UserAccount account = userManager.getUserAccount(e);
            return new LocalizedKey(e.toString(), account == null ? "" : account.getDisplayName());
        }).sorted(sorter).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$getValuesFor$15(ArrayList result, Object value) {
        result.add(new String[]{value != null ? value.toString() : ""});
    }
}

