/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.config.EmailProtocol;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.utils.SecurityUtils;
import com.inet.id.GUID;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Objects;

@JsonData
public class EmailAccount {
    private String account;
    private String password;
    private String from;
    private String fromName;
    private String category = "";
    private Integer categoryId = -1;
    private String noBundles = "*";
    private String template;
    private String errorMessage;
    private String host;
    private int port;
    private EmailProtocol protocol = EmailProtocol.IMAP;
    private boolean ssl;
    private boolean createDomain = true;
    private boolean newUser = true;
    private int priority;
    private String directory;
    private int resID;
    private boolean preventPlainAuth = true;
    private boolean preventNtlmAuth = false;
    private GUID fallbackOwnerGUID;
    private boolean onlyAcceptEmailsForExistingTickets;

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount() {
        return this.account;
    }

    public void setPasswordEncoded(String value) {
        this.password = value;
    }

    public String getPasswordEncoded() {
        return this.password;
    }

    public void setPasswordDecoded(String value) {
        if (value == null) {
            value = "";
        }
        this.password = SecurityUtils.encodePassword(value.toCharArray());
    }

    public String getPasswordDecoded() {
        if (this.password == null || this.password.length() == 0) {
            return "";
        }
        String pwd = this.password;
        try {
            pwd = new String(Base64.getDecoder().decode(this.password.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException ex) {
            HDLogger.debug("Password was not Base64.");
        }
        if (pwd.charAt(0) == '\u0001') {
            char[] chars = pwd.toCharArray();
            for (int i = 1; i < chars.length; ++i) {
                chars[i] = (char)(chars[i] ^ 0x24);
            }
            return new String(chars, 1, chars.length - 1);
        }
        byte[] bytes = pwd.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(bytes[i] ^ 0x24);
        }
        return new String(bytes);
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFromName(String name) {
        this.fromName = name;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setNoBundles(String noBundles) {
        this.noBundles = noBundles;
    }

    public String getNoBundles() {
        return this.noBundles;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setPort(String port) {
        try {
            this.port = port == null || port.isEmpty() ? 0 : Integer.parseInt(port);
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String value) {
        this.host = value;
    }

    public String getHost() {
        return this.host;
    }

    public void setProtocol(String value) {
        if ("true".equals(value) || "".equals(value)) {
            value = EmailProtocol.IMAP.name();
        } else if ("false".equals(value)) {
            value = EmailProtocol.POP3.name();
        }
        try {
            this.protocol = EmailProtocol.valueOf(value);
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
    }

    public EmailProtocol getProtocol() {
        return this.protocol;
    }

    public void setSSL(boolean value) {
        this.ssl = value;
    }

    public boolean getSSL() {
        return this.ssl;
    }

    public void setCreateDomain(boolean value) {
        this.createDomain = value;
    }

    public boolean getCreateDomain() {
        return this.createDomain;
    }

    public void setNewUser(boolean value) {
        this.newUser = value;
    }

    public boolean getNewUser() {
        return this.newUser;
    }

    public void setPriority(int value) {
        this.priority = value;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setDirectory(String value) {
        this.directory = value;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setResID(int value) {
        this.resID = value;
    }

    public int getResID() {
        return this.resID;
    }

    public boolean getPreventPlainAuth() {
        return this.preventPlainAuth;
    }

    public void setPreventPlainAuth(boolean value) {
        this.preventPlainAuth = value;
    }

    public boolean getPreventNtlmAuth() {
        return this.preventNtlmAuth;
    }

    public void setPreventNtlmAuth(boolean value) {
        this.preventNtlmAuth = value;
    }

    public GUID getFallbackOwnerGUID() {
        return this.newUser ? null : this.fallbackOwnerGUID;
    }

    public void setFallbackOwnerGUID(GUID fallbackOwnerGUID) {
        this.fallbackOwnerGUID = fallbackOwnerGUID;
    }

    public void setOnlyAcceptEmailsForExistingTickets(boolean onlyAcceptEmailsForExistingTickets) {
        this.onlyAcceptEmailsForExistingTickets = onlyAcceptEmailsForExistingTickets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailAccount that = (EmailAccount)o;
        if (this.createDomain != that.createDomain) {
            return false;
        }
        if (this.newUser != that.newUser) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (this.resID != that.resID) {
            return false;
        }
        if (this.ssl != that.ssl) {
            return false;
        }
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.category, that.category)) {
            return false;
        }
        if (!Objects.equals(this.directory, that.directory)) {
            return false;
        }
        if (!Objects.equals(this.errorMessage, that.errorMessage)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.fromName, that.fromName)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.noBundles, that.noBundles)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (this.protocol != that.protocol) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (this.preventPlainAuth != that.preventPlainAuth) {
            return false;
        }
        if (this.preventNtlmAuth != that.preventNtlmAuth) {
            return false;
        }
        if (!Objects.equals(this.fallbackOwnerGUID, that.fallbackOwnerGUID)) {
            return false;
        }
        return Objects.equals(this.onlyAcceptEmailsForExistingTickets, that.onlyAcceptEmailsForExistingTickets);
    }

    public int hashCode() {
        int result = this.account != null ? this.account.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.fromName != null ? this.fromName.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.noBundles != null ? this.noBundles.hashCode() : 0);
        result = 31 * result + (this.template != null ? this.template.hashCode() : 0);
        result = 31 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        result = 31 * result + (this.ssl ? 1 : 0);
        result = 31 * result + (this.createDomain ? 1 : 0);
        result = 31 * result + (this.newUser ? 1 : 0);
        result = 31 * result + this.priority;
        result = 31 * result + (this.directory != null ? this.directory.hashCode() : 0);
        result = 31 * result + this.resID;
        result = 31 * result + (this.preventPlainAuth ? 1 : 0);
        result = 31 * result + (this.preventNtlmAuth ? 1 : 0);
        result = 31 * result + (this.fallbackOwnerGUID != null ? this.fallbackOwnerGUID.hashCode() : 0);
        result = 31 * result + (this.onlyAcceptEmailsForExistingTickets ? 1 : 0);
        return result;
    }

    public Integer getCategoryId() {
        if (this.categoryId == null) {
            this.categoryId = 0;
        }
        if (this.category != null && this.categoryId == -1) {
            try {
                this.categoryId = CategoryManager.getInstance().findOrCreateCategory(this.category, true);
                this.category = null;
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
        }
        return this.categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
        this.category = null;
    }

    public boolean isOnlyAcceptEmailsForExistingTickets() {
        return this.onlyAcceptEmailsForExistingTickets;
    }
}

