/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.model.dataimport.DataImportSchedule;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@JsonData
public class DeviceImportConfigInfo {
    private boolean indirekt;
    private int gertyp;
    private String selektionusermain = "";
    private String selektionuserref1 = "";
    private String selektionuserref2 = "";
    private String selektionuserref3 = "";
    private String selektionlist = "";
    private boolean loeschen;
    private DataImportSchedule schedule;
    private String selektion1 = "";
    private String uniqueident = "";
    private String uid;
    private boolean ldap;
    private String connectionName = "";

    public static DeviceImportConfigInfo importFrom(Properties importProps) {
        AtomicInteger mainTimeOption = new AtomicInteger(0);
        AtomicInteger subTimeOption = new AtomicInteger(-1);
        AtomicReference<String> specialTimeOption = new AtomicReference<String>("");
        DeviceImportConfigInfo info = new DeviceImportConfigInfo();
        info.setUid(UUID.randomUUID().toString());
        importProps.entrySet().stream().forEach(e -> {
            String key = ((String)e.getKey()).toLowerCase();
            if ("zeit1".equalsIgnoreCase(key)) {
                mainTimeOption.set(Integer.valueOf((String)e.getValue()));
            } else if ("zeit2".equalsIgnoreCase(key)) {
                subTimeOption.set(Integer.valueOf((String)e.getValue()));
            } else if ("specialTimeIntervalOption".equalsIgnoreCase(key)) {
                specialTimeOption.set((String)e.getValue());
            } else {
                try {
                    Field field = DeviceImportConfigInfo.class.getDeclaredField(key);
                    if (field.getType() == Integer.TYPE) {
                        try {
                            field.setInt(info, Integer.valueOf((String)e.getValue()));
                        }
                        catch (NumberFormatException exc) {
                            HDLogger.error(exc);
                        }
                    } else if (field.getType() == Boolean.TYPE) {
                        field.setBoolean(info, "true".equalsIgnoreCase((String)e.getValue()));
                    } else {
                        field.set(info, e.getValue());
                    }
                }
                catch (NoSuchFieldException e1) {
                    HDLogger.debug("while reading device config: unknown/unnecessary field " + key);
                }
                catch (IllegalAccessException e1) {
                    HDLogger.error(e1);
                }
            }
        });
        info.setSchedule(DeviceImportConfigInfo.mapOldSchedule(mainTimeOption.get(), subTimeOption.get(), specialTimeOption.get()));
        return info;
    }

    public int getGerTyp() {
        return this.gertyp;
    }

    public void setGerTyp(int gertyp) {
        this.gertyp = gertyp;
    }

    public boolean isIndirekt() {
        return this.indirekt;
    }

    public void setIndirekt(boolean indirect) {
        this.indirekt = indirect;
    }

    public String getSelektionUserMain() {
        return this.selektionusermain;
    }

    public void setSelektionUserMain(String selektionusermain) {
        this.selektionusermain = selektionusermain;
    }

    public String getIndirectUserReferenceObject() {
        return this.selektionuserref1;
    }

    public void setIndirectUserReferenceObject(String selectionuserref1) {
        this.selektionuserref1 = selectionuserref1;
    }

    public String getIndirectUserKeyReference() {
        return this.selektionuserref2;
    }

    public void setIndirectUserKeyReference(String indirectUserKeyReference) {
        this.selektionuserref2 = indirectUserKeyReference;
    }

    public String getIndirectUsernameReference() {
        return this.selektionuserref3;
    }

    public void setIndirectUsernameReference(String selektionUserRef3) {
        this.selektionuserref3 = selektionUserRef3;
    }

    public String getSelektionList() {
        return this.selektionlist;
    }

    public void setSelektionList(String selektionList) {
        this.selektionlist = selektionList;
    }

    public boolean isDelete() {
        return this.loeschen;
    }

    public void setDelete(boolean delete) {
        this.loeschen = delete;
    }

    public DataImportSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(DataImportSchedule schedule) {
        this.schedule = schedule;
    }

    public String getImportSource() {
        return this.selektion1;
    }

    public void setImportSource(String importSource) {
        this.selektion1 = importSource;
    }

    public String getUniqueIdent() {
        return this.uniqueident;
    }

    public void setUniqueIdent(String uniqueIdent) {
        this.uniqueident = uniqueIdent;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public List<String> getSelectionColumns() {
        if (this.selektionlist == null) {
            return null;
        }
        String[] parts = this.selektionlist.split("<>");
        return Arrays.asList(parts);
    }

    public void setSelectionColumns(List<String> columns) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            String col = columns.get(i);
            if (i > 0) {
                b.append("<>");
            }
            b.append(col);
        }
        this.selektionlist = b.toString();
    }

    public boolean isLdap() {
        return this.ldap;
    }

    public void setLdap(boolean ldap) {
        this.ldap = ldap;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    public static DataImportSchedule mapOldSchedule(int mainTimeOption, int subTimeOption, String specialTimeOption) {
        DataImportSchedule schedule = new DataImportSchedule();
        switch (mainTimeOption) {
            case 1: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.DAILY);
                schedule.setSubImportTimeOption(null);
                schedule.setHourOfDay(subTimeOption);
                break;
            }
            case 2: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.WEEKLY);
                switch (subTimeOption) {
                    case 1: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.TUESDAY);
                        break;
                    }
                    case 2: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.WEDNESDAY);
                        break;
                    }
                    case 3: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.THURSDAY);
                        break;
                    }
                    case 4: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.FRIDAY);
                        break;
                    }
                    case 5: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.SATURDAY);
                        break;
                    }
                    case 6: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.SUNDAY);
                        break;
                    }
                    default: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.MONDAY);
                    }
                }
                schedule.setHourOfDay(3);
                break;
            }
            default: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.MANUAL);
                schedule.setSubImportTimeOption(null);
                schedule.setHourOfDay(3);
            }
        }
        if (specialTimeOption.length() > 0) {
            String[] split;
            int minTime = 24;
            int maxTime = 0;
            for (String string : split = specialTimeOption.split("<>")) {
                if ((string = string.replaceAll("[^\\d]", "")).length() <= 0) continue;
                int cTime = Integer.valueOf(string);
                cTime = Math.min(Math.max(0, cTime), 24);
                maxTime = Math.max(maxTime, cTime);
                minTime = Math.min(minTime, cTime);
            }
            if (minTime != 24 || maxTime != 0) {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.HOURLY);
                schedule.setSubImportTimeOption(null);
                schedule.setHourOfDay(3);
                schedule.setStartHour(minTime);
                schedule.setEndHour(maxTime);
            }
        }
        return schedule;
    }
}

