/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.shared.model.Field;
import java.util.HashMap;
import java.util.Map;

public class AliasMapper {
    private static final HashMap<String, String> FIELD_TO_ALIAS_NAMES = new HashMap<String, String>(){
        {
            this.put("auftragfrei1", "auftrag1");
            this.put("auftragfrei2", "auftrag2");
            this.put("auftragfrei3", "auftrag3");
            this.put("auftragfrei4", "auftrag4");
            this.put("auftragfrei5", "auftrag5");
            this.put("auftragfrei6", "auftrag6");
            this.put("auftragfrei7", "auftrag7");
            this.put("bunfeld1", "auftrag1");
            this.put("bunfeld2", "auftrag2");
            this.put("bunfeld3", "auftrag3");
            this.put("bunfeld4", "auftrag4");
            this.put("bunfeld5", "auftrag5");
            this.put("bunfeld6", "auftrag6");
            this.put("bunfeld7", "auftrag7");
            this.put("spezfeld", "kennung");
            this.put("frei1", "benutzer1");
            this.put("frei2", "benutzer2");
            this.put("frei3", "benutzer3");
            this.put("frei4", "benutzer4");
            this.put("frei5", "benutzer5");
            this.put("frei6", "benutzer6");
            this.put("gerfeld1", "geraet1");
            this.put("gerfeld2", "geraet2");
            this.put("gerfeld3", "geraet3");
            this.put("gerfeld4", "geraet4");
            this.put("gerfeld5", "geraet5");
            this.put("gerfeld6", "geraet6");
            this.put("gerfeld7", "geraet7");
            this.put("gerfeld8", "geraet8");
            this.put("gerfeld9", "geraet9");
            this.put("zimmer", "zimmer");
            this.put("kostenstelle", "kostenstelle");
            this.put("abteilung", "abteilung");
        }
    };
    private static final HashMap<String, Field> ALIAS_TO_FIELD = new HashMap<String, Field>(){
        {
            this.put("auftrag1", Field.TICKETDATA_TICKETFIELD1);
            this.put("auftrag2", Field.TICKETDATA_TICKETFIELD2);
            this.put("auftrag3", Field.TICKETDATA_TICKETFIELD3);
            this.put("auftrag4", Field.TICKETDATA_TICKETFIELD4);
            this.put("auftrag5", Field.TICKETDATA_TICKETFIELD5);
            this.put("auftrag6", Field.TICKETDATA_TICKETFIELD6);
            this.put("auftrag7", Field.TICKETDATA_TICKETFIELD7);
            this.put("kennung", Field.TICKETDATA_SPECIALFIELD);
            this.put("benutzer1", Field.USERDATA_USERFIELD1);
            this.put("benutzer2", Field.USERDATA_USERFIELD2);
            this.put("benutzer3", Field.USERDATA_USERFIELD3);
            this.put("benutzer4", Field.USERDATA_USERFIELD4);
            this.put("benutzer5", Field.USERDATA_USERFIELD5);
            this.put("benutzer6", Field.USERDATA_USERFIELD6);
            this.put("abteilung", Field.USERDATA_DEPARTMENT);
            this.put("zimmer", Field.USERDATA_ROOM);
            this.put("kostenstelle", Field.USERDATA_COSTCENTRE);
            this.put("geraet1", Field.DEVICEDATA_DEVICEFIELD1);
            this.put("geraet2", Field.DEVICEDATA_DEVICEFIELD2);
            this.put("geraet3", Field.DEVICEDATA_DEVICEFIELD3);
            this.put("geraet4", Field.DEVICEDATA_DEVICEFIELD4);
            this.put("geraet5", Field.DEVICEDATA_DEVICEFIELD5);
            this.put("geraet6", Field.DEVICEDATA_DEVICEFIELD6);
            this.put("geraet7", Field.DEVICEDATA_DEVICEFIELD7);
            this.put("geraet8", Field.DEVICEDATA_DEVICEFIELD8);
            this.put("geraet9", Field.DEVICEDATA_DEVICEFIELD9);
        }
    };
    private static final HashMap<String, TicketField<String>> CUSTOM_FIELDS_TO_TICKET_FIELD = new HashMap<String, TicketField<String>>(){
        {
            this.put("auftrag1", Tickets.FIELD_CUSTOM_1);
            this.put("auftrag2", Tickets.FIELD_CUSTOM_2);
            this.put("auftrag3", Tickets.FIELD_CUSTOM_3);
            this.put("auftrag4", Tickets.FIELD_CUSTOM_4);
            this.put("auftrag5", Tickets.FIELD_CUSTOM_5);
            this.put("auftrag6", Tickets.FIELD_CUSTOM_6);
            this.put("auftrag7", Tickets.FIELD_CUSTOM_7);
        }
    };
    private static final Map<String, String> CUSTOM_ALIANS_TO_FIELD_KEY = new HashMap<String, String>(){
        {
            this.put("auftrag1", "auftragfrei1");
            this.put("auftrag2", "auftragfrei2");
            this.put("auftrag3", "auftragfrei3");
            this.put("auftrag4", "auftragfrei4");
            this.put("auftrag5", "auftragfrei5");
            this.put("auftrag6", "auftragfrei6");
            this.put("auftrag7", "auftragfrei7");
        }
    };

    public static TicketField<String> getCustomTicketFieldForKey(String fieldName) {
        fieldName = AliasMapper.getAliasForFieldKey(fieldName);
        return CUSTOM_FIELDS_TO_TICKET_FIELD.get(fieldName);
    }

    public static String getAliasForFieldKey(String fieldName) {
        if (fieldName != null && fieldName.length() > 0) {
            String normalizedName = fieldName.toLowerCase();
            int index = normalizedName.indexOf(46);
            if (index > 0) {
                normalizedName = normalizedName.substring(index + 1);
            }
            return FIELD_TO_ALIAS_NAMES.getOrDefault(normalizedName, fieldName);
        }
        return fieldName;
    }

    public static String getReverseMappingForCustomFields(String alias) {
        return CUSTOM_ALIANS_TO_FIELD_KEY.getOrDefault(alias, alias);
    }

    public static Field getFieldForAlias(String alias) {
        alias = AliasMapper.getAliasForFieldKey(alias);
        return ALIAS_TO_FIELD.get(alias);
    }
}

