/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.LocalizedKeyWithIcon;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.ActionList;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.shared.util.TranslationAdapter;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ActionListConfigProperty
extends ItemListConfigProperty {
    private static final int PAUSCHALE_1_LABEL_KEY = 22;
    private static final int PAUSCHALE_2_LABEL_KEY = 23;
    private static final int PAUSCHALE_3_LABEL_KEY = 24;
    private static final String[] changeableStatusActionIDs = new String[]{"-16", "-9", "-23", "-24", "-12", "9", "-25"};
    private static final String[] notChangeableStatusActionIDs = new String[]{"1", "-3", "9", "10", "2", "5", "-1", "-13", "8", "-2", "-12", "-7", "-8", "7", "-25"};

    public ActionListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, "Actions", "ACTIONS", ActionListConfigProperty.getObjectListValue(settings), null, new ConfigRowAction[]{ActionListConfigProperty.getRowAction(translator, settings.getLocale().getLanguage())});
        this.setDeleteDisabledCondition(new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"hide", "true"}));
    }

    static Object getObjectListValue(ConfigStructureSettings settings) {
        ArrayList changedValueRaw = (ArrayList)settings.getChangedValue("Actions", ArrayList.class);
        if (changedValueRaw != null) {
            int maxId = changedValueRaw.stream().map(m -> {
                if (!((String)m.get("id")).isEmpty()) {
                    return Integer.valueOf((String)m.get("id"));
                }
                return 0;
            }).max(Comparator.naturalOrder()).orElse(1);
            int dbMax = ActionManager.getInstance().getAll(false).stream().max(Comparator.comparingInt(FieldVO::getId)).map(FieldVO::getId).orElse(1);
            maxId = Math.max(maxId, dbMax);
            for (Map element : changedValueRaw) {
                boolean textRequired;
                element.remove("hide");
                if (((String)element.get("id")).isEmpty()) {
                    element.put("id", "" + (maxId + 1));
                }
                element.put("spezial", "" + ((textRequired = Boolean.parseBoolean((String)element.get("textRequired"))) ? 2 : 0));
            }
            changedValueRaw.sort((o1, o2) -> ((String)o1.get("AktBezeichnung")).compareToIgnoreCase((String)o2.get("AktBezeichnung")));
            return changedValueRaw;
        }
        List list = ActionManager.getInstance().getAll(true);
        ActionList cList = new ActionList();
        cList.addAll(list);
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        for (ActionVO action : cList) {
            HashMap<String, String> entry = ActionListConfigProperty.convertToHashmap(action);
            if (action.isInternal() || Arrays.asList(notChangeableStatusActionIDs).contains("" + action.getId()) && action.getId() != 9) {
                entry.put("hide", "true");
            }
            result.add(entry);
        }
        result.sort(Comparator.comparing(o -> (String)o.get("AktBezeichnung"), String.CASE_INSENSITIVE_ORDER));
        return result;
    }

    private static HashMap<String, String> convertToHashmap(ActionVO action) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", "" + action.getId());
        result.put("AktBezeichnung", action.getDisplayValue());
        result.put("Status", "" + action.getStatusID());
        result.put("intern", "" + action.isInternal());
        result.put("PauschAdd", "" + action.getBillingType());
        result.put("PauschSelekt", "" + action.getLumpSumType());
        result.put("AktPauschale", "" + action.getFixedCharge());
        result.put("spezial", "" + action.getSpecial());
        result.put("UserInVis", "" + action.isHidden());
        result.put("textRequired", "" + ((action.getSpecial() & 2) > 0));
        result.put("hide", "false");
        return result;
    }

    public static ActionList convertToList(HashMap<String, String>[] result) {
        ActionList map = new ActionList();
        for (HashMap<String, String> action : result) {
            ActionVO info = ActionListConfigProperty.convertToEntry(action);
            map.add(info);
        }
        return map;
    }

    private static ActionVO convertToEntry(HashMap<String, String> actionMap) {
        String id = actionMap.get("id");
        if (id == null) {
            id = "-1";
        }
        int idNum = Integer.parseInt(id);
        String name = actionMap.get("AktBezeichnung");
        int status = Integer.parseInt(actionMap.get("Status"));
        boolean intern = Boolean.parseBoolean(actionMap.get("intern"));
        int billingType = Integer.parseInt(actionMap.get("PauschAdd"));
        int lumpSumType = Integer.parseInt(actionMap.get("PauschSelekt"));
        double flatCharge = Double.parseDouble(actionMap.get("AktPauschale"));
        int special = Integer.parseInt(actionMap.get("spezial"));
        boolean invisibleToUser = Boolean.parseBoolean(actionMap.get("UserInVis"));
        return new ActionVO(idNum, name, status, intern, billingType, lumpSumType, flatCharge, false, special, invisibleToUser);
    }

    private static ConfigRowAction getRowAction(Translator translator, String language) {
        ConfigAction action = new ConfigAction("action.new", translator.translate("AddAction"));
        ConfigCategory category = new ConfigCategory(0, "action.new", translator.translate("Action"), "ticket.settings.actions");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "action.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("action.new.group", propertyList);
        ArrayList<ConfigConditionAction> conditions = new ArrayList<ConfigConditionAction>();
        ConditionGenerator g = new ConditionGenerator();
        ConfigCondition customAction = ActionListConfigProperty.getIsCustomActionCondition();
        ConfigCondition changeableStatusCondition = ActionListConfigProperty.getIsChangeableStatusCondition();
        ConfigCondition statusChangeable = g.createCondition().or(new ConfigCondition[]{customAction, changeableStatusCondition});
        conditions.add(g.enableActionFor(statusChangeable, "Status"));
        ConfigCondition canRequireTextCondition = ActionListConfigProperty.getCanRequireTextCondition();
        conditions.add(g.visibleActionFor(canRequireTextCondition, "textRequired"));
        ConfigCondition offersAccounting = ActionListConfigProperty.getOffersAccounting();
        conditions.add(g.visibleActionFor(offersAccounting, "PauschAdd"));
        conditions.add(g.visibleActionFor(offersAccounting, "PauschSelekt"));
        conditions.add(g.visibleActionFor(offersAccounting, "AktPauschale"));
        ConfigCondition isPauschale = g.createCondition().property("PauschAdd").equals().value((Object)"1");
        ConfigCondition isStundensatzPauschale = g.createCondition().property("PauschAdd").equals().value((Object)"2");
        ConfigCondition needsPauschale = g.createCondition().or(new ConfigCondition[]{isPauschale, isStundensatzPauschale});
        conditions.add(g.enableActionFor(needsPauschale, "PauschSelekt"));
        ConfigCondition isAktionPauschale = g.createCondition().property("PauschSelekt").equals().value((Object)"0");
        conditions.add(g.enableActionFor(g.createCondition().and(new ConfigCondition[]{needsPauschale, isAktionPauschale}), "AktPauschale"));
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(ActionListConfigProperty.propWith("SimpleText", translator.translate("AktBezeichnung"), "AktBezeichnung", ""));
        List statusList = StatusManager.getInstance().getAll(true).stream().map(s -> new LocalizedKeyWithIcon("" + s.getId(), s.getDisplayValue(), "images/data/0/" + s.getId())).collect(Collectors.toList());
        SelectConfigProperty statuses = new SelectConfigProperty(123, "Status", "FixNumber", translator.translate("Status"), (Object)"100", "", statusList);
        propertyList.add(statuses);
        propertyList.add(new BooleanConfigProperty(0, "UserInVis", "Boolean", translator.translate("UserInVis"), null, null, (Object)"false"));
        propertyList.add(new BooleanConfigProperty(0, "textRequired", "Boolean", translator.translate("textRequired"), null, null, (Object)"false"));
        ArrayList<LocalizedKey> billingTypes = new ArrayList<LocalizedKey>();
        billingTypes.add(new LocalizedKey("0", translator.translate("Hourly")));
        billingTypes.add(new LocalizedKey("1", translator.translate("FlatRate")));
        billingTypes.add(new LocalizedKey("2", translator.translate("BothFlatRateAndHourly")));
        SelectConfigProperty billingTypeSelect = new SelectConfigProperty(200, "PauschAdd", "FixNumber", translator.translate("PauschAdd"), (Object)"0", "", billingTypes);
        propertyList.add(billingTypeSelect);
        ArrayList<LocalizedKey> flatRateTypes = new ArrayList<LocalizedKey>();
        flatRateTypes.add(new LocalizedKey("0", translator.translate("flatRateAction")));
        TranslationTextConnector ttc = (TranslationTextConnector)ServerPluginManager.getInstance().getSingleInstance(TranslationTextConnector.class);
        String aString = TranslationAdapter.getTranslationKeyForOldSetID(22);
        String bString = TranslationAdapter.getTranslationKeyForOldSetID(23);
        String cString = TranslationAdapter.getTranslationKeyForOldSetID(24);
        try {
            String translatedLump1 = ttc.getTranslationText("helpdesk", aString, language);
            String translatedLump2 = ttc.getTranslationText("helpdesk", bString, language);
            String translatedLump3 = ttc.getTranslationText("helpdesk", cString, language);
            flatRateTypes.add(new LocalizedKey("1", translatedLump1));
            flatRateTypes.add(new LocalizedKey("2", translatedLump2));
            flatRateTypes.add(new LocalizedKey("3", translatedLump3));
        }
        catch (SQLException throwables) {
            HDLogger.error(throwables);
        }
        SelectConfigProperty flatRateTypeSelect = new SelectConfigProperty(201, "PauschSelekt", "FixNumber", translator.translate("PauschSelekt"), (Object)"0", "", flatRateTypes);
        propertyList.add(flatRateTypeSelect);
        propertyList.add(ActionListConfigProperty.propWith("FloatNumber", translator.translate("AktPauschale"), "AktPauschale", "0"));
        propertyList.add(ActionListConfigProperty.propWith("Hidden", "intern", "intern", ""));
        propertyList.add(ActionListConfigProperty.propWith("Hidden", "id", "id", ""));
        return rowAction;
    }

    private static ConfigCondition getIsChangeableStatusCondition() {
        ConditionGenerator g = new ConditionGenerator();
        String changeableStatusActions = new Json().toJson((Object)changeableStatusActionIDs);
        return g.createCondition().property("id").isIn().value((Object)changeableStatusActions);
    }

    private static ConfigCondition getOffersAccounting() {
        ConfigCondition customAction = ActionListConfigProperty.getIsCustomActionCondition();
        ConditionGenerator g = new ConditionGenerator();
        ConfigCondition isBearbeitenBeendenOrUebernehmen = g.createCondition().property("id").isIn().value((Object)new Json().toJson((Object)new String[]{"1", "2", "9"}));
        return g.createCondition().or(new ConfigCondition[]{customAction, isBearbeitenBeendenOrUebernehmen});
    }

    private static ConfigCondition getIsCustomActionCondition() {
        ConditionGenerator g = new ConditionGenerator();
        ConfigCondition isIntern = g.createCondition().property("intern").equals().value((Object)"true");
        String notChangeableStatusActions = new Json().toJson((Object)notChangeableStatusActionIDs);
        ConfigCondition isOneOfNotChangeableStatusActions = g.createCondition().property("id").isIn().value((Object)notChangeableStatusActions);
        ConfigCondition isNotOneOfNotChangeableActions = g.createCondition().not(isOneOfNotChangeableStatusActions);
        return g.createCondition().and(new ConfigCondition[]{g.createCondition().not(isIntern), isNotOneOfNotChangeableActions});
    }

    private static ConfigCondition getCanRequireTextCondition() {
        ConditionGenerator g = new ConditionGenerator();
        String actionsThatCannotRequireText = new Json().toJson((Object)new String[]{"-16", "-15", "-14", "-13", "-12", "-11", "-9", "-23", "-24", "-7", "-21", "-6", "-5", "-1", "6", "-10", "3", "-8", "4", "-32", "-31", "-22", "-26", "-27", "-28", "-19", "-18", "-30", "-29", "-25", "-33", "-17"});
        ConfigCondition isAnActionThatCannotRequireText = g.createCondition().property("id").isIn().value((Object)actionsThatCannotRequireText);
        return g.createCondition().not(isAnActionThatCannotRequireText);
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

