/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandFactory;
import com.inet.dbupdater.databases.commands.DefaultSimpleCommand;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.MySQLAddPrimaryCommand;
import com.inet.dbupdater.databases.commands.MySQLAlterColumnCommand;
import com.inet.dbupdater.databases.commands.MySQLAlterDropCommand;
import com.inet.dbupdater.databases.commands.MySQLCommandSyntax;
import com.inet.dbupdater.databases.commands.MySQLCreateDatabaseCommand;
import com.inet.dbupdater.databases.commands.MySQLCreatePrimaryIndexCommand;
import com.inet.dbupdater.databases.commands.MySQLCreateTableCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;

public class MySQLCommandFactory
extends DefaultCommandFactory {
    private DatabaseInfos dbInfo;

    public MySQLCommandFactory(DatabaseInfos dbInfo) {
        super(dbInfo);
        this.dbInfo = dbInfo;
        this.setSyntax(new MySQLCommandSyntax(dbInfo));
    }

    @Override
    public IComposedCommand getCommand(ICommandFactory.COMMAND_TYPE action, NodeFactory.TAG type, IDatabaseCommand.TIME purpose, Node containerNode, String name) {
        if (action == ICommandFactory.COMMAND_TYPE.create) {
            if (type == NodeFactory.TAG.table) {
                return new MySQLCreateTableCommand(this.dbInfo, this.getSyntax(), containerNode);
            }
            if (type == NodeFactory.TAG.index && name != null && name.equals("PRIMARY")) {
                return new MySQLCreatePrimaryIndexCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.database) {
                return new MySQLCreateDatabaseCommand(this.dbInfo, containerNode);
            }
        }
        if (action == ICommandFactory.COMMAND_TYPE.alter) {
            if (type == NodeFactory.TAG.column && purpose == IDatabaseCommand.TIME.alterstructure) {
                return new MySQLAlterColumnCommand(this.dbInfo, this.getSyntax(), containerNode);
            }
            if (type == NodeFactory.TAG.index) {
                if ((purpose == IDatabaseCommand.TIME.addstructure || purpose == IDatabaseCommand.TIME.addreferences) && name != null && name.equals("PRIMARY")) {
                    return new MySQLAddPrimaryCommand(this.dbInfo, containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.dropstructure || purpose == IDatabaseCommand.TIME.dropreferences) {
                    return new MySQLAlterDropCommand(this.dbInfo, this.getSyntax(), containerNode);
                }
            }
        }
        return super.getCommand(action, type, purpose, containerNode, name);
    }

    @Override
    public IComposedCommand getPresetCommand(String command, boolean isUpdate, IDatabaseCommand.TIME execTime, boolean mayFail, boolean distinct) {
        return new DefaultSimpleCommand(command, this.dbInfo, isUpdate, execTime, mayFail, distinct ? command : null);
    }
}

