/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.startpagemodules;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.remote.gui.AngularModule;
import com.inet.remote.gui.IModule;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class FormStartPageModuleProvider {
    private final ArrayList<AngularModule> modules = new ArrayList();
    private final FormsManager formsManager;

    public FormStartPageModuleProvider(FormsManager formsManager) {
        this.formsManager = formsManager;
    }

    public void updateModules() {
        DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
        for (AngularModule appModule : this.modules) {
            dem.unregister(IModule.class, (Object)appModule);
        }
        this.modules.clear();
        List<HDForm> allForms = this.formsManager.getAllForms();
        for (final HDForm form : allForms) {
            if (!form.isShowOnStartPage()) continue;
            final String iconData = form.getIconAsDataUri();
            AngularModule module = new AngularModule(){

                public boolean isInternal() {
                    return false;
                }

                public Permission getRequiredPermission() {
                    return null;
                }

                public String getColor() {
                    return "#AAAAAA";
                }

                public String getPath() {
                    return "/forms/" + form.getId().toString();
                }

                public String getName() {
                    String linkName = form.getStartPageLinkName();
                    if (linkName == null || linkName.isBlank()) {
                        return form.getName();
                    }
                    return linkName;
                }

                public String getDescription() {
                    String linkDesc = form.getStartPageLinkDescription();
                    if (linkDesc == null || linkDesc.isBlank()) {
                        return form.getTitle();
                    }
                    return linkDesc;
                }

                public URL getBigIconUrl(int size) {
                    if (iconData != null && form.isUseFormLogo()) {
                        try {
                            return new URL(iconData);
                        }
                        catch (MalformedURLException e) {
                            HDLogger.error((Object)e);
                        }
                    }
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/server/forms_plugin_48.png");
                }

                public boolean blockableByVeto() {
                    return false;
                }

                public boolean authenticationRequired() {
                    return true;
                }

                public boolean isAccessAllowed() {
                    try {
                        FormStartPageModuleProvider.this.formsManager.checkCanApplyForm(form.getId());
                        return true;
                    }
                    catch (AccessDeniedException e) {
                        return false;
                    }
                }
            };
            this.modules.add(module);
            dem.register(IModule.class, (Object)module);
        }
    }
}

