/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.internal;

import com.inet.editor.HtmlConverter;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldType;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketActionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.WithTicketGUID;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.forms.ReaStepFieldFormId;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.TaskPlannerNotifier;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSection;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSubmitAction;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.forms.server.internal.FormEventLog;
import com.inet.helpdesk.plugins.forms.server.internal.FormExtensionData;
import com.inet.helpdesk.plugins.forms.server.internal.FormTicketEventLog;
import com.inet.helpdesk.plugins.forms.server.internal.FormsPersistence;
import com.inet.helpdesk.plugins.forms.server.startpagemodules.FormStartPageModuleProvider;
import com.inet.helpdesk.shared.model.Status;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormsManagerImpl
implements FormsManager {
    private static final String TICKET_CONTENT_RESULT_TABLE_TD_STYLE = "    vertical-align: top;\n    word-wrap: break-word;\n    word-break: break-word;\n    min-width: 120px;\n    max-width: 50%;";
    private FormsPersistence persistence;
    private FormStartPageModuleProvider startPageModuleProvider = new FormStartPageModuleProvider(this);
    public static final ExtensionArguments.ExtArg<FormExtensionData> EXTARG_FORM_DATA = new ExtensionArguments.NonJsonizableExtArg<FormExtensionData>("ticketforms.formdata", FormExtensionData.class){

        public FormExtensionData copyValue(FormExtensionData value) {
            if (value == null) {
                return null;
            }
            ExtensionArguments arguments = value.getArguments();
            return new FormExtensionData(value.getText(), value.getAction(), value.getForm(), arguments == null ? null : ExtensionArguments.copyOf((ExtensionArguments)arguments), value.getChangedResource(), value.isFromTicketList(), value.getTicketText());
        }
    };

    public FormsManagerImpl(FormsPersistence formularPersistence) {
        this.persistence = formularPersistence;
    }

    @Override
    public HDForm getForm(GUID formID) {
        Objects.requireNonNull(formID);
        HDForm form = this.persistence.getForm(formID);
        if (form == null) {
            return null;
        }
        this.checkAccess(form, true);
        return form;
    }

    @Nonnull
    private HDForm getFormCheckExists(GUID formID) {
        HDForm form = this.getForm(formID);
        if (form == null) {
            throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.formdoesnotexist", new Object[]{formID}));
        }
        return form;
    }

    @Override
    public GUID createForm(HDForm formular, boolean validate) {
        this.checkPermissionVorlagen();
        if (validate) {
            formular.validate();
        }
        FormDir folder = this.getFolder(formular.getParentFolderId());
        this.checkExists(folder);
        this.checkFormNameDoesNotExist(folder, formular.getName());
        this.persistence.addForm(formular);
        if (formular.isShowOnStartPage()) {
            this.startPageModuleProvider.updateModules();
        }
        FormEventLog.FormAdded.log(formular);
        return formular.getId();
    }

    private void checkFormNameDoesNotExist(FormDir folder, @Nonnull String name) {
        if (this.listFormsInFolder(folder.getFolderID()).stream().anyMatch(f -> f.getName().equals(name))) {
            throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("error.formNameAlreadyExists", new Object[]{name}));
        }
    }

    @Override
    public void updateForm(HDForm formular, boolean validate) {
        HDForm oldForm;
        this.checkPermissionVorlagen();
        if (validate) {
            formular.validate();
        }
        if (!(oldForm = this.getFormCheckExists(formular.getId())).getName().equals(formular.getName()) || !oldForm.getParentFolderId().equals((Object)formular.getParentFolderId())) {
            this.checkFormNameDoesNotExist(this.getFolder(formular.getParentFolderId()), formular.getName());
        }
        this.persistence.updateForm(formular);
        this.startPageModuleProvider.updateModules();
        FormEventLog.FormChanged.log(formular);
    }

    @Override
    public void deleteForm(GUID formID) {
        this.checkPermissionVorlagen();
        HDForm form = this.getFormCheckExists(formID);
        this.persistence.deleteForm(formID);
        this.startPageModuleProvider.updateModules();
        FormEventLog.FormDeleted.log(form);
    }

    @Override
    public int applyForm(Map<String, String> fieldData, GUID formID, @Nullable GUID ticketID, int submittingSectionIndex, @Nullable ExtensionArguments argumentsParameter, @Nullable ProcessingTime processingTime, boolean fromTicketList) {
        HDForm form = this.getFormCheckExists(formID);
        if (!form.isActivated()) {
            throw new ClientMessageException(FormsServerPlugin.MSG_CLIENT.getMsg("ticketForms.formNotActivated", new Object[0]));
        }
        this.checkAccess(form, false);
        try {
            form.validate();
        }
        catch (Exception ex) {
            throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.hasErrors", new Object[0]), (Throwable)ex);
        }
        ExtensionArguments arguments = argumentsParameter == null ? ExtensionArguments.create() : argumentsParameter;
        ArrayList<FormSubmitAction> actions = new ArrayList<FormSubmitAction>();
        MutableTicketData data = new MutableTicketData();
        MutableReaStepText text = MutableReaStepText.of((String)"", (boolean)true);
        ReaStepTextVO changedTicketTextInCaseTicketModification = null;
        HashSet<String> fieldKeysAlreadyAddedAsText = new HashSet<String>();
        for (FormSection s : form.getSections()) {
            for (FormField f : s.getFields()) {
                String value = fieldData.get(f.getKey());
                if (value == null) continue;
                String fieldValueString = value.toString();
                FieldType<?> fieldType = f.getFieldType();
                if (FormField.FormFieldType.Ticket.equals((Object)f.getFormFieldType()) && !StringFunctions.isEmpty((String)fieldValueString)) {
                    if (!f.getKey().equals("special_ticket_text")) {
                        FieldEditDefinition editDefinition = Tickets.getFieldDefinitionByKey((String)f.getKey()).getEditDefinition();
                        if (editDefinition == null) {
                            throw new IllegalStateException(f.getKey());
                        }
                        editDefinition.updateTicketData(data, fieldData);
                    } else {
                        ReaStepTextVO fieldText = (ReaStepTextVO)new Json().fromJson(fieldValueString, ReaStepTextVO.class);
                        changedTicketTextInCaseTicketModification = fieldText.hasHtmlContent() ? ReaStepTextVO.of((String)TicketTextFunctions.prepareHtmlTextForSaving((String)TicketTextFunctions.correctAttachmentPathesForServer((String)fieldText.getText())), (boolean)true) : fieldText;
                    }
                }
                if (FormField.FormFieldType.Ticket.equals((Object)f.getFormFieldType()) || FormField.FormFieldType.Standard.equals((Object)f.getFormFieldType())) {
                    if (!f.isApplyToTicketText() || fieldKeysAlreadyAddedAsText.contains(f.getKey())) continue;
                    fieldKeysAlreadyAddedAsText.add(f.getKey());
                    if (!StringFunctions.isEmpty((String)fieldValueString) && (f.getFieldDataType().equals("select") || f.getFieldDataType().equals("selecteditable") || f.getFieldDataType().equals("selectmulti") || f.getFieldDataType().equals("selectmultieditable") || f.getFieldDataType().equals("ticketowner"))) {
                        try {
                            SelectOption op = (SelectOption)new Json().fromJson(fieldValueString, SelectOption.class, Json.NULL_MAP);
                            fieldValueString = op != null ? op.getValue() : null;
                        }
                        catch (JsonException | ClassCastException dx) {
                            FormsServerPlugin.LOGGER.debug((Object)dx);
                        }
                    }
                    if (text.getText().isEmpty()) {
                        text.setText("<html><body><table>");
                    }
                    String nextPart = "";
                    if (f.getFieldDataType().equals("htmltext")) {
                        if (!StringFunctions.isEmpty((String)fieldValueString)) {
                            ReaStepTextVO fieldText = (ReaStepTextVO)new Json().fromJson(fieldValueString, ReaStepTextVO.class);
                            if (fieldText.hasHtmlContent()) {
                                nextPart = TicketTextFunctions.prepareHtmlTextForSaving((String)TicketTextFunctions.correctAttachmentPathesForServer((String)fieldText.getText()));
                                nextPart = HtmlConverter.html2inlinedHtml((String)nextPart, (boolean)false, (boolean)true, null);
                            } else {
                                nextPart = fieldText.getText();
                            }
                        }
                    } else if (f.getFormFieldType() == FormField.FormFieldType.Ticket) {
                        TicketFieldDefinition definition = Tickets.getFieldDefinitionByKey((String)f.getKey());
                        nextPart = definition.getDisplayValue((TicketVO)TicketVOSingle.create((int)-2, (MutableTicketAttributes)new MutableTicketAttributes(), (MutableTicketData)data));
                    } else {
                        nextPart = this.getFieldDisplayValue(fieldType, fieldValueString);
                    }
                    if (nextPart == null) {
                        nextPart = "";
                    }
                    String label = f.getLabel();
                    String part2 = null;
                    if (f.isIncludeLabelInInquiry()) {
                        if (StringFunctions.isEmpty((String)label)) {
                            part2 = "<tr><td colspan=\"2\">" + nextPart + "</td></tr>";
                        } else {
                            Object labelWithColon = label;
                            if (!label.endsWith(":")) {
                                labelWithColon = label + ":";
                            }
                            part2 = f.getFieldDataType().equals("htmltext") ? "<tr><td colspan=\"2\">" + (String)labelWithColon + "</td></tr><tr><td colspan=\"2\">" + nextPart + "</td></tr>" : (f.getFieldDataType().equals("attachmentsadd") ? "<tr><td style=\"    vertical-align: top;\n    word-wrap: break-word;\n    word-break: break-word;\n    min-width: 120px;\n    max-width: 50%;\">" + FormsServerPlugin.MSG.getMsg("form.numberofattachments", new Object[0]) + " (" + label + "):</td><td>" + nextPart + "</td></tr>" : "<tr><td style=\"    vertical-align: top;\n    word-wrap: break-word;\n    word-break: break-word;\n    min-width: 120px;\n    max-width: 50%;\">" + (String)labelWithColon + "</td><td>" + nextPart + "</td></tr>");
                        }
                    } else {
                        part2 = "<tr><td colspan=\"2\">" + nextPart + "</td></tr>";
                    }
                    text.setText(text.getText() + part2);
                    continue;
                }
                throw new UnsupportedOperationException(f.getFormFieldType().toString());
            }
            actions.addAll(s.getActions());
        }
        if (!text.getText().isEmpty()) {
            text.setText(text.getText() + "</table></body></html>");
        }
        if (text.isHtml()) {
            text.setText(TicketTextFunctions.prepareHtmlTextForSaving((String)text.getText()));
        }
        ReaStepTextVO changedTicketTextX = changedTicketTextInCaseTicketModification;
        Integer ticketId = this.performOperationSwitchToTempFormUserIfAnonymous(() -> {
            if (form.getSubmitType() == 3) {
                TaskPlannerNotifier notifier = TaskPlannerNotifier.getInstance();
                if (notifier == null) {
                    throw new IllegalStateException("Task Planner plugin not active");
                }
                notifier.notifyTaskPlanner(formID, new HashMap<String, String>(fieldData));
                return -1;
            }
            if (form.getSubmitType() == 2) {
                return this.executeApplyAction(ticketID, form, submittingSectionIndex, data, text, arguments, processingTime, fromTicketList, changedTicketTextX);
            }
            return this.executeCreateTicket(form, arguments, actions, text, data, fromTicketList);
        });
        FormTicketEventLog.FormExecuted.log(form, ticketId);
        return ticketId;
    }

    private void checkIfTicketOwnerIsValid(MutableTicketData data, HDForm form, @Nullable TicketVO ticket) {
        if (data.containsKey((TicketField)Tickets.FIELD_OWNER_GUID) && !SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
            if (currentUserAccountID == null) {
                throw new AccessDeniedException();
            }
            GUID ticketOwner = (GUID)data.get((TicketField)Tickets.FIELD_OWNER_GUID);
            if (!(ticketOwner.equals((Object)currentUserAccountID) || form.getSections().stream().anyMatch(s -> s.getFields().stream().anyMatch(f -> {
                if (f.getKey().equals(Tickets.FIELD_OWNER_GUID.getKey()) && f.isCustomDefaultValue() && f.getDefaultValue() != null) {
                    String defaultValue = f.getDefaultValue();
                    SelectOption fromJson = (SelectOption)new Json().fromJson(defaultValue, SelectOption.class, Json.NULL_MAP);
                    defaultValue = fromJson.getValue();
                    return Objects.equals(defaultValue, ticketOwner.toString());
                }
                return false;
            })) || ticket != null && Objects.equals(ticket.getOwnerID(), ticketOwner))) {
                throw new AccessDeniedException();
            }
        }
    }

    private <T> T performOperationSwitchToTempFormUserIfAnonymous(Callable<T> task) {
        UserAccount currentUser = UserManager.getInstance().getCurrentUserAccount();
        if (currentUser == null) {
            MutableUserData userData = MutableUserData.of((UserField)UsersAndGroups.FIELD_LASTNAME, (Object)FormsServerPlugin.MSG.getMsg("form.nouser.displayname", new Object[0]));
            UserAccount account = UserManager.getInstance().createUserAccount(UserAccountType.Temp, userData);
            try {
                T t;
                block25: {
                    UserAccountScope scope = UserAccountScope.create((GUID)account.getID());
                    try {
                        t = task.call();
                        if (scope == null) break block25;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    scope.close();
                }
                return t;
            }
            finally {
                try (UserAccountScope p = UserAccountScope.createPrivileged();){
                    UserManager.getInstance().deleteUserAccount(account.getID());
                }
            }
        }
        try {
            return task.call();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(StringFunctions.getUserFriendlyErrorMessage((Throwable)e), e);
        }
    }

    private int executeCreateTicket(HDForm form, ExtensionArguments arguments, List<FormSubmitAction> actions, MutableReaStepText text, MutableTicketData data, boolean isFromTicketList) {
        this.checkIfTicketOwnerIsValid(data, form, null);
        AtomicInteger result = new AtomicInteger(-1);
        if (actions.stream().anyMatch(action -> action.getType() == 1)) {
            arguments.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.IF_RESOURCE_AVAILABLE);
            UserAccount current = Objects.requireNonNull(UserManager.getInstance().getCurrentUserAccount());
            if (current.getAccountType() != UserAccountType.Temp && data.get((TicketField)Tickets.FIELD_OWNER_GUID) == null) {
                data.put((TicketField)Tickets.FIELD_OWNER_GUID, (Object)UserManager.getInstance().getCurrentUserAccountID());
            }
            try (WithAdditionalReaStepData r = WithAdditionalReaStepData.create((MutableReaStepData)MutableReaStepData.ofSingle((ReaStepField)ReaStepFieldFormId.INSTANCE, (Object)form.getId()));
                 UserAccountScope pr = UserAccountScope.createPrivileged();){
                TicketManager.getManipulator().performManipulation(model -> {
                    OperationChangedTicket ticket = this.getTicketInnerOperations().createTicket(data, text.toVO(), arguments, model);
                    Integer groupStep = ((OperationNewReaStep)ticket.getAddedReaSteps().get(0)).getReaStepId();
                    ((OperationNewReaStep)ticket.getAddedReaSteps().get(0)).getFields().put((ReaStepField)ReaStepVO.FIELD_GROUP_REASTEP, (Object)groupStep);
                    result.set(ticket.getTicketId());
                    ActionVO applyForm = (ActionVO)ActionManager.getInstance().get(-41);
                    ExtensionArguments applyFormArgs = ExtensionArguments.create();
                    applyFormArgs.put(EXTARG_FORM_DATA, (Object)new FormExtensionData(MutableReaStepText.empty(), null, form, null, null, isFromTicketList, null));
                    MutableReaStepData applyActionData = new MutableReaStepData();
                    applyActionData.put((ReaStepField)ReaStepVO.FIELD_GROUP_REASTEP, (Object)groupStep);
                    this.getTicketInnerOperations().applyActionWithChecks(ticket, applyActionData, ReaStepTextVO.empty(), applyForm, applyFormArgs, false);
                    ticket.getAddedReaSteps().forEach(reaStep -> {
                        if ((Integer)reaStep.getAttributes().get((ReaStepAttribute)ReaStepVO.ATTRIBUTE_ACTION_ID) == 4 || (Integer)reaStep.getAttributes().get((ReaStepAttribute)ReaStepVO.ATTRIBUTE_ACTION_ID) == -41) {
                            reaStep.getAttributes().put((ReaStepAttribute)ReaStepVO.ATTRIBUTE_USER_ID, (Object)current.getID());
                        }
                    });
                });
            }
        }
        return result.get();
    }

    protected TicketSubOperations getTicketInnerOperations() {
        return TicketManager.extending().getTicketInnerOperations();
    }

    private Integer executeApplyAction(GUID ticketID, HDForm form, int submittingSectionIndex, MutableTicketData data, MutableReaStepText text, @Nonnull ExtensionArguments arguments, @Nullable ProcessingTime processingTime, boolean fromTicketList, @Nullable ReaStepTextVO ticketText) {
        Set<Integer> tickets;
        FormSection submittingSection = form.getSections().get(submittingSectionIndex);
        if (submittingSection.getActions().get(0).getType() != 2) {
            throw new IllegalArgumentException("Section " + submittingSectionIndex + " does not submit with type Apply_Action");
        }
        Integer actionId = submittingSection.getActions().get(0).getActionId();
        ActionVO action = null;
        if (actionId != null) {
            action = (ActionVO)ActionManager.getInstance().get(actionId.intValue());
            if (action == null) {
                throw new IllegalStateException("Action not found with ID: " + actionId);
            }
            if (action.getId() == -41) {
                action = null;
            }
        }
        if ((tickets = FormsManagerImpl.getTicketsWithGUID(ticketID)).size() == 1) {
            ExtensionArguments args;
            Integer ticketId = tickets.iterator().next();
            this.checkIfTicketOwnerIsValid(data, form, TicketManager.getReaderForSystem().getTicket(ticketId.intValue()));
            GUID changedResource = null;
            if (data.containsKey((TicketField)Tickets.FIELD_RESOURCE_GUID) && action != null && (action.getId() == 6 || action.getId() == 8)) {
                changedResource = (GUID)data.get((TicketField)Tickets.FIELD_RESOURCE_GUID);
                data.remove((TicketField)Tickets.FIELD_RESOURCE_GUID);
            }
            if (action == null) {
                args = ExtensionArguments.copyOf((ExtensionArguments)arguments);
                args.put(EXTARG_FORM_DATA, (Object)new FormExtensionData(text, action, form, null, changedResource, fromTicketList, ticketText));
            } else {
                args = ExtensionArguments.create();
                args.put(EXTARG_FORM_DATA, (Object)new FormExtensionData(text, action, form, arguments, changedResource, fromTicketList, ticketText));
            }
            args.put(ExtensionArguments.EXTARG_TICKET_DATA, (Object)data);
            try (WithTicketGUID ticketGUID = WithTicketGUID.create((GUID)ticketID);){
                MutableReaStepData reaStepData = new MutableReaStepData();
                if (processingTime != null) {
                    reaStepData.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)processingTime);
                }
                TicketManager.getManipulator().applyAction(ticketId.intValue(), reaStepData, ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(-41), args);
            }
            return (Integer)tickets.stream().toList().get(0);
        }
        if (tickets.size() == 0) {
            throw new UnsupportedOperationException(FormsServerPlugin.MSG.getMsg("form.ticketguid.error", new Object[]{ticketID.toString()}));
        }
        throw new UnsupportedOperationException("More than one Ticket found for GUID: " + ticketID.toString());
    }

    private <VALUE> String getFieldDisplayValue(FieldType<VALUE> field, String valueAsString) {
        String displayValue = field.getDisplayValue(field.valueOf(valueAsString));
        return displayValue == null ? "" : displayValue;
    }

    @Override
    public FormDir getFolderStructure() {
        this.checkPermissionVorlagen();
        return this.persistence.getRootFolder();
    }

    @Override
    public FormDir getFolder(GUID folderID) {
        Objects.requireNonNull(folderID);
        this.checkPermissionVorlagen();
        return this.persistence.getFolder(folderID);
    }

    @Override
    public GUID createFolder(FormDir dir) {
        this.checkPermissionVorlagen();
        FormDir parentDir = this.persistence.getFolder(dir.getParentId());
        this.checkExists(parentDir);
        if (parentDir.getChildren().stream().anyMatch(child -> child.getName().equals(dir.getName()))) {
            throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.folderAlreadyExists", new Object[]{dir.getName()}));
        }
        return this.persistence.createFolder(dir);
    }

    @Override
    public void moveFolder(GUID folderId, GUID newParent, String newName) {
        this.checkPermissionVorlagen();
        FormDir folder = this.getFolder(folderId);
        this.checkExists(folder);
        if (folder.getParentId() == null) {
            throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.cannotMoveRoot", new Object[]{folder.getFolderID()}));
        }
        FormDir newParentDir = this.getFolder(newParent);
        this.checkExists(newParentDir);
        if (folder.find(newParent) != null) {
            throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.cannotMoveToSubTree", new Object[0]));
        }
        if (this.checkFolderNameExists(newParentDir, newName)) {
            throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.folderAlreadyExists", new Object[]{newName}));
        }
        this.persistence.updateFolder(folderId, newParent, newName, folder.getSharings());
    }

    private void checkExists(FormDir folder) {
        if (folder == null) {
            throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.folderDoesNotExist", new Object[0]));
        }
    }

    private void checkAccess(@Nonnull HDForm form, boolean templatePermissionAllowed) {
        if (templatePermissionAllowed && SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION})) {
            return;
        }
        FormDir folder = this.persistence.getFolder(form.getParentFolderId());
        if (folder == null) {
            throw new IllegalStateException();
        }
        List<UsersOrGroupsSelection.SelectedMember> sharings = folder.getSharings();
        if (sharings == null) {
            return;
        }
        if (sharings.isEmpty()) {
            throw new AccessDeniedException((ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists, new Object[]{form.getId()});
        }
        GUID accountID = UserManager.getInstance().getCurrentUserAccountID();
        if (accountID != null) {
            for (UsersOrGroupsSelection.SelectedMember selectedMember : sharings) {
                Set groupsForUser;
                if (!(selectedMember.getType() == Type.user ? selectedMember.getId().equals((Object)accountID) : (groupsForUser = UserGroupManager.getInstance().getGroupsForUser(accountID)).stream().anyMatch(g -> g.getID().equals((Object)selectedMember.getId())))) continue;
                return;
            }
            throw new AccessDeniedException((ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists, new Object[]{form.getId()});
        }
        throw new AccessDeniedException((ErrorCode)BaseErrorCode.UserLoginRequired, new Object[]{form.getId()});
    }

    private void checkPermissionVorlagen() {
        if (!SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION})) {
            throw new AccessDeniedException(HdPermissions.TEMPLATE_DEFINITION);
        }
    }

    @Override
    public void deleteFolder(GUID folderID) {
        this.checkPermissionVorlagen();
        FormDir folder = this.persistence.getFolder(folderID);
        this.checkExists(folder);
        if (folder.getFolderID().equals((Object)this.getRootFolderID())) {
            throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.cannotMoveRoot", new Object[]{this.getRootFolderID()}));
        }
        this.deleteForms(folder);
        this.persistence.deleteFolder(folderID);
        this.startPageModuleProvider.updateModules();
    }

    private void deleteForms(FormDir folder) {
        for (HDForm form : this.persistence.getFormsInFolder(folder.getFolderID())) {
            this.deleteForm(form.getId());
        }
        for (FormDir formDir : folder.getChildren()) {
            this.deleteForms(formDir);
        }
    }

    @Override
    public List<HDForm> listFormsInFolder(GUID folderID) {
        this.checkPermissionVorlagen();
        return this.persistence.getFormsInFolder(folderID);
    }

    @Override
    @Nonnull
    public GUID getRootFolderID() {
        return this.persistence.getRootFolder().getFolderID();
    }

    @Override
    public List<HDForm> getAllForms() {
        this.checkPermissionVorlagen();
        return this.persistence.getAllForms();
    }

    @Override
    public void moveForm(GUID formId, GUID folder) {
        this.checkPermissionVorlagen();
        HDForm form = this.getFormCheckExists(formId);
        HDForm updated = new HDForm(form.getName(), formId, folder, form.getTitle(), form.getSections(), form.isActivated(), form.getIcon(), form.getSubmitType(), form.isShowOnStartPage(), form.getStartPageLinkName(), form.getStartPageLinkDescription(), form.isUseFormLogo(), form.getMaxAttachmentSizeMb());
        this.updateForm(updated, false);
    }

    @Override
    public void copyFolder(GUID folderGuid, @Nonnull GUID newParentFolderId) {
        this.checkPermissionVorlagen();
        FormDir folder = this.getFolder(folderGuid);
        this.checkExists(folder);
        FormDir newParent = this.getFolder(newParentFolderId);
        this.checkExists(newParent);
        this.copyRecursive(folder, newParent);
    }

    private boolean checkFolderNameExists(FormDir folder, String name) {
        return folder.getChildren().stream().anyMatch(d -> d.getName().equals(name));
    }

    private void copyRecursive(FormDir folder, FormDir newParent) {
        Object name = folder.getName();
        while (this.checkFolderNameExists(newParent, (String)name)) {
            name = (String)name + " (Copy)";
        }
        GUID newFolderId = this.createFolder(new FormDir((String)name, newParent.getFolderID(), folder.getSharings()));
        this.listFormsInFolder(folder.getFolderID()).forEach(form -> this.createForm(new HDForm(form.getName(), GUID.generateNew(), newFolderId, form.getTitle(), form.getSections(), form.isActivated(), form.getIcon(), form.getSubmitType(), form.isShowOnStartPage(), form.getStartPageLinkName(), form.getStartPageLinkDescription(), form.isUseFormLogo(), form.getMaxAttachmentSizeMb()), false));
        folder.getChildren().forEach(childDir -> this.copyRecursive((FormDir)childDir, this.getFolder(newFolderId)));
    }

    @Override
    public void updateFolder(GUID folderGuid, String name, List<UsersOrGroupsSelection.SelectedMember> sharings) {
        Objects.requireNonNull(name);
        this.checkPermissionVorlagen();
        FormDir folder = this.getFolder(folderGuid);
        this.checkExists(folder);
        if (!folder.getName().equals(name)) {
            if (folder.getParentId() == null) {
                throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.cannotMoveRoot", new Object[]{folder.getFolderID()}));
            }
            if (this.checkFolderNameExists(this.getFolder(folder.getParentId()), name)) {
                throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.folderAlreadyExists", new Object[]{name}));
            }
        }
        this.persistence.updateFolder(folderGuid, folder.getParentId(), name, sharings);
        this.startPageModuleProvider.updateModules();
    }

    @Override
    public void checkCanApplyForm(GUID formID) {
        this.checkCanApplyForm(formID, null);
    }

    @Override
    public void checkCanApplyForm(GUID formID, @Nullable GUID ticketGUID) {
        Objects.requireNonNull(formID);
        HDForm form = this.getFormCheckExists(formID);
        this.checkAccess(form, false);
        if (UserManager.getInstance().getCurrentUserAccount() == null) {
            this.performOperationSwitchToTempFormUserIfAnonymous(() -> {
                this.checkCanApplyForm(formID, ticketGUID);
                return null;
            });
        }
        TicketActionChecker ticketActionChecker = TicketManager.getTicketActionChecker();
        if (form.getSubmitType() == 2) {
            Set<Object> ticketsWithGUID;
            Set<Object> set = ticketsWithGUID = ticketGUID == null ? new HashSet() : FormsManagerImpl.getTicketsWithGUID(ticketGUID);
            if (ticketsWithGUID.size() != 1) {
                throw new AccessDeniedException(ActionCheckError.createForAccessDenied((String)Tickets.MSG.getMsg("actionchecker.ticketNotIdentifiable", new Object[0])).getErrorMessage(), (ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists);
            }
            int ticketId = ticketsWithGUID.toArray(new Integer[0])[0];
            boolean foundOne = false;
            for (FormSection s : form.getSections()) {
                FormSubmitAction formSubmitAction;
                if (s.getActions().size() <= 0 || (formSubmitAction = s.getActions().get(0)).getType() != 2) continue;
                Integer formAction = formSubmitAction.getActionId();
                if (formAction == null) {
                    formAction = -41;
                }
                UserAccountScope pri = UserAccountScope.createPrivileged();
                try {
                    if (formAction == -41) {
                        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
                        if (Status.isClosedOrDeletedStatus((int)ticket.getStatusID())) continue;
                        foundOne = true;
                        break;
                    }
                    ActionVO formActionVO = (ActionVO)ActionManager.getInstance().get(formAction.intValue());
                    if (!ticketActionChecker.checkActionIndirectlyAllowed(formActionVO, ticketId)) continue;
                    foundOne = true;
                    break;
                }
                finally {
                    if (pri == null) continue;
                    pri.close();
                }
            }
            if (!foundOne) {
                throw new IllegalStateException(FormsServerPlugin.MSG.getMsg("error.noActionPossible", new Object[]{ticketId}));
            }
        } else if (ticketGUID != null) {
            throw new IllegalArgumentException("Cannot pass a ticketid for execution of a form which creates a new ticket");
        }
    }

    public static Set<Integer> getTicketsWithGUID(@Nonnull GUID ticketGUID) {
        IndexSearchEngine searchEngine = TicketManager.getReaderForSystem().getSearchEngine();
        return searchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition(Tickets.ATTRIBUTE_TICKET_GUID.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)ticketGUID.toString())}));
    }

    public void hardReset() {
        this.persistence.init();
        try (UserAccountScope p = UserAccountScope.createPrivileged();){
            this.startPageModuleProvider.updateModules();
        }
    }

    @Override
    public List<HDForm> listAnyViewableFormSharedInFolder(GUID folderID) {
        FormDir folder = this.persistence.getFolder(folderID);
        List<HDForm> allForms = this.persistence.getFormsInFolder(folderID);
        ArrayList<HDForm> viewableForms = new ArrayList<HDForm>();
        for (HDForm form : allForms) {
            if (!this.canCurrentUserViewFormsInFolder(folder)) continue;
            viewableForms.add(form);
        }
        return viewableForms;
    }

    private boolean canCurrentUserViewFormsInFolder(FormDir folder) {
        List<UsersOrGroupsSelection.SelectedMember> sharings = folder.getSharings();
        if (sharings == null) {
            return true;
        }
        if (sharings.isEmpty()) {
            return false;
        }
        GUID accountID = UserManager.getInstance().getCurrentUserAccountID();
        if (accountID != null) {
            for (UsersOrGroupsSelection.SelectedMember selectedMember : sharings) {
                Set groupsForUser;
                if (selectedMember.getType() == Type.user && selectedMember.getId().equals((Object)accountID)) {
                    return true;
                }
                if (selectedMember.getType() != Type.group || !(groupsForUser = UserGroupManager.getInstance().getGroupsForUser(accountID)).stream().anyMatch(g -> g.getID().equals((Object)selectedMember.getId()))) continue;
                return true;
            }
        }
        return false;
    }

    public void updateStartPageModules() {
        this.startPageModuleProvider.updateModules();
    }
}

