/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.internal;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.plugins.forms.ReaStepFieldFormId;
import com.inet.helpdesk.plugins.forms.server.internal.FormExtensionData;
import com.inet.helpdesk.plugins.forms.server.internal.FormsManagerImpl;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccountScope;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplyFormActionExtension
implements TicketActionExtensionFactory {
    @Nullable
    public TicketActionExtension createIfApplicable(@Nonnull OperationChangedTicket ticket, @Nonnull ActionVO action, @Nonnull ExtensionArguments arguments, @Nonnull MutableReaStepData reaStepFields) {
        if (arguments.containsExtArg(FormsManagerImpl.EXTARG_FORM_DATA)) {
            return new Extension((FormExtensionData)arguments.get(FormsManagerImpl.EXTARG_FORM_DATA));
        }
        return null;
    }

    private class Extension
    implements TicketActionExtension {
        private FormExtensionData formExtensionData;

        private Extension(FormExtensionData formExtensionData) {
            this.formExtensionData = formExtensionData;
        }

        public void extendTicketAction(ActionVO applyAction, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            MutableReaStepData groupingData = MutableReaStepData.ofSingle((ReaStepField)ReaStepFieldFormId.INSTANCE, (Object)this.formExtensionData.getForm().getId());
            groupingData.put((ReaStepField)ReaStepVO.FIELD_GROUP_REASTEP, (Object)reaStep.getReaStepId());
            reaStep.getFields().putAll(groupingData);
            try (UserAccountScope scope = UserAccountScope.createPrivileged();
                 WithAdditionalReaStepData withData = WithAdditionalReaStepData.create((MutableReaStepData)groupingData);){
                ActionVO action = this.formExtensionData.getAction();
                if (action != null) {
                    MutableTicketData data = ticket.getNewTicketData().copy();
                    ticket.getNewTicketData().getIncludedFields().forEach(f -> ticket.getNewTicketData().remove(f));
                    ExtensionArguments extArgs = ExtensionArguments.copyOf((ExtensionArguments)this.formExtensionData.getArguments());
                    extArgs.put(ExtensionArguments.EXTARG_TICKET_DATA, (Object)data);
                    if (this.formExtensionData.getChangedResource() != null && (action.getId() == 6 || action.getId() == 8)) {
                        ExtensionArguments.ResourceActionExtensionData extData = ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket((GUID)this.formExtensionData.getChangedResource(), (boolean)true);
                        extArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, (Object)extData);
                    }
                    MutableReaStepData reaStepData = new MutableReaStepData();
                    if (((ProcessingTime)reaStep.getFields().get((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME)).getEffortInMin() > 0L) {
                        ProcessingTime duration = (ProcessingTime)reaStep.getFields().get((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME);
                        reaStep.getFields().put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)ProcessingTime.of((long)System.currentTimeMillis()));
                        reaStepData.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)duration);
                    }
                    if (!this.formExtensionData.isFromTicketList()) {
                        extArgs.put(ExtensionArguments.EXTARG_IMPLICIT_AUTO_ACTION, (Object)Boolean.TRUE);
                    }
                    operations.applyActionWithChecks(ticket, reaStepData, this.formExtensionData.getText().toVO(), action, extArgs, true);
                } else {
                    if (Status.isClosedOrDeletedStatus((int)((Integer)ticket.getAttributeValue((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID)))) {
                        throw new IllegalStateException(Tickets.MSG.getMsg("actionchecker.ticketNotOpen", new Object[]{ticket.getTicketId()}));
                    }
                    if (!this.formExtensionData.getText().getText().isEmpty()) {
                        reaStep.setText(this.formExtensionData.getText());
                    }
                }
                ticket.createFieldChangeReaStepsIfNeeded(null);
                if (this.formExtensionData.getTicketText() != null) {
                    operations.applyActionEditReaStepText(ticket, ExtensionArguments.ofSingleArg((ExtensionArguments.ExtArg)ExtensionArguments.EXTARG_CHANGED_REA_STEP, (Object)ExtensionArguments.EditReastepTextActionExtensionData.create((int)((Integer)ticket.getAttributeValue((TicketAttribute)Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID)), (ReaStepTextVO)this.formExtensionData.getTicketText())));
                }
            }
        }
    }
}

