/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.api.model;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeSelect;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.forms.client.handler.config.LoadFormDetails;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSection;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSubmitAction;
import com.inet.helpdesk.plugins.forms.server.api.model.IconProvider;
import com.inet.helpdesk.plugins.forms.server.api.model.condition.AndBlock;
import com.inet.helpdesk.plugins.forms.server.api.model.condition.FormCondition;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.modules.importexport.ExportableWidget;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HDForm
implements ExportableWidget {
    private int submitType;
    private GUID id;
    private String name;
    private boolean activated;
    private boolean showOnStartPage;
    private boolean useFormLogo;
    private int maxAttachmentSizeMb;
    @Nullable
    private String startPageLinkName;
    @Nullable
    private String startPageLinkDescription;
    @Nonnull
    private GUID parentFolderId;
    @Nullable
    private String title;
    private List<FormSection> sections;
    private IconProvider icon;

    public HDForm(@Nonnull String name, @Nonnull GUID id, @Nonnull GUID parentFolderId, @Nonnull @Nonnull List<@Nonnull FormSection> sections) {
        this(name, id, parentFolderId, null, sections, true, null, 1);
    }

    public HDForm(@Nonnull String name, @Nonnull GUID id, @Nonnull GUID parentFolderId, String title, @Nonnull @Nonnull List<@Nonnull FormSection> sections, boolean activated, IconProvider icon, int submitType) {
        this(name, id, parentFolderId, title, sections, activated, icon, submitType, false, null, null, false, 100);
    }

    public HDForm(@Nonnull String name, @Nonnull GUID id, @Nonnull GUID parentFolderId, String title, @Nonnull @Nonnull List<@Nonnull FormSection> sections, boolean activated, IconProvider icon, int submitType, boolean showOnStartPage, String startPageLinkName, String startPageLinkDescription, boolean useFormLogo, int maxAttachmentSizeMb) {
        this.title = title;
        this.maxAttachmentSizeMb = maxAttachmentSizeMb;
        Objects.requireNonNull(id);
        Objects.requireNonNull(name);
        Objects.requireNonNull(parentFolderId);
        Objects.requireNonNull(sections);
        switch (submitType) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown submittype: " + submitType);
            }
        }
        this.name = name;
        this.id = id;
        this.parentFolderId = parentFolderId;
        this.activated = activated;
        this.sections = new ArrayList<FormSection>(sections);
        this.icon = icon;
        this.submitType = submitType;
        this.showOnStartPage = showOnStartPage;
        this.startPageLinkName = startPageLinkName;
        this.startPageLinkDescription = startPageLinkDescription;
        this.useFormLogo = useFormLogo;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public GUID getId() {
        return this.id;
    }

    @Nonnull
    public GUID getParentFolderId() {
        return this.parentFolderId;
    }

    public List<FormSection> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public HDForm copyWithActivated(boolean activated) {
        return new HDForm(this.name, this.id, this.parentFolderId, this.title, this.sections, activated, this.icon, this.submitType, this.showOnStartPage, this.startPageLinkName, this.startPageLinkDescription, this.useFormLogo, this.maxAttachmentSizeMb);
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public IconProvider getIcon() {
        return this.icon;
    }

    @Nullable
    public String getIconAsDataUri() {
        if (this.icon == null) {
            return null;
        }
        return this.icon.getAsDataUri();
    }

    public void validate() {
        boolean noResourceField;
        boolean doesmanualEscalation;
        FormDir folder;
        int sectionIndex;
        HashSet<String> allFieldKeys = new HashSet<String>();
        HashMap<String, FormField> fieldMap = new HashMap<String, FormField>();
        HashMap<String, Integer> field_EarliestSectionMap = new HashMap<String, Integer>();
        boolean foundSubjectOrFieldForText = false;
        for (sectionIndex = 0; sectionIndex < this.sections.size(); ++sectionIndex) {
            FormSection s2 = this.sections.get(sectionIndex);
            for (FormField f : s2.getFields()) {
                allFieldKeys.add(f.getKey());
                fieldMap.put(f.getKey(), f);
                if (field_EarliestSectionMap.containsKey(f.getKey()) && ((Integer)field_EarliestSectionMap.get(f.getKey())).equals(sectionIndex)) {
                    throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.fieldDuplicated", new Object[]{f.getLabel(), sectionIndex + 1}));
                }
                field_EarliestSectionMap.putIfAbsent(f.getKey(), sectionIndex);
            }
        }
        for (sectionIndex = 0; sectionIndex < this.sections.size(); ++sectionIndex) {
            Integer action2;
            FormSubmitAction formSubmitAction;
            FormSection section = this.sections.get(sectionIndex);
            boolean hasSubmitAction = section.getActions().stream().anyMatch(action -> action.getType() == 1 || action.getType() == 2 || action.getType() == 3);
            if (hasSubmitAction) {
                for (int otherSectionIndex = sectionIndex + 1; otherSectionIndex < this.sections.size(); ++otherSectionIndex) {
                    FormSection otherSection = this.sections.get(otherSectionIndex);
                    for (AndBlock block : otherSection.getConditions()) {
                        for (FormCondition condition : block.getConditions()) {
                            if (!field_EarliestSectionMap.containsKey(condition.getFieldKey()) || !((Integer)field_EarliestSectionMap.get(condition.getFieldKey())).equals(sectionIndex)) continue;
                            throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.visibilityConditionWithSubmitAction", new Object[]{otherSectionIndex + 1, this.getFieldLabelElseKey(fieldMap, condition.getFieldKey()), sectionIndex + 1}));
                        }
                    }
                }
            }
            if (!section.getActions().isEmpty() && (formSubmitAction = section.getActions().get(0)).getType() == 2 && (action2 = formSubmitAction.getActionId()) != null && (ActionManager.getInstance().get(action2.intValue()) == null || ((ActionVO)ActionManager.getInstance().get(action2.intValue())).isDeleted())) {
                throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.actionDoesNotExist", new Object[]{sectionIndex + 1, action2}));
            }
            for (FormField field : section.getFields()) {
                List<String> select_options;
                String key = field.getKey();
                if (fieldMap.containsKey(key)) {
                    if (!((FormField)fieldMap.get(key)).getFormFieldType().equals((Object)field.getFormFieldType())) {
                        throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.fieldDataTypeDifferent", new Object[]{this.getFieldLabelElseKey(fieldMap, key), ((FormField)fieldMap.get(key)).getFormFieldType(), field.getFormFieldType()}));
                    }
                    if (!((FormField)fieldMap.get(key)).getFieldDataType().equals(field.getFieldDataType())) {
                        throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.fieldDataTypeDifferent", new Object[]{this.getFieldLabelElseKey(fieldMap, key), FormField.getFieldDataTypeLabel(((FormField)fieldMap.get(key)).getFieldDataType()), FormField.getFieldDataTypeLabel(field.getFieldDataType())}));
                    }
                }
                if (field.getFormFieldType() == FormField.FormFieldType.Ticket && !field.getKey().equals("special_ticket_text") && Tickets.getFieldByKey((String)field.getKey()) == null) {
                    throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.unknownField", new Object[]{sectionIndex + 1, key}));
                }
                if (field.getFormFieldType() == FormField.FormFieldType.Standard && !LoadFormDetails.standardFieldDataTypes().contains(field.getFieldDataType())) {
                    throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.unknownFieldType", new Object[]{sectionIndex + 1, this.getFieldLabelElseKey(fieldMap, key), field.getFieldDataType()}));
                }
                if (field.isHidden() && ("".equals(field.getDefaultValue()) || field.getDefaultValue() == null) && field.isMandatory()) {
                    throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.hiddenEmpty", new Object[]{sectionIndex + 1, this.getFieldLabelElseKey(fieldMap, key)}));
                }
                if (key.equals(Tickets.FIELD_SUBJECT.getKey()) || field.isApplyToTicketText()) {
                    foundSubjectOrFieldForText = true;
                }
                if (field.getFormFieldType() == FormField.FormFieldType.Ticket && field.isCustomDefaultValue() && !field.getKey().equals("special_ticket_text")) {
                    TicketField ticketField = Tickets.getFieldByKey((String)field.getKey());
                    try {
                        String defaultValue = field.getDefaultValue();
                        if ((field.getFieldDataType().equals("select") || field.getFieldDataType().equals("selecteditable") || field.getFieldDataType().equals("ticketowner") || field.getFieldDataType().equals("itilselect")) && defaultValue != null) {
                            SelectOption option = (SelectOption)new Json().fromJson(defaultValue, SelectOption.class, Json.NULL_MAP);
                            defaultValue = option.getValue();
                        }
                        ticketField.validate(field.getFieldType().valueOf(defaultValue));
                    }
                    catch (FieldValidationException | NumberFormatException ex) {
                        HDLogger.info((Object)ex);
                        throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.field.invalidDefaultvalue", new Object[]{field.getLabel(), ex.getMessage()}));
                    }
                }
                if (field.getFormFieldType() != FormField.FormFieldType.Standard || !(field.getFieldType() instanceof FieldTypeSelect) || (select_options = field.getSelect_options()) == null) continue;
                HashSet<String> uniqueOptions = new HashSet<String>();
                for (String option : select_options) {
                    if (uniqueOptions.contains(option)) {
                        throw new ClientMessageException(this.getFieldLabelElseKey(fieldMap, key) + ": " + TicketFieldSettingsManager.MSG.getMsg("fields.validation.duplicateSelectOptions", new Object[]{option}));
                    }
                    uniqueOptions.add(option);
                }
            }
            for (AndBlock block : section.getConditions()) {
                for (FormCondition c : block.getConditions()) {
                    FieldType<?> fieldType;
                    block50: {
                        if (StringFunctions.isEmpty((String)c.getFieldKey())) {
                            throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.condition.noFieldKey", new Object[]{sectionIndex + 1}));
                        }
                        if (c.isForTicketValue()) {
                            TicketField fieldByKey = Tickets.getFieldByKey((String)c.getFieldKey());
                            if (fieldByKey == null && (fieldByKey = Tickets.getAttributeByKey((String)c.getFieldKey())) == null) {
                                throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.condition.noFieldKey", new Object[]{sectionIndex + 1}));
                            }
                            fieldType = fieldByKey.getFieldType();
                        } else {
                            FormField formField = (FormField)fieldMap.get(c.getFieldKey());
                            if (formField != null) {
                                try {
                                    fieldType = formField.getFieldType();
                                    break block50;
                                }
                                catch (IllegalStateException ex) {
                                    continue;
                                }
                            }
                            throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.condition.noFieldKey", new Object[]{sectionIndex + 1}));
                        }
                    }
                    if (!this.operatorAllowedForType(c.getOperator(), fieldType)) {
                        throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.condition.operatorMismatch", new Object[]{FormField.getFieldDataTypeLabel(this.findFieldDataType(fieldMap, c.getFieldKey(), sectionIndex)), c.getOperator(), sectionIndex + 1}));
                    }
                    if (this.submitType != 1) continue;
                    if (!allFieldKeys.contains(c.getFieldKey())) {
                        throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.condition.invalidFieldKey", new Object[]{this.getFieldLabelElseKey(fieldMap, c.getFieldKey()), sectionIndex + 1}));
                    }
                    if ((Integer)field_EarliestSectionMap.get(c.getFieldKey()) < sectionIndex) continue;
                    throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.condition.fieldNotInPreviousSection", new Object[]{this.getFieldLabelElseKey(fieldMap, c.getFieldKey()), sectionIndex + 1}));
                }
            }
        }
        if (this.sections.stream().allMatch(s -> s.getActions().isEmpty())) {
            throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.noAction", new Object[0]));
        }
        switch (this.submitType) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown submittype: " + this.submitType);
            }
        }
        if (this.sections.stream().anyMatch(s -> s.getActions().stream().anyMatch(sa -> sa.getType() != this.submitType))) {
            throw new ClientMessageException("Can only set submitTypes matching the submitTypes of the form");
        }
        try (UserAccountScope p = UserAccountScope.createPrivileged();){
            folder = FormsManager.getInstance().getFolder(this.parentFolderId);
        }
        if (folder == null) {
            throw new IllegalStateException("folder does not exist: " + String.valueOf(this.parentFolderId));
        }
        if (folder.getSharings() == null) {
            this.getSections().forEach(s -> s.getFields().forEach(f -> {
                if (f.getFieldDataType().equals("ticketowner") && f.getVisibility() != FormField.FormFieldVisibility.Hidden) {
                    throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.publicFormCannotSelectUser", new Object[0]));
                }
            }));
        }
        if ((this.maxAttachmentSizeMb <= 0 || (long)this.maxAttachmentSizeMb > 2048L) && this.sections.stream().anyMatch(s -> s.getFields().stream().anyMatch(f -> f.getFieldDataType().equals("attachmentsadd")))) {
            throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.invalidMaxAttachmentSize", new Object[0]));
        }
        if (this.submitType == 1 && !foundSubjectOrFieldForText) {
            throw new ClientMessageException(FormsServerPlugin.MSG_CLIENT.getMsg("ticketForms.configuration.validate.mandatoryText", new Object[0]));
        }
        if (this.submitType == 2 && (doesmanualEscalation = this.sections.stream().anyMatch(s -> s.getActions().stream().anyMatch(a -> a.getType() == 2 && a.getActionId() != null && a.getActionId() == 8))) && (noResourceField = this.sections.stream().noneMatch(s -> s.getFields().stream().anyMatch(f -> f.getFormFieldType() == FormField.FormFieldType.Ticket && f.getKey().equals(Tickets.FIELD_RESOURCE_GUID.getKey()))))) {
            String actionName = ((ActionVO)ActionManager.getInstance().get(8)).getDisplayValue();
            String resFieldName = Tickets.FIELD_RESOURCE_GUID.getLabel();
            throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.resourceMissingForManualEscalation", new Object[]{actionName, resFieldName}));
        }
    }

    @Nonnull
    private String findFieldDataType(Map<String, FormField> fieldMap, String fieldKey, int sectionIndex) {
        TicketFieldDefinition def;
        FormField formField = fieldMap.get(fieldKey);
        if (formField != null) {
            return formField.getFieldDataType();
        }
        if (this.submitType == 2 && (def = Tickets.getFieldDefinitionByKey((String)fieldKey)) != null) {
            return def.getEditDefinition().getDisplayType();
        }
        throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.condition.invalidFieldKey", new Object[]{this.getFieldLabelElseKey(fieldMap, fieldKey), sectionIndex + 1}));
    }

    private String getFieldLabelElseKey(Map<String, FormField> keyToFieldMap, String fieldKey) {
        FormField field = keyToFieldMap.get(fieldKey);
        return field != null && field.getLabel() != null && !field.getLabel().isEmpty() ? field.getLabel() : fieldKey;
    }

    private boolean operatorAllowedForType(FieldOperator operator, FieldType<?> fieldType) {
        return fieldType.getSupportedOperators().contains(operator);
    }

    public int getSubmitType() {
        return this.submitType;
    }

    public boolean isShowOnStartPage() {
        return this.showOnStartPage;
    }

    @Nullable
    public String getStartPageLinkName() {
        return this.startPageLinkName;
    }

    @Nullable
    public String getStartPageLinkDescription() {
        return this.startPageLinkDescription;
    }

    public boolean isUseFormLogo() {
        return this.useFormLogo;
    }

    public int getMaxAttachmentSizeMb() {
        return this.maxAttachmentSizeMb;
    }
}

