/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.ticketlist;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDescription;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.forms.ReaStepFieldFormId;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AdditionalReaStepFieldDefinitionFormId
extends AdditionalReaStepFieldDefinition<GUID> {
    public AdditionalReaStepFieldDefinitionFormId() {
        super((ReaStepField)ReaStepFieldFormId.INSTANCE);
    }

    public List<AdditionalReaStepFieldDescription> convertToDescriptions(ReaStepVO step, Set<Integer> availableStepsIds) {
        if (step == null) {
            return null;
        }
        GUID formId = (GUID)step.getValue((ReaStepField)ReaStepFieldFormId.INSTANCE);
        if (formId == null) {
            return null;
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return null;
        }
        boolean haveTemplateRights = SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION});
        if (!haveTemplateRights && !HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
            return null;
        }
        ArrayList<AdditionalReaStepFieldDescription> list = new ArrayList<AdditionalReaStepFieldDescription>();
        HashMap<String, Object> linkValues = new HashMap<String, Object>();
        linkValues.put("iconclass", "icon-additionalreastepfield-form");
        try {
            HDForm form = FormsManager.getInstance().getForm(formId);
            if (form != null) {
                if (haveTemplateRights) {
                    linkValues.put("url", "configmanager/page/configuration.ticketforms/editform/" + String.valueOf(formId));
                    linkValues.put("title", FormsServerPlugin.MSG.getMsg("ticketlist.additionalreastepfield.form.title", new Object[]{form.getName()}));
                } else {
                    linkValues.put("title", FormsServerPlugin.MSG.getMsg("ticketlist.additionalreastepfield.form.appliedwithtitle", new Object[]{form.getName()}));
                }
                list.add(new AdditionalReaStepFieldDescription("externallink", linkValues));
                return list;
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        linkValues.put("title", FormsServerPlugin.MSG.getMsg("ticketlist.additionalreastepfield.form.applied", new Object[0]));
        list.add(new AdditionalReaStepFieldDescription("externallink", linkValues));
        return list;
    }
}

