/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.ticketlist;

import com.inet.helpdesk.plugins.forms.client.data.config.LoadAvailableTicketCreationFormEntriesResponse;
import com.inet.helpdesk.plugins.forms.client.data.model.SingleFormEntryDescription;
import com.inet.helpdesk.plugins.forms.server.util.LoadFormEntriesUtil;
import com.inet.http.servlet.ClientLocale;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LoadAvailableTicketCreationFormEntries
extends ServiceMethod<Void, LoadAvailableTicketCreationFormEntriesResponse> {
    public String getMethodName() {
        return "ticketforms.loadavailableticketcreationforms";
    }

    public short getMethodType() {
        return 1;
    }

    public LoadAvailableTicketCreationFormEntriesResponse invoke(HttpServletRequest req, HttpServletResponse resp, Void payload) throws IOException {
        ArrayList<SingleFormEntryDescription> entries = new ArrayList();
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return new LoadAvailableTicketCreationFormEntriesResponse(entries);
        }
        entries = LoadFormEntriesUtil.getTicketCreationFormEntries();
        this.sortRecursively(entries);
        return new LoadAvailableTicketCreationFormEntriesResponse(entries);
    }

    private void sortRecursively(List<SingleFormEntryDescription> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());
        Collections.sort(entries, (e1, e2) -> {
            if (e1.isFolder() != e2.isFolder()) {
                return e1.isFolder() ? -1 : 1;
            }
            int labelCompare = collator.compare(e1.getLabel(), e2.getLabel());
            if (labelCompare != 0) {
                return labelCompare;
            }
            return e1.getId().toString().compareTo(e2.getId().toString());
        });
        for (SingleFormEntryDescription entry : entries) {
            this.sortRecursively(entry.getChildren());
        }
    }
}

